/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.IConditionElement;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.shed.presenter.ActionPatternPresenter;
import cz.cuni.pogamut.shed.presenter.ActionPresenter;
import cz.cuni.pogamut.shed.presenter.ActionsPresenter;
import cz.cuni.pogamut.shed.presenter.ChoicePresenter;
import cz.cuni.pogamut.shed.presenter.ChoicesPresenter;
import cz.cuni.pogamut.shed.presenter.CompetencePresenter;
import cz.cuni.pogamut.shed.presenter.DCPresenter;
import cz.cuni.pogamut.shed.presenter.DrivePresenter;
import cz.cuni.pogamut.shed.presenter.ExpandedActionPresenter;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.presenter.IPresenterFactory;
import cz.cuni.pogamut.shed.presenter.SensePresenter;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.presenter.TriggerPresenter;
import cz.cuni.pogamut.shed.widget.ExpandedActionEnvelope;
import cz.cuni.pogamut.shed.widget.ShedActionsEnvelope;
import cz.cuni.pogamut.shed.widget.ShedChoicesEnvelope;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedSenseWidget;
import cz.cuni.pogamut.shed.widget.ShedTriggerEnvelope;
import cz.cuni.pogamut.shed.widget.ShedWidget;

public class ShedPresenterFactory
implements IPresenterFactory {
    private final ShedScene scene;
    private final ShedPresenter presenter;
    private final PoshPlan plan;

    public ShedPresenterFactory(ShedScene scene, PoshPlan plan, ShedPresenter presenter) {
        this.plan = plan;
        this.scene = scene;
        this.presenter = presenter;
    }

    @Override
    public IPresenter createActionPresenter(LapPath actionPath, ShedWidget actionWidget) {
        LapChain actionChain = LapChain.fromPath((PoshPlan)this.plan, (LapPath)actionPath);
        TriggeredAction action = (TriggeredAction)actionPath.traversePath(this.plan);
        return new ActionPresenter(this.scene, this.presenter, action, actionWidget, actionChain);
    }

    @Override
    public IPresenter createExpandedActionPresenter(LapPath actionPath, ExpandedActionEnvelope envelope) {
        LapChain chainWithoutAction = LapChain.fromPath((PoshPlan)this.plan, (LapPath)actionPath.subpath(0, actionPath.length() - 1));
        TriggeredAction action = (TriggeredAction)actionPath.traversePath(this.plan);
        return new ExpandedActionPresenter(this.scene, this.presenter, envelope, action, chainWithoutAction);
    }

    @Override
    public IPresenter createSensePresenter(LapPath sensePath, ShedSenseWidget senseWidget) {
        LapChain senseChain = LapChain.fromPath((PoshPlan)this.plan, (LapPath)sensePath);
        Sense sense = (Sense)sensePath.traversePath(this.plan);
        return new SensePresenter(this.scene, this.presenter, sense, senseWidget, senseChain);
    }

    @Override
    public <TRIGGER_PARENT extends PoshElement> IPresenter createTriggerPresenter(LapPath triggerOwner, ShedTriggerEnvelope triggerEnvelope) {
        LapChain ownerChain = LapChain.fromPath((PoshPlan)this.plan, (LapPath)triggerOwner);
        PoshElement owner = triggerOwner.traversePath(this.plan);
        Trigger condition = ((IConditionElement)owner).getCondition();
        return new TriggerPresenter<PoshElement>(this.scene, this.presenter, triggerEnvelope, owner, condition, ownerChain);
    }

    @Override
    public IPresenter createDriveCollectionPresenter(LapPath driveCollectionPath) {
        DriveCollection driveCollection = (DriveCollection)driveCollectionPath.traversePath(this.plan);
        return new DCPresenter(this.scene, this.presenter, driveCollection);
    }

    @Override
    public IPresenter createActionPatternPresenter(LapPath actionPatternPath, ShedWidget actionPatternWidget) {
        ActionPattern actionPattern = (ActionPattern)actionPatternPath.traversePath(this.plan);
        LapPath referencePath = actionPatternPath.subpath(0, actionPatternPath.length() - 1);
        TriggeredAction referencingAction = (TriggeredAction)referencePath.traversePath(this.plan);
        LapChain actionPatternChain = LapChain.fromPath((PoshPlan)this.plan, (LapPath)actionPatternPath);
        return new ActionPatternPresenter(this.scene, this.presenter, referencingAction, actionPattern, actionPatternWidget, actionPatternChain);
    }

    @Override
    public IPresenter createCompetencePresenter(LapPath competencePath, ShedWidget competenceWidget) {
        LapChain competenceChain = LapChain.fromPath((PoshPlan)this.plan, (LapPath)competencePath);
        Competence competence = (Competence)competencePath.traversePath(this.plan);
        LapPath referencePath = competencePath.subpath(0, competencePath.length() - 1);
        TriggeredAction referencingAction = (TriggeredAction)referencePath.traversePath(this.plan);
        return new CompetencePresenter(this.scene, this.presenter, referencingAction, competence, competenceWidget, competenceChain);
    }

    @Override
    public IPresenter createChoicePresenter(LapPath choicePath, ShedWidget choiceWidget) {
        CompetenceElement choice = (CompetenceElement)choicePath.traversePath(this.plan);
        return new ChoicePresenter(this.scene, this.presenter, choice, choiceWidget);
    }

    @Override
    public IPresenter createDrivePresenter(LapPath drivePath, ShedWidget widget) {
        DriveElement drive = (DriveElement)drivePath.traversePath(this.plan);
        return new DrivePresenter(this.scene, this.presenter, drive, widget);
    }

    @Override
    public IPresenter createActionsPresenter(LapPath actionPatternPath, ShedActionsEnvelope actionsEnvelope) {
        LapChain actionPatternChain = LapChain.fromPath((PoshPlan)this.plan, (LapPath)actionPatternPath);
        ActionPattern actionPattern = (ActionPattern)actionPatternPath.traversePath(this.plan);
        return new ActionsPresenter(this.scene, this.presenter, actionsEnvelope, actionPattern, actionPatternChain);
    }

    @Override
    public IPresenter createChoicesPresenter(LapPath competencePath, ShedChoicesEnvelope choicesEnvelope) {
        LapChain competenceChain = LapChain.fromPath((PoshPlan)this.plan, (LapPath)competencePath);
        Competence competence = (Competence)competencePath.traversePath(this.plan);
        return new ChoicesPresenter(this.scene, this.presenter, choicesEnvelope, competence, competenceChain);
    }
}

