/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.IParametrizedElement;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.shed.widget.editor.ArgumentsTableModel;
import cz.cuni.pogamut.shed.widget.editor.ParametersTableModel;
import cz.cuni.pogamut.shed.widget.editor.TableArgument;
import cz.cuni.pogamut.shed.widget.editor.TableParameter;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

class ParametrizedElementEditor
extends JPanel {
    private final InplaceEditorProvider.EditorController editorController;
    private final JTextField nameTextField;
    private final JButton addVariable;
    private final JButton removeVariable;
    private final JTable parametersTable;
    private final JButton addArgBtn;
    private final JButton removeArgBtn;
    private final ArgumentsTableModel argumentsModel;
    private final JTable argumentsTable;
    private final ActionListener addArgumentListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object defaultValue;
            String title = "New argument";
            NotifyDescriptor.InputLine parameterNameDialog = new NotifyDescriptor.InputLine("Specify name of the argument (must start with $)", title);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)parameterNameDialog) != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String argumentName = parameterNameDialog.getInputText().trim();
            if (!Result.isVariableName((String)argumentName)) {
                NotifyDescriptor.Message paramNameWrong = new NotifyDescriptor.Message((Object)"Wrong name of argument.\nName must match regular expression: \\$[a-zA-Z]([_\\-a-zA-Z0-9])*");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)paramNameWrong);
                return;
            }
            NotifyDescriptor.InputLine defaultParameterValue = new NotifyDescriptor.InputLine("Specify the value of the argument(string, integer, double or nil):", title);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)defaultParameterValue) != NotifyDescriptor.OK_OPTION) {
                return;
            }
            try {
                String defaultValueString = defaultParameterValue.getInputText().trim();
                defaultValue = Result.parseValue((String)defaultValueString);
            }
            catch (ParseException ex) {
                NotifyDescriptor.Message paramNameWrong = new NotifyDescriptor.Message((Object)("Wrong default value of parameter.\nParsing error: " + ex.getMessage()));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)paramNameWrong);
                return;
            }
            int addIndex = ParametrizedElementEditor.this.argumentsTable.getSelectedRow();
            if (addIndex == -1) {
                addIndex = ParametrizedElementEditor.this.argumentsTable.getRowCount();
            }
            ParametrizedElementEditor.this.argumentsModel.addArgument(addIndex, argumentName, defaultValue);
            ParametrizedElementEditor.this.editorController.notifyEditorComponentBoundsChanged();
        }
    };
    private final ActionListener removeArgumentListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = ParametrizedElementEditor.this.argumentsTable.getSelectedRow();
            if (index != -1) {
                ParametrizedElementEditor.this.argumentsModel.deleteArgument(index);
            }
        }
    };
    private final ParametersTableModel parametersModel;
    private final ActionListener addParameterListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object defaultValue;
            String title = "New parameter";
            NotifyDescriptor.InputLine parameterNameDialog = new NotifyDescriptor.InputLine("Specify name of the parameter (must start with $, e.g $foo)", title);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)parameterNameDialog) != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String parameterName = parameterNameDialog.getInputText().trim();
            if (!Result.isVariableName((String)parameterName)) {
                NotifyDescriptor.Message paramNameWrong = new NotifyDescriptor.Message((Object)"Wrong name of parameter.\nName must match regular expression: \\$[a-zA-Z]([_\\-a-zA-Z0-9])*");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)paramNameWrong);
                return;
            }
            NotifyDescriptor.InputLine defaultParameterValue = new NotifyDescriptor.InputLine("Specify the default value of the new parameter(string, integer, double, bool or nil):", title);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)defaultParameterValue) != NotifyDescriptor.OK_OPTION) {
                return;
            }
            try {
                String defaultValueString = defaultParameterValue.getInputText().trim();
                defaultValue = Result.parseValue((String)defaultValueString);
            }
            catch (ParseException ex) {
                NotifyDescriptor.Message paramNameWrong = new NotifyDescriptor.Message((Object)("Wrong default value of parameter.\nParsing error: " + ex.getMessage()));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)paramNameWrong);
                return;
            }
            int addIndex = ParametrizedElementEditor.this.parametersTable.getSelectedRow();
            if (addIndex == -1) {
                addIndex = ParametrizedElementEditor.this.parametersTable.getRowCount();
            }
            ParametrizedElementEditor.this.parametersModel.addParameter(addIndex, parameterName, defaultValue);
            ParametrizedElementEditor.this.editorController.notifyEditorComponentBoundsChanged();
        }
    };
    private final ActionListener removeVariableListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = ParametrizedElementEditor.this.parametersTable.getSelectedRow();
            if (index != -1) {
                ParametrizedElementEditor.this.parametersModel.deleteVariable(index);
            }
        }
    };

    public ParametrizedElementEditor(IParametrizedElement parametrizedElement, String elementName, TriggeredAction action, InplaceEditorProvider.EditorController controller) {
        assert (elementName.equals(action.getName()));
        this.editorController = controller;
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.nameTextField = new JTextField();
        this.nameTextField.setText(elementName);
        this.add(this.nameTextField);
        this.addVariable = new JButton("Add parameter");
        this.addVariable.addActionListener(this.addParameterListener);
        this.add(this.addVariable);
        this.removeVariable = new JButton("Remove parameter");
        this.removeVariable.addActionListener(this.removeVariableListener);
        this.add(this.removeVariable);
        FormalParameters params = parametrizedElement.getParameters();
        Arguments args = action.getArguments();
        this.parametersModel = new ParametersTableModel(params, args);
        this.parametersTable = new JTable(this.parametersModel);
        this.add(this.parametersTable.getTableHeader());
        this.add(this.parametersTable);
        this.addArgBtn = new JButton("Add argument");
        this.addArgBtn.addActionListener(this.addArgumentListener);
        this.add(this.addArgBtn);
        this.removeArgBtn = new JButton("Remove argument");
        this.removeArgBtn.addActionListener(this.removeArgumentListener);
        this.add(this.removeArgBtn);
        this.argumentsModel = new ArgumentsTableModel(params, args);
        this.argumentsTable = new JTable(this.argumentsModel);
        this.add(this.argumentsTable.getTableHeader());
        this.add(this.argumentsTable);
    }

    String getElementName() {
        return this.nameTextField.getText().trim();
    }

    public List<TableParameter> getParameters() {
        return this.parametersModel.getParameters();
    }

    public List<TableArgument> getArguments() {
        return this.argumentsModel.getArguments();
    }
}

