/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.MissingParameterException;
import cz.cuni.pogamut.shed.widget.editor.APEditor;
import cz.cuni.pogamut.shed.widget.editor.TableArgument;
import cz.cuni.pogamut.shed.widget.editor.TableParameter;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.List;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.widget.Widget;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public final class APEditorProvider
implements InplaceEditorProvider<APEditor> {
    private final ActionPattern actionPattern;
    private final TriggeredAction referencingAction;
    private KeyListener keyListener;

    public APEditorProvider(ActionPattern actionPattern, TriggeredAction referencingAction) {
        this.actionPattern = actionPattern;
        this.referencingAction = referencingAction;
    }

    public void notifyOpened(InplaceEditorProvider.EditorController controller, Widget widget, APEditor editor) {
    }

    private void notify(String message) {
        NotifyDescriptor.Message infoMessage = new NotifyDescriptor.Message((Object)message, 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)infoMessage);
    }

    public void notifyClosing(InplaceEditorProvider.EditorController editorController, Widget widget, APEditor editor, boolean commit) {
        if (commit) {
            String newAPName;
            String oldAPName = this.actionPattern.getName();
            if (!oldAPName.equals(newAPName = editor.getElementName())) {
                String errorMessage;
                try {
                    this.actionPattern.rename(newAPName);
                }
                catch (InvalidNameException ex) {
                    errorMessage = MessageFormat.format("Name \"{0}\" is not valid", newAPName);
                    this.notify(errorMessage);
                }
                catch (CycleException ex) {
                    errorMessage = MessageFormat.format("Changing name to \"{0}\" would cause a cycle.", newAPName);
                    this.notify(errorMessage);
                }
                catch (DuplicateNameException ex) {
                    errorMessage = MessageFormat.format("Name \"{0}\" is already used.", newAPName);
                    this.notify(errorMessage);
                }
            }
            List<TableParameter> editorParams = editor.getParameters();
            FormalParameters newParams = new FormalParameters();
            for (TableParameter editorParam : editorParams) {
                String paramName = editorParam.getName();
                Object paramDefaultValue = editorParam.getDefaultValue();
                newParams.add((Object)new FormalParameters.Parameter(paramName, paramDefaultValue));
            }
            try {
                this.actionPattern.setParameters(newParams);
            }
            catch (MissingParameterException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            List<TableArgument> editorArgs = editor.getArguments();
            Arguments newArgs = new Arguments();
            for (TableArgument editorArg : editorArgs) {
                newArgs.add((Object)editorArg.createArgument());
            }
            for (TableParameter editorParam : editorParams) {
                if (!editorParam.isOverriden()) continue;
                newArgs.add((Object)editorParam.createOverrideArgument());
            }
            this.referencingAction.setArguments(newArgs);
        }
    }

    public APEditor createEditorComponent(InplaceEditorProvider.EditorController controller, Widget widget) {
        APEditor editor = new APEditor(this.actionPattern, this.referencingAction, controller);
        return editor;
    }

    public Rectangle getInitialEditorComponentBounds(InplaceEditorProvider.EditorController controller, Widget widget, APEditor editor, Rectangle viewBounds) {
        return new Rectangle(600, 300);
    }

    public EnumSet<InplaceEditorProvider.ExpansionDirection> getExpansionDirections(InplaceEditorProvider.EditorController ec, Widget widget, APEditor c) {
        return EnumSet.of(InplaceEditorProvider.ExpansionDirection.BOTTOM, InplaceEditorProvider.ExpansionDirection.RIGHT);
    }
}

