/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.pogamut.shed.presenter.AbstractPresenter;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.ArrowWidget;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedSenseWidget;
import cz.cuni.pogamut.shed.widget.ShedTriggerEnvelope;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;

final class TriggerPresenter<TRIGGER_PARENT extends PoshElement>
extends AbstractPresenter
implements IPresenter,
PoshElementListener<TRIGGER_PARENT> {
    private final ShedTriggerEnvelope triggerEnvelope;
    private final TRIGGER_PARENT parent;
    private final Trigger<TRIGGER_PARENT> trigger;
    private final LapChain chain;

    TriggerPresenter(ShedScene scene, ShedPresenter presenter, ShedTriggerEnvelope triggerEnvelope, TRIGGER_PARENT parent, Trigger<TRIGGER_PARENT> trigger, LapChain chain) {
        super(scene, presenter);
        this.triggerEnvelope = triggerEnvelope;
        this.parent = parent;
        this.trigger = trigger;
        this.chain = chain;
    }

    @Override
    public void register() {
        this.triggerEnvelope.setPresenter(this);
        this.parent.addElementListener((PoshElementListener)this);
    }

    @Override
    public void unregister() {
        this.parent.removeElementListener((PoshElementListener)this);
        this.triggerEnvelope.setPresenter(null);
    }

    @Override
    public Action[] getMenuActions() {
        return null;
    }

    public void childElementAdded(TRIGGER_PARENT parent, PoshElement child) {
        if (this.isSense(child)) {
            boolean addedSenseReplacesAnother;
            Sense addedSense = this.extractSense(this.trigger, child);
            LapChain newSenseChain = this.chain.derive((PoshElement)addedSense);
            LapPath branchToSensePath = LapPath.getLinkPath((PoshElement)addedSense);
            LapPath senseFragmentPath = branchToSensePath.subpath(1, branchToSensePath.length());
            LapPath addedSensePath = this.chain.toPath().concat(senseFragmentPath);
            ShedSenseWidget newSenseWidget = this.scene.getWidgetFactory().createSenseWidget(addedSensePath, addedSense, newSenseChain);
            int sensePosition = this.getPosition(this.trigger, addedSense);
            Anchor arrowSourceAnchor = this.getAnchorBeforePosition(sensePosition);
            boolean bl = addedSenseReplacesAnother = this.triggerEnvelope.numberOfChildren() > 0 && sensePosition != this.triggerEnvelope.numberOfChildren();
            if (addedSenseReplacesAnother) {
                ShedSenseWidget originalWidget = (ShedSenseWidget)this.triggerEnvelope.getChild(sensePosition);
                Anchor oldSenseAnchor = originalWidget.getCommonAnchor();
                Set<ArrowWidget> previousSenseArrow = this.scene.findArrows(arrowSourceAnchor, oldSenseAnchor);
                this.scene.removeArrows(previousSenseArrow);
            }
            this.triggerEnvelope.add(newSenseWidget, sensePosition);
            this.scene.update();
            if (addedSenseReplacesAnother) {
                ShedSenseWidget oldSenseWidget = (ShedSenseWidget)this.triggerEnvelope.getChild(sensePosition + 1);
                this.scene.addArrow(newSenseWidget.getCommonAnchor(), oldSenseWidget.getCommonAnchor());
            }
            Anchor arrowTargetAnchor = newSenseWidget.getCommonAnchor();
            this.scene.addArrow(arrowSourceAnchor, arrowTargetAnchor);
            this.scene.update();
        }
    }

    public void childElementMoved(TRIGGER_PARENT parent, PoshElement child, int oldIndex, int newIndex) {
        if (this.isSense(child)) {
            ShedSenseWidget senseWidget = (ShedSenseWidget)this.triggerEnvelope.getChild(oldIndex);
            this.scene.removeArrows(this.getSenseLeftArrow(oldIndex));
            this.scene.removeArrows(this.getSenseRightArrow(oldIndex));
            this.scene.removeArrows(this.getSenseLeftArrow(newIndex));
            this.scene.removeArrows(this.getSenseRightArrow(newIndex));
            this.triggerEnvelope.move(newIndex, senseWidget);
            for (int senseIndex = 0; senseIndex < this.triggerEnvelope.numberOfChildren(); ++senseIndex) {
                Set<ArrowWidget> leftArrow = this.getSenseLeftArrow(senseIndex);
                if (!leftArrow.isEmpty()) continue;
                this.addSenseLeftArrow(senseIndex);
            }
            this.scene.update();
        }
    }

    private void addSenseLeftArrow(int senseIndex) {
        ShedSenseWidget sense = (ShedSenseWidget)this.triggerEnvelope.getChild(senseIndex);
        Anchor sourceAnchor = this.getAnchorBeforePosition(senseIndex);
        Anchor targetAnchor = sense.getCommonAnchor();
        this.scene.addArrow(sourceAnchor, targetAnchor);
    }

    private Set<ArrowWidget> getSenseLeftArrow(int senseIndex) {
        ShedSenseWidget senseWidget = (ShedSenseWidget)this.triggerEnvelope.getChild(senseIndex);
        Anchor beforeSenseAnchor = this.getAnchorBeforePosition(senseIndex);
        return this.scene.findArrows(beforeSenseAnchor, senseWidget.getCommonAnchor());
    }

    private Set<ArrowWidget> getSenseRightArrow(int senseIndex) {
        boolean senseIsLast;
        boolean bl = senseIsLast = senseIndex == this.triggerEnvelope.numberOfChildren() - 1;
        if (!senseIsLast) {
            ShedSenseWidget senseWidget = (ShedSenseWidget)this.triggerEnvelope.getChild(senseIndex);
            ShedSenseWidget rightSenseWidget = (ShedSenseWidget)this.triggerEnvelope.getChild(senseIndex + 1);
            return this.scene.findArrows(senseWidget.getCommonAnchor(), rightSenseWidget.getCommonAnchor());
        }
        return Collections.emptySet();
    }

    public void childElementRemoved(TRIGGER_PARENT parent, PoshElement child, int removedChildIndex) {
        if (this.isSense(child)) {
            boolean triggerIsMissingArrow;
            ShedSenseWidget removedSenseWidget = (ShedSenseWidget)this.triggerEnvelope.getChild(removedChildIndex);
            this.triggerEnvelope.remove(removedSenseWidget);
            boolean triggerIsEmpty = this.triggerEnvelope.numberOfChildren() == 0;
            boolean removedSenseWasLast = removedChildIndex == this.triggerEnvelope.numberOfChildren();
            boolean bl = triggerIsMissingArrow = !triggerIsEmpty && !removedSenseWasLast;
            if (triggerIsMissingArrow) {
                Anchor sourceAnchor = this.getAnchorBeforePosition(removedChildIndex);
                Anchor targetAnchor = ((ShedSenseWidget)this.triggerEnvelope.getChild(removedChildIndex)).getCommonAnchor();
                this.scene.addArrow(sourceAnchor, targetAnchor);
            }
            this.scene.update();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private Anchor getAnchorBeforePosition(int position) {
        if (position == 0) {
            return this.triggerEnvelope.getCommonAnchor();
        }
        return ((ShedSenseWidget)this.triggerEnvelope.getChild(position - 1)).getCommonAnchor();
    }

    @Override
    public WidgetAction getEditAction() {
        return null;
    }
}

