/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.shed.presenter.ActionPatternPresenter;
import cz.cuni.pogamut.shed.presenter.ActionPresenter;
import cz.cuni.pogamut.shed.presenter.ActionsPresenter;
import cz.cuni.pogamut.shed.presenter.ChoicePresenter;
import cz.cuni.pogamut.shed.presenter.ChoicesPresenter;
import cz.cuni.pogamut.shed.presenter.CompetencePresenter;
import cz.cuni.pogamut.shed.presenter.DCPresenter;
import cz.cuni.pogamut.shed.presenter.DrivePresenter;
import cz.cuni.pogamut.shed.presenter.ExpandedActionPresenter;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.presenter.IPresenterFactory;
import cz.cuni.pogamut.shed.presenter.SensePresenter;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.presenter.TriggerPresenter;
import cz.cuni.pogamut.shed.widget.ExpandedActionEnvelope;
import cz.cuni.pogamut.shed.widget.ShedActionsEnvelope;
import cz.cuni.pogamut.shed.widget.ShedChoicesEnvelope;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedSenseWidget;
import cz.cuni.pogamut.shed.widget.ShedTriggerEnvelope;
import cz.cuni.pogamut.shed.widget.ShedVariableWidget;

public class ShedPresenterFactory
implements IPresenterFactory {
    private final ShedScene scene;
    private final ShedPresenter presenter;
    private final PoshPlan plan;

    public ShedPresenterFactory(ShedScene scene, PoshPlan plan, ShedPresenter presenter) {
        this.plan = plan;
        this.scene = scene;
        this.presenter = presenter;
    }

    @Override
    public IPresenter createActionPresenter(LapPath actionPath, TriggeredAction action, ShedVariableWidget actionWidget, LapChain actionChain) {
        assert (actionPath.traversePath(this.plan) == action);
        return new ActionPresenter(this.scene, this.presenter, action, actionWidget, actionChain);
    }

    @Override
    public IPresenter createExpandedActionPresenter(TriggeredAction action, ExpandedActionEnvelope envelope, LapChain chain) {
        return new ExpandedActionPresenter(this.scene, this.presenter, envelope, action, chain);
    }

    @Override
    public IPresenter createSensePresenter(LapPath sensePath, Sense sense, ShedSenseWidget senseWidget, LapChain senseChain) {
        assert (sensePath.traversePath(this.plan) == sense);
        return new SensePresenter(this.scene, this.presenter, sense, senseWidget, senseChain);
    }

    @Override
    public <TRIGGER_PARENT extends PoshElement> IPresenter createTriggerPresenter(TRIGGER_PARENT parent, Trigger<TRIGGER_PARENT> trigger, ShedTriggerEnvelope triggerEnvelope, LapChain chain) {
        return new TriggerPresenter<TRIGGER_PARENT>(this.scene, this.presenter, triggerEnvelope, parent, trigger, chain);
    }

    @Override
    public IPresenter createDriveCollectionPresenter(LapPath driveCollectionPath, DriveCollection driveCollection) {
        assert (driveCollectionPath.traversePath(this.plan) == driveCollection);
        return new DCPresenter(this.scene, this.presenter, driveCollection);
    }

    @Override
    public IPresenter createActionPatternPresenter(LapPath actionPatternPath, TriggeredAction referencingAction, ActionPattern actionPattern, ShedVariableWidget actionPatternWidget, LapChain chain) {
        LapPath referencePath = actionPatternPath.subpath(0, actionPatternPath.length() - 1);
        assert (referencePath.traversePath(this.plan) == referencingAction);
        assert (actionPatternPath.traversePath(this.plan) == actionPattern);
        return new ActionPatternPresenter(this.scene, this.presenter, referencingAction, actionPattern, actionPatternWidget, chain);
    }

    @Override
    public IPresenter createCompetencePresenter(LapPath competencePath, TriggeredAction referencingAction, Competence competence, ShedVariableWidget competenceWidget, LapChain chain) {
        LapPath referencePath = competencePath.subpath(0, competencePath.length() - 1);
        assert (referencePath.traversePath(this.plan) == referencingAction);
        assert (competencePath.traversePath(this.plan) == competence);
        return new CompetencePresenter(this.scene, this.presenter, referencingAction, competence, competenceWidget, chain);
    }

    @Override
    public IPresenter createChoicePresenter(LapPath choicePath, CompetenceElement choice, ShedVariableWidget choiceWidget) {
        assert (choicePath.traversePath(this.plan) == choice);
        return new ChoicePresenter(this.scene, this.presenter, choice, choiceWidget);
    }

    @Override
    public IPresenter createDrivePresenter(LapPath drivePath, DriveElement drive, ShedVariableWidget widget) {
        assert (drivePath.traversePath(this.plan) == drive);
        return new DrivePresenter(this.scene, this.presenter, drive, widget);
    }

    @Override
    public IPresenter createActionsPresenter(LapPath actionPatternPath, ActionPattern actionPattern, ShedActionsEnvelope actionsEnvelope, LapChain chain) {
        assert (actionPatternPath.traversePath(this.plan) == actionPattern);
        return new ActionsPresenter(this.scene, this.presenter, actionsEnvelope, actionPattern, chain);
    }

    @Override
    public IPresenter createChoicesPresenter(LapPath competencePath, Competence competence, ShedChoicesEnvelope choicesEnvelope, LapChain chain) {
        assert (competencePath.traversePath(this.plan) == competence);
        return new ChoicesPresenter(this.scene, this.presenter, choicesEnvelope, competence, chain);
    }
}

