/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.ILapChainListener;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.pogamut.shed.presenter.AbstractAcceptAction;
import cz.cuni.pogamut.shed.presenter.AbstractPresenter;
import cz.cuni.pogamut.shed.presenter.AcceptActionFactory;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.presenter.ShedInplaceEditorFactory;
import cz.cuni.pogamut.shed.presenter.ShedMenuActionFactory;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedVariableWidget;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.WidgetAction;

final class ActionPatternPresenter
extends AbstractPresenter
implements IPresenter,
PoshElementListener<ActionPattern>,
ILapChainListener {
    private final TriggeredAction referencingAction;
    private final ActionPattern actionPattern;
    private final ShedVariableWidget actionPatternWidget;
    private final LapChain chain;

    ActionPatternPresenter(ShedScene scene, ShedPresenter presenter, TriggeredAction referencingAction, ActionPattern actionPattern, ShedVariableWidget actionPatternWidget, LapChain chain) {
        super(scene, presenter);
        assert (referencingAction.getName().equals(actionPattern.getName()));
        this.referencingAction = referencingAction;
        this.actionPattern = actionPattern;
        this.actionPatternWidget = actionPatternWidget;
        this.chain = chain;
        this.updateWidget();
    }

    @Override
    public void register() {
        this.actionPatternWidget.setPresenter(this);
        this.actionPattern.addElementListener((PoshElementListener)this);
        this.referencingAction.addElementListener((PoshElementListener)this);
        this.chain.register();
        this.chain.addChainListener((ILapChainListener)this);
    }

    @Override
    public void unregister() {
        this.chain.removeChainListener((ILapChainListener)this);
        this.chain.unregister();
        this.referencingAction.removeElementListener((PoshElementListener)this);
        this.actionPattern.removeElementListener((PoshElementListener)this);
        this.actionPatternWidget.setPresenter(null);
    }

    @Override
    public Action[] getMenuActions() {
        PoshElement parentStructure = this.referencingAction.getParent();
        if (this.isActionPattern(parentStructure)) {
            ActionPattern parentAP = (ActionPattern)parentStructure;
            int thisAPPosition = this.getPosition(parentAP.getActions(), this.referencingAction);
            return new Action[]{ShedMenuActionFactory.appendAction(this.actionPattern, 0), ShedMenuActionFactory.changeActionPatternParameters(this.actionPattern), ShedMenuActionFactory.deleteAction(parentAP, thisAPPosition)};
        }
        return new Action[]{ShedMenuActionFactory.appendAction(this.actionPattern, 0), ShedMenuActionFactory.changeActionPatternParameters(this.actionPattern)};
    }

    public void childElementAdded(ActionPattern parent, PoshElement child) {
    }

    public void childElementMoved(ActionPattern parent, PoshElement child, int oldIndex, int newIndex) {
    }

    public void childElementRemoved(ActionPattern parent, PoshElement child, int removedChildIndex) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (!(propertyName.equals("taAruments") || propertyName.equals("taName") || propertyName.equals("apName") || propertyName.equals("apParams"))) {
            throw new IllegalArgumentException(propertyName);
        }
        this.updateWidget();
    }

    @Override
    public AbstractAcceptAction[] getAcceptProviders() {
        return new AbstractAcceptAction[]{AcceptActionFactory.createCompetence2Action(this.referencingAction), AcceptActionFactory.createActionPatternAction(this.referencingAction), AcceptActionFactory.createAction2Action(this.referencingAction)};
    }

    private void updateWidget() {
        StringBuilder displayText = new StringBuilder();
        displayText.append(this.referencingAction.getName());
        Arguments args = this.referencingAction.getArguments();
        FormalParameters params = this.actionPattern.getParameters();
        VariableContext ctx = this.chain.createContext();
        List<String> variablesRepresentation = ActionPatternPresenter.getDefinedVariablesRepresentation(ctx, params, args);
        this.actionPatternWidget.setPresent(variablesRepresentation);
        this.actionPatternWidget.setMissing(Collections.<String>emptyList());
        List<String> argsRepresentation = ActionPatternPresenter.getOtherVariables(ctx, params, args);
        this.actionPatternWidget.setUnused(argsRepresentation);
        this.actionPatternWidget.setDisplayName(this.referencingAction.getName());
        this.actionPatternWidget.revalidate();
    }

    public void notifyLinkChanged() {
        this.updateWidget();
    }

    static List<String> getDefinedVariablesRepresentation(VariableContext ctx, FormalParameters params, Arguments args) {
        LinkedList<String> variablesRepresentation = new LinkedList<String>();
        for (FormalParameters.Parameter param : params) {
            String paramName = param.getName();
            Object paramValue = ctx.getValue(paramName);
            String paramRepresentation = paramName + '=' + Result.toLap((Object)paramValue);
            variablesRepresentation.add(paramRepresentation);
        }
        for (Arguments.Argument arg : args) {
            String argName = arg.getParameterName();
            if (params.containsVariable(argName)) continue;
            Object argValue = ctx.getValue(argName);
            String argRepresentation = argName + '=' + Result.toLap((Object)argValue);
            variablesRepresentation.add(argRepresentation);
        }
        return variablesRepresentation;
    }

    static List<String> getOtherVariables(VariableContext ctx, FormalParameters params, Arguments args) {
        String[] allVariables;
        LinkedList<String> otherVariables = new LinkedList<String>();
        for (String variableName : allVariables = ctx.getKeys()) {
            boolean nameIsUsed = false;
            for (Arguments.Argument arg : args) {
                if (!arg.getParameterName().equals(variableName)) continue;
                nameIsUsed = true;
            }
            if (params.containsVariable(variableName)) {
                nameIsUsed = true;
            }
            if (nameIsUsed) continue;
            Object variableValue = ctx.getValue(variableName);
            String variableRepresentation = variableName + '=' + Result.toLap((Object)variableValue);
            otherVariables.add(variableRepresentation);
        }
        return otherVariables;
    }

    @Override
    public WidgetAction getEditAction() {
        return ActionFactory.createInplaceEditorAction((InplaceEditorProvider)ShedInplaceEditorFactory.createActionPatternEditor(this.actionPattern, this.referencingAction));
    }
}

