/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.IParametrizedElement;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

/**
 * Basic editor for elements (AP and C) that can have passed arguments and also
 * have some parameters.
 *
 * @author Honza
 */
class ParametrizedElementEditor extends JPanel {

    private final InplaceEditorProvider.EditorController editorController;
    private final JTextField nameTextField;
    private final JButton addVariable;
    private final JButton removeVariable;
    /**
     * Table that represents the parameters of the call
     */
    private final JTable parametersTable;
    private final JButton addArgBtn;
    private final JButton removeArgBtn;
    private final ArgumentsTableModel argumentsModel;
    /**
     * This table represents arguments of the call.
     */
    private final JTable argumentsTable;
    private final ActionListener addArgumentListener = new ActionListener() {

        @Override
        public void actionPerformed(ActionEvent e) {
            String title = "New argument";
            NotifyDescriptor.InputLine parameterNameDialog = new NotifyDescriptor.InputLine("Specify name of the argument (must start with $)", title);

            if (DialogDisplayer.getDefault().notify(parameterNameDialog) != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String argumentName = parameterNameDialog.getInputText().trim();
            if (!Result.isVariableName(argumentName)) {
                NotifyDescriptor.Message paramNameWrong = new NotifyDescriptor.Message("Wrong name of argument.\nName must match regular expression: " + Result.variableNameRegexp);
                DialogDisplayer.getDefault().notify(paramNameWrong);
                return;
            }

            NotifyDescriptor.InputLine defaultParameterValue = new NotifyDescriptor.InputLine("Specify the value of the argument(string, integer, double or nil):", title);
            if (DialogDisplayer.getDefault().notify(defaultParameterValue) != NotifyDescriptor.OK_OPTION) {
                return;
            }
            Object defaultValue;
            try {
                String defaultValueString = defaultParameterValue.getInputText().trim();
                defaultValue = Result.parseValue(defaultValueString);
            } catch (ParseException ex) {
                NotifyDescriptor.Message paramNameWrong = new NotifyDescriptor.Message("Wrong default value of parameter.\nParsing error: " + ex.getMessage());
                DialogDisplayer.getDefault().notify(paramNameWrong);
                return;
            }

            int addIndex = argumentsTable.getSelectedRow();
            if (addIndex == -1) {
                addIndex = argumentsTable.getRowCount();
            }
            argumentsModel.addArgument(addIndex, argumentName, defaultValue);
            editorController.notifyEditorComponentBoundsChanged();
        }
    };
    private final ActionListener removeArgumentListener = new ActionListener() {

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = argumentsTable.getSelectedRow();
            if (index != -1) {
                argumentsModel.deleteArgument(index);
            }
        }
    };
    private final ParametersTableModel parametersModel;
    /**
     * This listener handles situation when used adds new parameter
     */
    private final ActionListener addParameterListener = new ActionListener() {

        @Override
        public void actionPerformed(ActionEvent e) {
            String title = "New parameter";
            NotifyDescriptor.InputLine parameterNameDialog = new NotifyDescriptor.InputLine("Specify name of the parameter (must start with $, e.g $foo)", title);

            if (DialogDisplayer.getDefault().notify(parameterNameDialog) != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String parameterName = parameterNameDialog.getInputText().trim();
            if (!Result.isVariableName(parameterName)) {
                NotifyDescriptor.Message paramNameWrong = new NotifyDescriptor.Message("Wrong name of parameter.\nName must match regular expression: " + Result.variableNameRegexp);
                DialogDisplayer.getDefault().notify(paramNameWrong);
                return;
            }

            NotifyDescriptor.InputLine defaultParameterValue = new NotifyDescriptor.InputLine("Specify the default value of the new parameter(string, integer, double, bool or nil):", title);
            if (DialogDisplayer.getDefault().notify(defaultParameterValue) != NotifyDescriptor.OK_OPTION) {
                return;
            }
            Object defaultValue;
            try {
                String defaultValueString = defaultParameterValue.getInputText().trim();
                defaultValue = Result.parseValue(defaultValueString);
            } catch (ParseException ex) {
                NotifyDescriptor.Message paramNameWrong = new NotifyDescriptor.Message("Wrong default value of parameter.\nParsing error: " + ex.getMessage());
                DialogDisplayer.getDefault().notify(paramNameWrong);
                return;
            }

            int addIndex = parametersTable.getSelectedRow();
            if (addIndex == -1) {
                addIndex = parametersTable.getRowCount();
            }

            parametersModel.addParameter(addIndex, parameterName, defaultValue);
            editorController.notifyEditorComponentBoundsChanged();
        }
    };
    private final ActionListener removeVariableListener = new ActionListener() {

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = parametersTable.getSelectedRow();
            if (index != -1) {
                parametersModel.deleteVariable(index);
            }
        }
    };

    public ParametrizedElementEditor(IParametrizedElement parametrizedElement, String elementName, TriggeredAction action, InplaceEditorProvider.EditorController controller) {
        assert elementName.equals(action.getName());

        this.editorController = controller;

        setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
        setBorder(BorderFactory.createLineBorder(Color.BLACK));

        nameTextField = new JTextField();
        nameTextField.setText(elementName);
        add(nameTextField);

        addVariable = new JButton("Add parameter");
        addVariable.addActionListener(addParameterListener);
        add(addVariable);

        removeVariable = new JButton("Remove parameter");
        removeVariable.addActionListener(removeVariableListener);
        add(removeVariable);

        FormalParameters params = parametrizedElement.getParameters();
        Arguments args = action.getArguments();
        parametersModel = new ParametersTableModel(params, args);
        parametersTable = new JTable(parametersModel);

        // by default, column header is not shown unless table is in JScrollPane
        add(parametersTable.getTableHeader());
        add(parametersTable);

        addArgBtn = new JButton("Add argument");
        addArgBtn.addActionListener(addArgumentListener);
        add(addArgBtn);

        removeArgBtn = new JButton("Remove argument");
        removeArgBtn.addActionListener(removeArgumentListener);
        add(removeArgBtn);

        argumentsModel = new ArgumentsTableModel(params, args);
        argumentsTable = new JTable(argumentsModel);
        add(argumentsTable.getTableHeader());
        add(argumentsTable);
    }

    /**
     * Get name user has supplied in the textfield.
     *
     * @return
     */
    String getElementName() {
        return nameTextField.getText().trim();
    }

    public List<TableParameter> getParameters() {
        return parametersModel.getParameters();
    }

    public List<TableArgument> getArguments() {
        return argumentsModel.getArguments();
    }
}
