/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;

class TableParameter {
    private String name;
    private String defaultValueString;
    private String argumentValueString;

    public TableParameter(String name, String defaultValueString, String argumentString) {
        this.name = name;
        this.defaultValueString = defaultValueString;
        this.argumentValueString = argumentString;
    }

    TableParameter(String name, String defaultValueString) {
        this(name, defaultValueString, "");
    }

    TableParameter(FormalParameters.Parameter param) {
        this(param.getName(), Result.toLap((Object)param.getDefaultValue()));
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValueString() {
        return this.defaultValueString;
    }

    public String getArgumentString() {
        return this.argumentValueString;
    }

    boolean isOverriden() {
        return !this.argumentValueString.isEmpty();
    }

    void setName(String newName) {
        this.name = newName;
    }

    Object getDefaultValue() {
        try {
            return Result.parseValue((String)this.defaultValueString);
        }
        catch (ParseException ex) {
            throw new FubarException("Default value " + this.defaultValueString + " should always be parsable.", (Throwable)ex);
        }
    }

    Arguments.Argument createOverrideArgument() {
        assert (!this.argumentValueString.isEmpty());
        if (Result.isVariableName((String)this.argumentValueString)) {
            return Arguments.Argument.createVariableArgument((String)this.name, (String)this.argumentValueString);
        }
        try {
            Object value = Result.parseValue((String)this.argumentValueString);
            return Arguments.Argument.createValueArgument((String)this.name, (Object)value);
        }
        catch (ParseException ex) {
            throw new FubarException("Argument string " + this.argumentValueString + " should be either variable or value.", (Throwable)ex);
        }
    }

    void setDefaultValueString(String valueString) throws ParseException {
        Result.parseValue((String)valueString);
        this.defaultValueString = valueString;
    }

    void setArgumentValueString(String valueString) throws ParseException {
        if (valueString.isEmpty()) {
            this.argumentValueString = valueString;
        } else if (Result.isVariableName((String)valueString)) {
            this.argumentValueString = valueString;
        } else {
            Result.parseValue((String)valueString);
            this.argumentValueString = valueString;
        }
    }
}

