/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.view;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.pogamut.posh.PoshDataObject;
import cz.cuni.pogamut.posh.explorer.CrawlerListener;
import cz.cuni.pogamut.posh.explorer.Explorer;
import cz.cuni.pogamut.posh.explorer.ExplorerFactory;
import cz.cuni.pogamut.posh.explorer.NameMapCrawler;
import cz.cuni.pogamut.posh.explorer.PrimitiveData;
import cz.cuni.pogamut.shed.view.TreeModificationListener;
import cz.cuni.pogamut.shed.widget.LapSceneFactory;
import cz.cuni.pogamut.shed.widget.ShedScene;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

final class LapTreeMVElement
extends JSplitPane
implements MultiViewElement {
    private final JToolBar toolbar;
    private MultiViewElementCallback callback;
    private final PoshDataObject dObj;
    private final PoshPlan lapTree;
    private final ShedScene scene;
    private static final String DEFAULT_DC_NAME = "life";
    private final TreeModificationListener saveListener;
    private final JScrollPane sceneScrollPane;
    private final JTabbedPane explorer;
    private final CrawlerListener<PrimitiveData> actionNameMapListener;
    private final CrawlerListener<PrimitiveData> sensesNameMapListener;
    private final Explorer<Competence> competencesExplorer;
    private final Explorer<ActionPattern> actionPatternsExplorer;

    LapTreeMVElement(PoshDataObject dObj) {
        super(1);
        this.dObj = dObj;
        this.lapTree = LapElementsFactory.createPlan((String)DEFAULT_DC_NAME);
        this.saveListener = new TreeModificationListener(this.lapTree, dObj.getEditorSupport().getDocument());
        this.scene = LapSceneFactory.createShedScene(this.lapTree);
        this.toolbar = this.createToolbarRepresentation();
        this.sceneScrollPane = new JScrollPane();
        this.sceneScrollPane.setViewportView(this.scene.createView());
        this.setLeftComponent(this.sceneScrollPane);
        this.explorer = new JTabbedPane();
        this.explorer.setPreferredSize(new Dimension(300, 1024));
        this.competencesExplorer = ExplorerFactory.createCompetenceExplorer(this.lapTree);
        this.explorer.addTab("Competences", this.competencesExplorer);
        this.actionPatternsExplorer = ExplorerFactory.createAPExplorer(this.lapTree);
        this.explorer.addTab("Action patterns", this.actionPatternsExplorer);
        Project project = this.getProject();
        this.actionNameMapListener = new NameMapCrawler(this.scene.getPresenter());
        this.sensesNameMapListener = new NameMapCrawler(this.scene.getPresenter());
        if (project != null) {
            this.explorer.addTab("Actions", ExplorerFactory.createActionsExplorer(project, this.actionNameMapListener));
            this.explorer.addTab("Senses", ExplorerFactory.createSensesExplorer(project, this.sensesNameMapListener));
        }
        this.setRightComponent(this.explorer);
        this.setResizeWeight(1.0);
    }

    private Project getProject() {
        return FileOwnerQuery.getOwner((FileObject)this.dObj.getPrimaryFile());
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public JComponent getToolbarRepresentation() {
        return this.toolbar;
    }

    public Action[] getActions() {
        if (this.callback != null) {
            return this.callback.createDefaultActions();
        }
        return new Action[0];
    }

    public Lookup getLookup() {
        return this.dObj.getNodeDelegate().getLookup();
    }

    public void componentOpened() {
        this.saveListener.register();
    }

    public void componentShowing() {
        PoshPlan documentLapTree;
        try {
            documentLapTree = this.dObj.parseLapPlan();
        }
        catch (ParseException ex) {
            this.sceneScrollPane.setViewportView(new JTextField(ex.getMessage()));
            return;
        }
        this.sceneScrollPane.setViewportView(this.scene.getView());
        this.lapTree.synchronize(documentLapTree);
        this.scene.update();
        this.competencesExplorer.recrawlElements();
        this.actionPatternsExplorer.recrawlElements();
    }

    public void componentClosed() {
        this.saveListener.unregister();
    }

    public void componentHidden() {
    }

    public void componentActivated() {
    }

    public void componentDeactivated() {
    }

    public UndoRedo getUndoRedo() {
        return UndoRedo.NONE;
    }

    public void setMultiViewCallback(MultiViewElementCallback mvec) {
        this.callback = mvec;
    }

    public CloseOperationState canCloseElement() {
        if (this.dObj.isModified()) {
            AbstractAction saveAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        LapTreeMVElement.this.dObj.getEditorSupport().saveDocument();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            AbstractAction discardAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LapTreeMVElement.this.dObj.getEditorSupport().onCloseDiscard();
                }
            };
            String messageSave = this.dObj.getEditorSupport().messageSave();
            return MultiViewFactory.createUnsafeCloseState((String)messageSave, (Action)saveAction, (Action)discardAction);
        }
        return CloseOperationState.STATE_OK;
    }

    private JToolBar createToolbarRepresentation() {
        JToolBar tb = new JToolBar();
        tb.add(new AbstractAction("Create sense"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotifyDescriptor.InputLine desc = new NotifyDescriptor.InputLine("Get name of sense", "Add new sense to goal od DC");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                if (desc.getValue() != NotifyDescriptor.OK_OPTION) {
                    return;
                }
                LapTreeMVElement.this.lapTree.getDriveCollection().getGoal().add(LapElementsFactory.createSense((String)desc.getInputText()));
            }
        });
        return tb;
    }
}

