/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.ILapChainListener;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.pogamut.shed.presenter.AbstractAcceptAction;
import cz.cuni.pogamut.shed.presenter.AbstractPresenter;
import cz.cuni.pogamut.shed.presenter.AcceptActionFactory;
import cz.cuni.pogamut.shed.presenter.ActionPatternPresenter;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.presenter.ShedInplaceEditorFactory;
import cz.cuni.pogamut.shed.presenter.ShedMenuActionFactory;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedVariableWidget;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.WidgetAction;

final class CompetencePresenter
extends AbstractPresenter
implements IPresenter,
PoshElementListener<Competence>,
ILapChainListener {
    private final TriggeredAction referencingAction;
    private final Competence competence;
    private final ShedVariableWidget competenceWidget;
    private final LapChain chain;

    CompetencePresenter(ShedScene scene, ShedPresenter presenter, TriggeredAction referencingAction, Competence competence, ShedVariableWidget competenceWidget, LapChain chain) {
        super(scene, presenter);
        assert (referencingAction.getName().equals(competence.getName()));
        this.referencingAction = referencingAction;
        this.competence = competence;
        this.competenceWidget = competenceWidget;
        this.chain = chain;
        this.updateWidget();
    }

    @Override
    public void register() {
        this.competenceWidget.setPresenter(this);
        this.competence.addElementListener((PoshElementListener)this);
        this.referencingAction.addElementListener((PoshElementListener)this);
        this.chain.register();
        this.chain.addChainListener((ILapChainListener)this);
    }

    @Override
    public void unregister() {
        this.chain.removeChainListener((ILapChainListener)this);
        this.chain.unregister();
        this.referencingAction.removeElementListener((PoshElementListener)this);
        this.competence.removeElementListener((PoshElementListener)this);
        this.competenceWidget.setPresenter(null);
    }

    @Override
    public Action[] getMenuActions() {
        PoshElement parentStructure = this.referencingAction.getParent();
        if (this.isActionPattern(parentStructure)) {
            ActionPattern parentAP = (ActionPattern)parentStructure;
            int thisActionPosition = this.getPosition(parentAP.getActions(), this.referencingAction);
            return new Action[]{ShedMenuActionFactory.appendChoiceAction(this.competence), ShedMenuActionFactory.changeCompetenceParameters(this.competence), ShedMenuActionFactory.deleteAction(parentAP, thisActionPosition)};
        }
        return new Action[]{ShedMenuActionFactory.appendChoiceAction(this.competence), ShedMenuActionFactory.changeCompetenceParameters(this.competence)};
    }

    public void childElementAdded(Competence parent, PoshElement child) {
    }

    public void childElementMoved(Competence parent, PoshElement child, int oldIndex, int newIndex) {
    }

    public void childElementRemoved(Competence parent, PoshElement child, int removedChildIndex) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (!(propertyName.equals("taAruments") || propertyName.equals("taName") || propertyName.equals("cnName") || propertyName.equals("cnParams"))) {
            throw new IllegalArgumentException(propertyName);
        }
        this.updateWidget();
    }

    @Override
    public AbstractAcceptAction[] getAcceptProviders() {
        return new AbstractAcceptAction[]{AcceptActionFactory.createCompetence2Action(this.referencingAction), AcceptActionFactory.createActionPatternAction(this.referencingAction), AcceptActionFactory.createAction2Action(this.referencingAction)};
    }

    private void updateWidget() {
        StringBuilder displayText = new StringBuilder();
        displayText.append(this.referencingAction.getName());
        Arguments args = this.referencingAction.getArguments();
        FormalParameters params = this.competence.getParameters();
        VariableContext ctx = this.chain.createContext();
        List<String> definedVariables = ActionPatternPresenter.getDefinedVariablesRepresentation(ctx, params, args);
        this.competenceWidget.setPresent(definedVariables);
        this.competenceWidget.setMissing(Collections.<String>emptyList());
        List<String> carryOverVariables = ActionPatternPresenter.getOtherVariables(ctx, params, args);
        this.competenceWidget.setUnused(carryOverVariables);
        this.competenceWidget.setDisplayName(displayText.toString());
        this.competenceWidget.revalidate();
    }

    public void notifyLinkChanged() {
        this.updateWidget();
    }

    @Override
    public WidgetAction getEditAction() {
        return ActionFactory.createInplaceEditorAction((InplaceEditorProvider)ShedInplaceEditorFactory.createCompetenceEditor(this.competence, this.referencingAction));
    }
}

