package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;

/**
 * Class holding information about arguments, the passed arguments that do not
 * override parameter.
 */
class TableArgument {

    private String name;
    /**
     * Representation of the actual value in string form.
     */
    private String valueString;

    public TableArgument(String name, Object value) {
        this.name = name;
        this.valueString = Result.toLap(value);
    }

    public TableArgument(Arguments.Argument arg) {
        this.name = arg.getParameterName();
        if (arg.getParameterVariable() != null) {
            this.valueString = arg.getParameterVariable();
        } else {
            this.valueString = Result.toLap(arg.getValue());
        }
    }

    public String getName() {
        return name;
    }

    public String getValueString() {
        return valueString;
    }

    /**
     * Sets new value string for the argument. must be parsable or variable.
     */
    public void setValueString(String newValueString) throws ParseException {
        if (!Result.isVariableName(newValueString)) {
            Result.parseValue(newValueString);
        }
        this.valueString = newValueString;
    }

    /**
     * Create {@link Argument} that represents current state of this object.
     */
    public Arguments.Argument createArgument() {
        if (stringRepresentsVariable(valueString)) {
            return Arguments.Argument.createVariableArgument(name, valueString);
        }

        try {
            Object value = Result.parseValue(valueString);
            return Arguments.Argument.createValueArgument(name, value);
        } catch (ParseException ex) {
            throw new FubarException("valueString should always be parsable", ex);
        }
    }

    private boolean stringRepresentsVariable(String s) {
        return s.startsWith("$");
    }

    void setName(String newName) {
        this.name = newName;
    }
}
