package cz.cuni.pogamut.shed.widget;

import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.Widget;

/**
 * Envelope for visual representation element (e.g. {@link DriveElement drive}/{@link CompetenceElement choice})
 * with trigger and reference to some other element. The element itself is in
 * the left top corner, the trigger is shown on the right of element and
 * attachment is under the representation of trigger.
 *
 * @see ShedDriveEnvelope
 * @see ShedChoiceEnvelope
 *
 * @author HonzaH
 */
public class SlotEnvelope extends Widget implements IShedEnvelope<ShedSenseWidget> {

    /**
     * Widget representing the slot element, e.g. competence element. It
     * displayes the name ect.
     */
    protected final ShedWidget slotWidget;
    private final ShedTriggerEnvelope triggerEnvelope;
    private ExpandedActionEnvelope expandedActionEnvelope;
    private final Widget top;

    /**
     * Create slot envelope for some element (e.g. choice or drive).
     *
     * @param scene Scene the envelope belongs to.
     * @param slotWidget The widget representing the element (e.g. drive or
     * choice)
     * @param triggerEnvelope Trigger of element.
     * @param expandedActionEnvelope Expanded action of element.
     */
    public SlotEnvelope(ShedScene scene, ShedWidget slotWidget, ShedTriggerEnvelope triggerEnvelope, final ExpandedActionEnvelope expandedActionEnvelope) {
        super(scene);

        setLayout(LayoutFactory.createVerticalFlowLayout(LayoutFactory.SerialAlignment.LEFT_TOP, ShedWidgetFactory.VERTICAL_GAP));

        top = new Widget(scene);
        top.setLayout(LayoutFactory.createHorizontalFlowLayout(LayoutFactory.SerialAlignment.LEFT_TOP, ShedWidgetFactory.HORIZONTAL_GAP));

        assert slotWidget != null;
        this.slotWidget = slotWidget;
        top.addChild(slotWidget);

        assert triggerEnvelope != null;
        this.triggerEnvelope = triggerEnvelope;
        top.addChild(triggerEnvelope);

        addChild(top);

        assert expandedActionEnvelope != null;
        this.expandedActionEnvelope = expandedActionEnvelope;
        addChild(expandedActionEnvelope);
    }

    /**
     * Get widget representing the element. In most cases, it is simply widget
     * with name fo element on it.
     */
    public ShedWidget getSlotWidget() {
        return slotWidget;
    }

    /**
     * Get envelope representing the trigger of element.
     */
    public ShedTriggerEnvelope getTriggerEnvelope() {
        return triggerEnvelope;
    }

    /**
     * Get envelope that contains expanded action of element.
     */
    public ExpandedActionEnvelope getExpandedActionEnvelope() {
        return this.expandedActionEnvelope;
    }

    @Override
    public final void add(ShedSenseWidget widget, int position) {
        triggerEnvelope.add(widget, position);
    }

    @Override
    public final void move(int absolutePosition, ShedSenseWidget widget) {
        triggerEnvelope.move(absolutePosition, widget);
    }

    @Override
    public final void remove(ShedSenseWidget widget) {
        triggerEnvelope.remove(widget);
    }
}