/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget;

import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.widget.IPresentedWidget;
import cz.cuni.pogamut.shed.widget.ShedScene;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class ShedWidget
extends Widget
implements PopupMenuProvider,
IPresentedWidget {
    private String displayName;
    protected static final int textOfs = 4;
    protected Color color;
    protected IPresenter actionProvider;
    protected static final int width = 240;
    protected static final int height = 30;
    static final int TITLE_FONT_SIZE = 16;
    protected static final Font font = new Font("Helvetica", 1, 16);

    ShedWidget(ShedScene scene, String displayName, Color color) {
        super((Scene)scene);
        assert (displayName != null);
        this.displayName = displayName;
        this.setToolTipText(this.displayName);
        assert (color != null);
        this.color = color;
        this.setPreferredBounds(new Rectangle(240, 30));
        this.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)this));
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public final void setDisplayName(String newDisplayName) {
        this.displayName = newDisplayName;
        this.setToolTipText(this.displayName);
        this.revalidate(true);
    }

    public ShedScene getShedScene() {
        return (ShedScene)this.getScene();
    }

    public final JPopupMenu getPopupMenu(Widget widget, Point localLocation) {
        assert (widget == this);
        Action[] actions = this.getMenuActions();
        if (actions == null) {
            return null;
        }
        JPopupMenu menu = new JPopupMenu();
        for (Action action : actions) {
            JMenuItem item = new JMenuItem(action);
            menu.add(item);
        }
        return menu;
    }

    protected final Action[] getMenuActions() {
        return this.actionProvider.getMenuActions();
    }

    @Override
    public final IPresenter getPresenter() {
        return this.actionProvider;
    }

    public final void setPresenter(IPresenter newPresenter) {
        this.actionProvider = newPresenter;
    }

    protected void paintWidget() {
        Rectangle bounds = this.getBounds();
        Graphics2D g = this.getGraphics();
        g.setColor(this.color);
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        this.drawString(g, font, this.getForeground(), this.getDisplayName());
    }

    protected final void drawString(Graphics2D g, Font font, Color color, String text) {
        FontMetrics metric = g.getFontMetrics(font);
        int ascent = metric.getAscent();
        String fitString = this.getFittingString(text, metric, this.getBounds().width - 8);
        g.setFont(font);
        g.setColor(color);
        g.drawString(fitString, 4, this.getBounds().height / 2 + ascent / 4);
    }

    protected final String getFittingString(String text, FontMetrics metrics, int maxWidth) {
        if (metrics.stringWidth(text) < maxWidth) {
            return text;
        }
        for (int index = text.length() - 1; index > 0; --index) {
            String shorter = text.substring(0, index).concat("...");
            if (metrics.stringWidth(shorter) >= maxWidth) continue;
            return shorter;
        }
        return "...";
    }

    public String toString() {
        return "ShedWidget: " + this.getDisplayName();
    }
}

