/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.shed.presenter.AbstractPresenter;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.ExpandedActionEnvelope;
import cz.cuni.pogamut.shed.widget.ShedActionsEnvelope;
import cz.cuni.pogamut.shed.widget.ShedCreationContainer;
import cz.cuni.pogamut.shed.widget.ShedScene;
import java.beans.PropertyChangeEvent;
import javax.swing.Action;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;

public class ActionsPresenter
extends AbstractPresenter
implements IPresenter,
PoshElementListener<ActionPattern> {
    private final ShedActionsEnvelope actionsEnvelope;
    private final ActionPattern actionPattern;
    private final LapChain chain;

    ActionsPresenter(ShedScene scene, ShedPresenter presenter, ShedActionsEnvelope actionsEnvelope, ActionPattern actionPattern, LapChain actionPatternChain) {
        super(scene, presenter);
        this.actionsEnvelope = actionsEnvelope;
        this.actionPattern = actionPattern;
        this.chain = actionPatternChain;
    }

    @Override
    public void register() {
        this.actionsEnvelope.setPresenter(this);
        this.actionPattern.addElementListener((PoshElementListener)this);
    }

    @Override
    public void unregister() {
        this.actionPattern.removeElementListener((PoshElementListener)this);
        this.actionsEnvelope.setPresenter(null);
    }

    @Override
    public Action[] getMenuActions() {
        return null;
    }

    public void childElementAdded(ActionPattern parent, PoshElement child) {
        if (!this.isAction(child)) {
            throw new IllegalArgumentException("Only action allowed, got " + child);
        }
        TriggeredAction addedAction = this.extractAction(parent.getActions(), child);
        int addedActionPosition = this.getPosition(parent.getActions(), addedAction);
        LapPath actionPatternPath = this.chain.toPath();
        LapPath addedActionPath = actionPatternPath.concat(LapType.ACTION, addedActionPosition);
        ShedCreationContainer<ExpandedActionEnvelope> addedExpandedActionContainer = this.scene.getWidgetFactory().createdExpandedActionEnvelope(addedActionPath, addedAction, this.chain);
        this.actionsEnvelope.add(addedExpandedActionContainer.getWidget(), addedActionPosition);
        this.scene.addArrows(addedExpandedActionContainer.getArrows());
        Anchor attachmentAnchor = addedExpandedActionContainer.getWidget().getAnchor();
        this.scene.addArrow(this.actionsEnvelope.getSourceAnchor(), attachmentAnchor);
        this.scene.update();
    }

    public void childElementMoved(ActionPattern parent, PoshElement child, int oldIndex, int newIndex) {
        if (!this.isAction(child)) {
            throw new IllegalArgumentException();
        }
        ExpandedActionEnvelope actionWidget = (ExpandedActionEnvelope)this.actionsEnvelope.getChild(oldIndex);
        this.actionsEnvelope.move(newIndex, actionWidget);
        this.scene.update();
    }

    public void childElementRemoved(ActionPattern parent, PoshElement child, int removedChildIndex) {
        if (!this.isAction(child)) {
            throw new IllegalArgumentException("Only action allowed, got " + child);
        }
        ExpandedActionEnvelope removedAction = (ExpandedActionEnvelope)this.actionsEnvelope.getChild(removedChildIndex);
        this.actionsEnvelope.remove(removedAction);
        this.scene.update();
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public WidgetAction getEditAction() {
        return null;
    }
}

