package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.ILapChainListener;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedVariableWidget;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.WidgetAction;

/**
 * {@link CompetencePresenter} is responsible for updating properties from the {@link Competence}
 * to the correct widget.
 *
 * @author Honza Havlicek
 */
public class CompetencePresenter extends AbstractPresenter implements IPresenter, PoshElementListener<Competence>, ILapChainListener {

    private final TriggeredAction referencingAction;
    private final Competence competence;
    private final ShedVariableWidget competenceWidget;
    private final LapChain chain;
    
    CompetencePresenter(ShedScene scene, ShedPresenter presenter, TriggeredAction referencingAction, Competence competence, ShedVariableWidget competenceWidget, LapChain chain) {
        super(scene, presenter);

        assert referencingAction.getName().equals(competence.getName());

        this.referencingAction = referencingAction;
        this.competence = competence;
        this.competenceWidget = competenceWidget;
        this.chain = chain;

        updateWidget();
    }

    @Override
    public void register() {
        competenceWidget.setPresenter(this);
        competence.addElementListener(this);
        referencingAction.addElementListener(this);
        
        chain.register();
        chain.addChainListener(this);
    }

    @Override
    public void unregister() {
        chain.removeChainListener(this);
        chain.unregister();
        
        referencingAction.removeElementListener(this);
        competence.removeElementListener(this);
        competenceWidget.setPresenter(null);
    }

    @Override
    public Action[] getMenuActions() {
        PoshElement parentStructure = referencingAction.getParent();
        if (isActionPattern(parentStructure)) {
            ActionPattern parentAP = (ActionPattern) parentStructure;
            int thisActionPosition = getPosition(parentAP.getActions(), referencingAction);
            return new Action[]{
                        ShedMenuActionFactory.appendChoiceAction(competence),
                        ShedMenuActionFactory.changeCompetenceParameters(competence),
                        ShedMenuActionFactory.deleteAction(parentAP, thisActionPosition)
                    };
            
        } else {
            return new Action[]{
                        ShedMenuActionFactory.appendChoiceAction(competence),
                        ShedMenuActionFactory.changeCompetenceParameters(competence)
                    };
        }
    }

    @Override
    public void childElementAdded(Competence parent, PoshElement child) {
        // Not your job
    }

    @Override
    public void childElementMoved(Competence parent, PoshElement child, int oldIndex, int newIndex) {
        // Not your job
    }

    @Override
    public void childElementRemoved(Competence parent, PoshElement child, int removedChildIndex) {
        // not your job
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();

        if (propertyName.equals(TriggeredAction.taArgs)
                || propertyName.equals(TriggeredAction.taName)
                || propertyName.equals(Competence.cnName)
                || propertyName.equals(Competence.cnParams)) {
            updateWidget();
        } else {
            throw new IllegalArgumentException(propertyName);
        }
    }

    @Override
    public AbstractAcceptAction[] getAcceptProviders() {
        return new AbstractAcceptAction[]{
                    AcceptActionFactory.createCompetence2Action(referencingAction),
                    AcceptActionFactory.createActionPatternAction(referencingAction),
                    AcceptActionFactory.createAction2Action(referencingAction)
                };
    }
    
    /**
     * Update widget to reflect current state of the {@link #action}.
     */
    private void updateWidget() {
        // Careful, while renaming the C, referencing action and C can have different names.

        StringBuilder displayText = new StringBuilder();
        displayText.append(referencingAction.getName());

        Arguments args = referencingAction.getArguments();
        FormalParameters params = competence.getParameters();
        VariableContext ctx = chain.createContext();
        
        List<String> definedVariables = ActionPatternPresenter.getDefinedVariablesRepresentation(ctx, params, args);
        competenceWidget.setPresent(definedVariables);
        competenceWidget.setMissing(Collections.<String>emptyList());
        
        List<String> carryOverVariables = ActionPatternPresenter.getOtherVariables(ctx, params, args);
        competenceWidget.setUnused(carryOverVariables);
        
        competenceWidget.setDisplayName(displayText.toString());
        competenceWidget.revalidate();
    }

    @Override
    public void notifyLinkChanged() {
        updateWidget();
    }

    @Override
    public WidgetAction getEditAction() {
        return ActionFactory.createInplaceEditorAction(ShedInplaceEditorFactory.createCompetenceEditor(competence, referencingAction));
    }
    
}
