/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.ILapChainListener;
import cz.cuni.amis.pogamut.sposh.elements.INamedElement;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.exceptions.UnexpectedElementException;
import cz.cuni.pogamut.shed.presenter.AbstractPresenter;
import cz.cuni.pogamut.shed.presenter.INameMapListener;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedVariableWidget;
import java.util.LinkedList;
import java.util.List;

public abstract class PrimitivePresenter<PRIMITIVE_TYPE extends PoshElement>
extends AbstractPresenter
implements PoshElementListener<PRIMITIVE_TYPE>,
INameMapListener,
ILapChainListener {
    protected final PRIMITIVE_TYPE primitive;
    protected final ShedVariableWidget primitiveWidget;
    protected final LapChain primitiveChain;

    protected PrimitivePresenter(ShedScene scene, ShedPresenter presenter, PRIMITIVE_TYPE primitive, ShedVariableWidget primitiveWidget, LapChain primitiveChain) {
        super(scene, presenter);
        this.primitive = primitive;
        this.primitiveWidget = primitiveWidget;
        this.primitiveChain = primitiveChain;
    }

    @Override
    public void register() {
        this.primitiveWidget.setPresenter(this);
        this.primitive.addElementListener((PoshElementListener)this);
        this.presenter.addNameMapListener(this);
        this.primitiveChain.register();
        this.primitiveChain.addChainListener((ILapChainListener)this);
        this.updateWidget();
    }

    @Override
    public void unregister() {
        this.primitiveChain.removeChainListener((ILapChainListener)this);
        this.primitiveChain.unregister();
        this.presenter.removeNameMapListener(this);
        this.primitive.removeElementListener((PoshElementListener)this);
        this.primitiveWidget.setPresenter(null);
    }

    public final void childElementAdded(PRIMITIVE_TYPE parent, PoshElement child) {
        throw UnexpectedElementException.create((PoshElement)child);
    }

    public final void childElementMoved(PRIMITIVE_TYPE parent, PoshElement child, int oldIndex, int newIndex) {
        throw UnexpectedElementException.create((PoshElement)child);
    }

    public final void childElementRemoved(PRIMITIVE_TYPE parent, PoshElement child, int removedChildIndex) {
        throw UnexpectedElementException.create((PoshElement)child);
    }

    @Override
    public final void nameMapChanged(String key, String oldName, String newName) {
        if (key.equals(((INamedElement)this.primitive).getName())) {
            this.updateWidget();
        }
    }

    public final void notifyLinkChanged() {
        this.updateWidget();
        this.scene.update();
    }

    protected abstract String getTitleText();

    protected final void updateWidget() {
        String titleText = this.getTitleText();
        this.primitiveWidget.setDisplayName(titleText);
        String[] params = this.presenter.getPrimitiveParameters(((INamedElement)this.primitive).getName());
        VariableContext ctx = this.primitiveChain.createContext();
        List<String> presentArgs = this.getPresentArgs(ctx, params);
        this.primitiveWidget.setPresent(presentArgs);
        List<String> missingArgs = this.getMissingArgs(ctx, params);
        this.primitiveWidget.setMissing(missingArgs);
        List<String> unusedArgs = this.getUnusedArgs(ctx, params);
        this.primitiveWidget.setUnused(unusedArgs);
        this.primitiveWidget.revalidate();
    }

    private List<String> getPresentArgs(VariableContext ctx, String[] primitiveParams) {
        LinkedList<String> presentArgs = new LinkedList<String>();
        for (String primitiveParam : primitiveParams) {
            if (!ctx.hasVariable(primitiveParam)) continue;
            Object argumentValue = ctx.getValue(primitiveParam);
            String argumentRepresentation = primitiveParam + '=' + Result.toLap((Object)argumentValue);
            presentArgs.add(argumentRepresentation);
        }
        return presentArgs;
    }

    private List<String> getMissingArgs(VariableContext ctx, String[] primitiveParams) {
        LinkedList<String> missingArgs = new LinkedList<String>();
        for (String primitiveParam : primitiveParams) {
            if (ctx.hasVariable(primitiveParam)) continue;
            missingArgs.add(primitiveParam);
        }
        return missingArgs;
    }

    private List<String> getUnusedArgs(VariableContext ctx, String[] primitiveArgs) {
        String[] allKeys;
        LinkedList<String> unusedArgs = new LinkedList<String>();
        for (String key : allKeys = ctx.getKeys()) {
            boolean isVarNeeded = false;
            for (String presentArg : primitiveArgs) {
                if (!presentArg.equals(key)) continue;
                isVarNeeded = true;
            }
            if (isVarNeeded) continue;
            Object variableValue = ctx.getValue(key);
            String variableRepresentation = key + '=' + Result.toLap((Object)variableValue);
            unusedArgs.add(variableRepresentation);
        }
        return unusedArgs;
    }
}

