/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.explorer;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.pogamut.posh.explorer.Crawler;
import cz.cuni.pogamut.posh.explorer.ElementExplorer;
import cz.cuni.pogamut.posh.explorer.PGSupport;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openide.util.datatransfer.ExTransferable;

class APExplorer
extends ElementExplorer<ActionPattern> {
    public APExplorer(Crawler<ActionPattern> crawler, PoshPlan plan) {
        super(crawler, plan);
    }

    @Override
    protected String getNewItemLabel() {
        return "New action pattern (drag and drop)";
    }

    @Override
    protected Transferable createNewItemTransferable() {
        return new ExTransferable.Single(ActionPattern.dataFlavor){

            protected Object getData() throws IOException, UnsupportedFlavorException {
                String name = PGSupport.getIdentifierFromDialog("Name of new AP");
                if (name == null) {
                    return null;
                }
                return LapElementsFactory.createActionPattern((String)name);
            }
        };
    }

    @Override
    protected void deleteItem(ActionPattern actionPattern) {
        boolean confirmed = PGSupport.confirm("Are you sure you want to delete action pattern " + actionPattern.getName());
        if (confirmed) {
            this.plan.removeActionPattern(actionPattern);
        }
    }

    @Override
    protected String getItemDescription(ActionPattern ap) {
        return "<html>Action pattern: " + ap.getName() + "<br/><pre>" + ap.toString() + "</pre></html>";
    }
}

