/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.match;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.LogFormatter;
import cz.cuni.amis.pogamut.base.utils.logging.LogHandler;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.execution.UT2004BotExecution;
import cz.cuni.amis.pogamut.ut2004.agent.execution.UT2004BotExecutionConfig;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.analyzer.IAnalyzerObserverListener;
import cz.cuni.amis.pogamut.ut2004.analyzer.IUT2004AnalyzerObserver;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004Analyzer;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerFullObserverModule;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerModule;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004AnalyzerParameters;
import cz.cuni.amis.pogamut.ut2004.analyzer.stats.UT2004AnalyzerObsStatsModule;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.AddBot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ChangeTeam;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.GameConfiguration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Kick;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Record;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StartPlayers;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameRestarted;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004AnalyzerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.teamcomm.server.UT2004TCServer;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004HumanConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004MatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004NativeBotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.result.UT2004MatchResult;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.FilePath;
import cz.cuni.amis.utils.Iterators;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.maps.LazyMap;
import cz.cuni.amis.utils.token.IToken;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public abstract class UT2004Match<CONFIG extends UT2004MatchConfig, RESULT extends UT2004MatchResult>
implements Callable<RESULT>,
Runnable {
    private static final int MAX_TEAMS = 8;
    protected CONFIG config;
    protected LogCategory log;
    protected RESULT result;
    protected Throwable exception;
    protected boolean teamMatch;
    protected LogHandler fileHandler;
    protected File ut2004FileBackup;
    protected File gb2004FileBackup;

    public UT2004Match(boolean teamMatch, CONFIG config, LogCategory log) {
        NullCheck.check(config, (String)"config");
        this.config = config;
        NullCheck.check((Object)((UT2004MatchConfig)config).getMatchId(), (String)"config.getMatchId()");
        this.log = log;
        this.teamMatch = teamMatch;
    }

    public boolean isTeamMatch() {
        return this.teamMatch;
    }

    public static boolean isHumanPlayer(Player player) {
        return player.getId() != null && player.getId().getStringId().toLowerCase().contains("player");
    }

    public RESULT getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    @Override
    public void run() {
        try {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Executing match: " + this.getMatchId().getToken());
            }
            this.result = null;
            this.exception = null;
            this.result = this.execute();
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("---/// MATCH OK ///---");
            }
        }
        catch (Exception e) {
            if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(ExceptionToString.process((String)("Failed to execute the match: " + this.getMatchId().getToken() + "."), (Throwable)e));
            }
            this.exception = e;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new PogamutException("Failed to execute the match: " + this.getMatchId().getToken(), (Throwable)e, (Object)this);
        }
    }

    @Override
    public RESULT call() {
        this.run();
        return this.getResult();
    }

    protected abstract RESULT execute();

    public static String getCurrentDate() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        return dateFormat.format(date);
    }

    public CONFIG getConfig() {
        return this.config;
    }

    public IToken getMatchId() {
        return ((UT2004MatchConfig)this.config).getMatchId();
    }

    public LogCategory getLog() {
        return this.log;
    }

    public String toString() {
        if (this == null) {
            return "UT2004Match";
        }
        return this.getClass().getSimpleName() + "[id=" + ((UT2004MatchConfig)this.config).getMatchId().getToken() + ", custom bots=" + ((UT2004MatchConfig)this.config).getBots().size() + ", native bots=" + ((UT2004MatchConfig)this.config).getNativeBots().size() + ", humans=" + ((UT2004MatchConfig)this.config).getHumans().size() + "]";
    }

    public File getOutputPath() {
        return this.getOutputPath("");
    }

    public File getOutputPath(String relativePath) {
        if (relativePath == null || relativePath.length() == 0) {
            return new File(((UT2004MatchConfig)this.config).getOutputDirectory().getAbsoluteFile() + File.separator + ((UT2004MatchConfig)this.config).getMatchId().getToken());
        }
        return new File(((UT2004MatchConfig)this.config).getOutputDirectory().getAbsoluteFile() + File.separator + ((UT2004MatchConfig)this.config).getMatchId().getToken() + File.separator + relativePath);
    }

    protected void setupLogger() {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Adding output of logs into " + this.getOutputPath("match-" + ((UT2004MatchConfig)this.config).getMatchId().getToken() + ".log"));
        }
        if (this.log != null) {
            this.fileHandler = new LogHandler((ILogPublisher)new LogPublisher.FilePublisher(this.getOutputPath("match-" + ((UT2004MatchConfig)this.config).getMatchId().getToken() + ".log"), (Formatter)new LogFormatter((IAgentId)new AgentId(((UT2004MatchConfig)this.config).getMatchId().getToken()), true)));
            this.log.addHandler((Handler)this.fileHandler);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(this + " file output setup");
        }
    }

    public void validate() {
        try {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Validating match configuration...");
            }
            ((UT2004MatchConfig)this.config).validate();
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Match configuration validated - OK.");
            }
        }
        catch (PogamutException e) {
            if (this.log != null) {
                this.log.severe(e.getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.severe(e.getMessage());
            }
            throw new PogamutException("Validation failed.", (Throwable)e, (Logger)this.log, (Object)this);
        }
    }

    public void cleanUp() {
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning("Cleaning up! Deleting: " + this.getOutputPath().getAbsolutePath());
        }
        FileUtils.deleteQuietly((File)this.getOutputPath());
    }

    protected File getUccHome() {
        return new File(((UT2004MatchConfig)this.config).getUccConf().getUnrealHome() + File.separator + "System");
    }

    protected File getUT2004IniFile() {
        return new File(((UT2004MatchConfig)this.config).getUccConf().getUnrealHome() + File.separator + "System" + File.separator + "UT2004.ini");
    }

    protected File getGB2004IniFile() {
        return new File(((UT2004MatchConfig)this.config).getUccConf().getUnrealHome() + File.separator + "System" + File.separator + "GameBots2004.ini");
    }

    protected void createUT2004Ini() {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Outputting UT2004.ini into " + this.getUT2004IniFile().getAbsolutePath() + " ...");
        }
        File ut2004File = this.getUT2004IniFile();
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        this.ut2004FileBackup = new File(ut2004File.getParent() + File.separator + "UT2004.ini." + sdf.format(date) + ".backup");
        if (ut2004File.isFile() && ut2004File.exists()) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Backing up UT2004.ini from " + ut2004File.getAbsolutePath() + " into + " + this.ut2004FileBackup.getAbsolutePath() + " ...");
            }
            boolean backup = true;
            try {
                FileUtils.copyFile((File)ut2004File, (File)this.ut2004FileBackup);
            }
            catch (IOException e) {
                backup = false;
            }
            if (backup && this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Backed up UT2004.ini from " + ut2004File.getAbsolutePath() + " into + " + this.ut2004FileBackup.getAbsolutePath() + " ...");
            } else if (!backup && this.log != null && this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Failed to back up UT2004.ini from " + ut2004File.getAbsolutePath() + " into + " + this.ut2004FileBackup.getAbsolutePath() + " !!!");
            }
        }
        ((UT2004MatchConfig)this.config).getUT2004Ini().output(ut2004File);
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": UT2004.ini output into " + this.getUT2004IniFile().getAbsolutePath() + ".");
        }
    }

    protected void createGB2004Ini() {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Outputting GameBots2004.ini into " + this.getGB2004IniFile().getAbsolutePath() + " ...");
        }
        File gb2004File = this.getGB2004IniFile();
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        this.gb2004FileBackup = new File(gb2004File.getParent() + File.separator + "GameBots2004.ini." + sdf.format(date) + ".backup");
        if (gb2004File.isFile() && gb2004File.exists()) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Backing up GameBots2004.ini from " + gb2004File.getAbsolutePath() + " into + " + this.gb2004FileBackup.getAbsolutePath() + " ...");
            }
            boolean backup = true;
            try {
                FileUtils.copyFile((File)gb2004File, (File)this.gb2004FileBackup);
            }
            catch (IOException e) {
                backup = false;
            }
            if (backup && this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Backed up GameBots2004.ini from " + gb2004File.getAbsolutePath() + " into + " + this.gb2004FileBackup.getAbsolutePath() + " ...");
            } else if (!backup && this.log != null && this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Failed to back up GameBots2004.ini from " + gb2004File.getAbsolutePath() + " into + " + this.gb2004FileBackup.getAbsolutePath() + " !!!");
            }
        }
        ((UT2004MatchConfig)this.config).getGb2004Ini().output(gb2004File);
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": GameBots2004.ini output into " + this.getGB2004IniFile().getAbsolutePath() + ".");
        }
    }

    protected UCCWrapper startUCC() {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Starting UCC with " + ((UT2004MatchConfig)this.config).getUccConf() + " ...");
        }
        UCCWrapper result = new UCCWrapper(((UT2004MatchConfig)this.config).getUccConf());
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": UCC started with " + ((UT2004MatchConfig)this.config).getUccConf() + ".");
            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": GB2004 host                = " + result.getHost());
            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": GB2004 bot port            = " + result.getBotPort());
            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": GB2004 control server port = " + result.getControlPort());
            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": GB2004 observer port       = " + result.getObserverPort());
        }
        return result;
    }

    protected UT2004Server startControlServer(UCCWrapper ucc) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Starting UT2004Server...");
        }
        NullCheck.check((Object)ucc, (String)"ucc");
        if (((UT2004MatchConfig)this.config).isStartTCServer()) {
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": config.isStartTCServer() == TRUE! Starting UT2004TCServer!");
            }
            UT2004TCServer server = UT2004TCServer.startTCServer((String)ucc.getHost(), (int)ucc.getControlPort());
            server.getLogger().setLevel(Level.WARNING);
            server.getLogger().addDefaultConsoleHandler();
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": UT2004TCServer started.");
            }
            return server;
        }
        UT2004ServerModule module = new UT2004ServerModule();
        UT2004ServerFactory factory = new UT2004ServerFactory(module);
        UT2004Server server = (UT2004Server)factory.newAgent((IAgentParameters)new UT2004AgentParameters().setAgentId((IAgentId)new AgentId(((UT2004MatchConfig)this.config).getMatchId().getToken() + "-UT2004Server")).setWorldAddress((IWorldConnectionAddress)ucc.getServerAddress()));
        server.getLogger().setLevel(Level.WARNING);
        server.getLogger().addDefaultConsoleHandler();
        server.start();
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": UT2004Server started.");
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeBotTeam(UT2004Server server, UnrealId botId, int desiredTeam) {
        NullCheck.check((Object)server, (String)"server");
        NullCheck.check((Object)botId, (String)"botId");
        final int targetTeam = desiredTeam;
        if (targetTeam < 0 || targetTeam >= 8) {
            return;
        }
        Player player = (Player)((UT2004WorldView)server.getWorldView()).get((WorldObjectId)botId);
        if (player == null) {
            throw new PogamutException("Bot with unrealId '" + botId + "' does not exists in 'server' worldview! **PUZZLED**", (Logger)this.log, (Object)this);
        }
        if (player.getTeam() == targetTeam) {
            return;
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Switching Bot[unrealId=" + botId.getStringId() + "] to team " + desiredTeam + "...");
        }
        final CountDownLatch teamChangedLatch = new CountDownLatch(1);
        IWorldObjectListener<Player> playerListener = new IWorldObjectListener<Player>(){
            Location previous;

            public void notify(IWorldObjectEvent<Player> event) {
                if (((Player)event.getObject()).getTeam() == targetTeam) {
                    teamChangedLatch.countDown();
                }
            }
        };
        ((UT2004WorldView)server.getWorldView()).addObjectListener((WorldObjectId)botId, (IWorldObjectEventListener)playerListener);
        try {
            server.getAct().act((CommandMessage)new ChangeTeam(botId, Integer.valueOf(targetTeam)));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException("Interrupted while awaiting team-change.", (Logger)this.log, (Object)e);
            }
            server.getAct().act((CommandMessage)new Respawn().setId(botId));
            long teamChangeTimeoutSecs = 60L;
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Waitng for Bot[unrealId=" + botId.getStringId() + "] to be switched to team " + desiredTeam + " for " + teamChangeTimeoutSecs + "secs...");
            }
            try {
                teamChangedLatch.await(teamChangeTimeoutSecs, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException("Interrupted while awaiting team-change.", (Logger)this.log, (Object)e);
            }
            player = (Player)((UT2004WorldView)server.getWorldView()).get((WorldObjectId)botId);
            if (player == null) {
                throw new PogamutException("Bot with unrealId '" + botId + "' does not exists in 'server' worldview! **PUZZLED**", (Logger)this.log, (Object)this);
            }
            if (player.getTeam() != targetTeam) {
                throw new PogamutException("Failed to change the bot with botId '" + botId + "' corresponding unrealId '" + botId + "' into correct team within " + teamChangeTimeoutSecs + "secs! Required team is " + targetTeam + ", current team is " + player.getTeam() + ".", (Logger)this.log, (Object)this);
            }
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Bot[unrealId=" + botId.getStringId() + "] switched to team " + desiredTeam + ".");
            }
        }
        finally {
            ((UT2004WorldView)server.getWorldView()).removeObjectListener((WorldObjectId)botId, (IWorldObjectEventListener)playerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bots startBots(UCCWrapper ucc, UT2004Server server) {
        Object playerListener;
        Bots bots;
        block49: {
            boolean exception;
            AdaptableProvider latch;
            AdaptableProvider connecting;
            block48: {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Starting custom & native bots...");
                }
                NullCheck.check((Object)ucc, (String)"ucc");
                NullCheck.check((Object)server, (String)"server");
                bots = new Bots();
                server.getAct().act((CommandMessage)new StartPlayers());
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new PogamutInterruptedException("Interrupted while awaiting start of players' exporting on the server.", (Logger)this.log, (Object)e);
                }
                if (server.getPlayers().size() > 0) {
                    boolean bot = false;
                    for (Player player : server.getPlayers()) {
                        if (UT2004Match.isHumanPlayer(player) || player.isSpectator().booleanValue()) continue;
                        bot = true;
                    }
                    if (bot) {
                        throw new PogamutException("There are already some bots/players/native bots connected to the game, even though we have not started to connect any of them yet. INVALID STATE!", (Logger)this.log, (Object)this);
                    }
                }
                connecting = new AdaptableProvider(null);
                latch = new AdaptableProvider(null);
                playerListener = new CollectionEventListener<Player>(){

                    public void postAddEvent(Collection<Player> alreadyAdded, Collection<Player> whereWereAdded) {
                    }

                    public void postRemoveEvent(Collection<Player> alreadyAdded, Collection<Player> whereWereRemoved) {
                        if (alreadyAdded.size() == 0) {
                            return;
                        }
                    }

                    public void preAddEvent(Collection<Player> toBeAdded, Collection<Player> whereToAdd) {
                        if (toBeAdded.size() == 0) {
                            return;
                        }
                        for (Player player : toBeAdded) {
                            if (UT2004Match.isHumanPlayer(player) || player.isSpectator().booleanValue()) continue;
                            if (UT2004Match.this.log != null && UT2004Match.this.log.isLoggable(Level.FINE)) {
                                UT2004Match.this.log.fine(((UT2004MatchConfig)UT2004Match.this.config).getMatchId().getToken() + ": New bot connected to GB2004. Bot[unrealId=" + player.getId().getStringId() + ", name=" + player.getName() + "], binding its unrealId to botId " + ((IToken)connecting.get()).getToken() + ".");
                            }
                            bots.botId2UnrealId.put((IToken)connecting.get(), player.getId());
                            bots.unrealId2BotId.put(player.getId(), (IToken)connecting.get());
                            bots.names.put(player.getId(), player.getName());
                            ((CountDownLatch)latch.get()).countDown();
                        }
                    }

                    public void preRemoveEvent(Collection<Player> toBeRemoved, Collection<Player> whereToRemove) {
                        if (toBeRemoved.size() == 0) {
                            return;
                        }
                        boolean bot = false;
                        for (Player player : toBeRemoved) {
                            if (UT2004Match.isHumanPlayer(player) || player.isSpectator().booleanValue()) continue;
                            bot = true;
                        }
                        if (!bot) {
                            return;
                        }
                        if (UT2004Match.this.log != null && UT2004Match.this.log.isLoggable(Level.WARNING)) {
                            StringBuffer sb = new StringBuffer();
                            sb.append(((UT2004MatchConfig)UT2004Match.this.config).getMatchId().getToken() + ": Bot(s) removed from GB2004!!!");
                            boolean first = true;
                            for (Player plr : toBeRemoved) {
                                if (first) {
                                    first = false;
                                } else {
                                    sb.append(", ");
                                }
                                sb.append("Bot[unrealId=" + plr.getId().getStringId() + ", name=" + plr.getName() + "]");
                            }
                            UT2004Match.this.log.warning(sb.toString());
                        }
                        throw new PogamutException("(CustomBot connecting) There can't be any 'removes' at this stage.", (Logger)UT2004Match.this.log, (Object)this);
                    }
                };
                server.getPlayers().addCollectionListener((CollectionEventListener)playerListener);
                exception = false;
                try {
                    for (UT2004BotConfig uT2004BotConfig : ((UT2004MatchConfig)this.config).getBots().values()) {
                        if (this.log != null && this.log.isLoggable(Level.FINE)) {
                            this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Starting custom Bot[botId=" + uT2004BotConfig.getBotId().getToken() + "]...");
                        }
                        if (server.notInState(new Class[]{IAgentStateUp.class})) {
                            throw new PogamutException("(CustomBot connecting) Server is DEAD! Some previous exception will have the explanation...", (Logger)this.log, (Object)this);
                        }
                        latch.set((Object)new CountDownLatch(1));
                        connecting.set((Object)uT2004BotConfig.getBotId());
                        UT2004BotExecution execution = new UT2004BotExecution((UT2004BotExecutionConfig)uT2004BotConfig, (Logger)this.log);
                        FlagListener<Boolean> botObs = new FlagListener<Boolean>(){

                            public void flagChanged(Boolean changedValue) {
                                if (!changedValue.booleanValue()) {
                                    ((CountDownLatch)latch.get()).countDown();
                                }
                            }
                        };
                        execution.getRunning().addListener((FlagListener)botObs);
                        try {
                            bots.bots.put(uT2004BotConfig.getBotId(), execution);
                            execution.start(ucc.getHost(), ucc.getBotPort(), ucc.getControlPort(), ucc.getObserverPort());
                            ((CountDownLatch)latch.get()).await(600000L, TimeUnit.MILLISECONDS);
                        }
                        finally {
                            execution.getRunning().removeListener((FlagListener)botObs);
                        }
                        if (!execution.isRunning()) {
                            throw new PogamutException("(CustomBot connecting) Bot[botId=" + uT2004BotConfig.getBotId().getToken() + "] startup failed!", (Logger)this.log, (Object)this);
                        }
                        if (((CountDownLatch)latch.get()).getCount() > 0L) {
                            throw new PogamutException("(CustomBot connecting) Bot[botId=" + uT2004BotConfig.getBotId().getToken() + "], startup failed! It does not showed up on server for 10 minutes... either failed to start, or " + server + " failed to got its presence from GB2004.", (Logger)this.log, (Object)this);
                        }
                        if (this.log != null && this.log.isLoggable(Level.INFO)) {
                            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Started custom Bot[botId=" + uT2004BotConfig.getBotId().getToken() + ", unrealId=" + bots.getUnrealId(uT2004BotConfig.getBotId()).getStringId() + "].");
                        }
                        if (uT2004BotConfig.getBotTeam() == null || uT2004BotConfig.getBotTeam() < 0 || uT2004BotConfig.getBotTeam() >= 8) continue;
                        this.changeBotTeam(server, bots.getUnrealId(uT2004BotConfig.getBotId()), uT2004BotConfig.getBotTeam());
                    }
                    if (bots.botId2UnrealId.size() != ((UT2004MatchConfig)this.config).getBots().size()) {
                        throw new PogamutException("(CustomBot connecting) Not all mappings BotId<->UnrealId has been created. **PUZZLING**", (Logger)this.log, (Object)this);
                    }
                    if (bots.unrealId2BotId.size() != ((UT2004MatchConfig)this.config).getBots().size()) {
                        throw new PogamutException("(CustomBot connecting) Not all mappings UnrealId<->BotId has been created. **PUZZLING**", (Logger)this.log, (Object)this);
                    }
                    if (!exception) break block48;
                }
                catch (Exception e) {
                    try {
                        exception = true;
                        if (e instanceof PogamutException) {
                            throw (PogamutException)((Object)e);
                        }
                        throw new PogamutException("(CustomBot connecting) Can't start all custom bots! Exception happened while starting " + ((IToken)connecting.get()).getToken() + ".", (Throwable)e, (Logger)this.log, (Object)this);
                    }
                    catch (Throwable throwable) {
                        if (exception) {
                            for (UT2004BotExecution execution : bots.bots.values()) {
                                execution.stop();
                            }
                            bots.bots.clear();
                        }
                        server.getPlayers().removeCollectionListener((CollectionEventListener)playerListener);
                        throw throwable;
                    }
                }
                for (UT2004BotExecution uT2004BotExecution : bots.bots.values()) {
                    uT2004BotExecution.stop();
                }
                bots.bots.clear();
            }
            server.getPlayers().removeCollectionListener((CollectionEventListener)playerListener);
            connecting = new AdaptableProvider(null);
            latch = new AdaptableProvider(null);
            playerListener = new CollectionEventListener<Player>(){

                public void postAddEvent(Collection<Player> alreadyAdded, Collection<Player> whereWereAdded) {
                }

                public void postRemoveEvent(Collection<Player> alreadyAdded, Collection<Player> whereWereRemoved) {
                    if (alreadyAdded.size() == 0) {
                        return;
                    }
                }

                public void preAddEvent(Collection<Player> toBeAdded, Collection<Player> whereToAdd) {
                    if (toBeAdded.size() == 0) {
                        return;
                    }
                    for (Player player : toBeAdded) {
                        if (UT2004Match.isHumanPlayer(player) || player.isSpectator().booleanValue()) continue;
                        if (UT2004Match.this.log != null && UT2004Match.this.log.isLoggable(Level.FINE)) {
                            UT2004Match.this.log.fine(((UT2004MatchConfig)UT2004Match.this.config).getMatchId().getToken() + ": New bot connected to GB2004. Bot[unrealId=" + player.getId().getStringId() + ", name=" + player.getName() + "], binding its unrealId to botId " + ((IToken)connecting.get()).getToken() + "...");
                        }
                        bots.nativeBotId2UnrealId.put((IToken)connecting.get(), player.getId());
                        bots.nativeUnrealId2BotId.put(player.getId(), (IToken)connecting.get());
                        bots.names.put(player.getId(), player.getName());
                        ((CountDownLatch)latch.get()).countDown();
                    }
                }

                public void preRemoveEvent(Collection<Player> toBeRemoved, Collection<Player> whereToRemove) {
                    if (toBeRemoved.size() == 0) {
                        return;
                    }
                    boolean bot = false;
                    for (Player player : toBeRemoved) {
                        if (UT2004Match.isHumanPlayer(player) || player.isSpectator().booleanValue()) continue;
                        bot = true;
                    }
                    if (!bot) {
                        return;
                    }
                    if (UT2004Match.this.log != null && UT2004Match.this.log.isLoggable(Level.WARNING)) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(((UT2004MatchConfig)UT2004Match.this.config).getMatchId().getToken() + ": Bot(s) removed from GB2004!!!");
                        boolean first = true;
                        for (Player plr : toBeRemoved) {
                            if (first) {
                                first = false;
                            } else {
                                sb.append(", ");
                            }
                            sb.append("Bot[unrealId=" + plr.getId().getStringId() + ", name=" + plr.getName() + "]");
                        }
                        UT2004Match.this.log.warning(sb.toString());
                    }
                    throw new PogamutException("(NativeBot connecting) There can't be any 'removes' at this stage.", (Logger)UT2004Match.this.log, (Object)this);
                }
            };
            server.getPlayers().addCollectionListener((CollectionEventListener)playerListener);
            exception = false;
            try {
                for (UT2004NativeBotConfig uT2004NativeBotConfig : ((UT2004MatchConfig)this.config).getNativeBots().values()) {
                    if (this.log != null && this.log.isLoggable(Level.FINE)) {
                        this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Starting native Bot[botId=" + uT2004NativeBotConfig.getBotId().getToken() + "]...");
                    }
                    if (server.notInState(new Class[]{IAgentStateUp.class})) {
                        throw new PogamutException("(NativeBot connecting) Server is DEAD! Some previous exception will have the explanation...", (Logger)this.log, (Object)this);
                    }
                    latch.set((Object)new CountDownLatch(1));
                    connecting.set((Object)uT2004NativeBotConfig.getBotId());
                    AddBot addBotCommand = new AddBot().setSkill(uT2004NativeBotConfig.getBotSkill());
                    Integer teamNumber = uT2004NativeBotConfig.getBotTeam();
                    addBotCommand.setTeam(teamNumber);
                    server.getAct().act((CommandMessage)addBotCommand);
                    ((CountDownLatch)latch.get()).await(120000L, TimeUnit.MILLISECONDS);
                    if (((CountDownLatch)latch.get()).getCount() > 0L) {
                        throw new PogamutException("(NativeBot connecting) We're tried to start up native bot " + uT2004NativeBotConfig.getBotId().getToken() + ", but it does not showed up on server for 2 minutes... either failed to start, or " + server + " failed to got it from GB2004.", (Logger)this.log, (Object)this);
                    }
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Started native Bot[botId=" + uT2004NativeBotConfig.getBotId().getToken() + ", unrealId=" + bots.getUnrealId(uT2004NativeBotConfig.getBotId()).getStringId() + "].");
                    }
                    if (uT2004NativeBotConfig.getBotTeam() < 0 || uT2004NativeBotConfig.getBotTeam() >= 8) continue;
                    this.changeBotTeam(server, bots.getUnrealId(uT2004NativeBotConfig.getBotId()), uT2004NativeBotConfig.getBotTeam());
                }
                if (bots.nativeBotId2UnrealId.size() != ((UT2004MatchConfig)this.config).getNativeBots().size()) {
                    throw new PogamutException("(NativeBot connecting) Not all mappings BotId<->UnrealId has been created. **PUZZLING**", (Logger)this.log, (Object)this);
                }
                if (bots.nativeUnrealId2BotId.size() != ((UT2004MatchConfig)this.config).getNativeBots().size()) {
                    throw new PogamutException("(NativeBot connecting) Not all mappings UnrealId<->BotId has been created. **PUZZLING**", (Logger)this.log, (Object)this);
                }
                if (!exception) break block49;
            }
            catch (Exception e) {
                try {
                    exception = true;
                    if (e instanceof PogamutException) {
                        throw (PogamutException)((Object)e);
                    }
                    throw new PogamutException("(NativeBot connecting) Can't start all native bots! Exception happened while starting " + ((IToken)connecting.get()).getToken() + ".", (Throwable)e, (Logger)this.log, (Object)this);
                }
                catch (Throwable throwable) {
                    if (exception) {
                        for (UT2004BotExecution execution : bots.bots.values()) {
                            execution.stop();
                        }
                        for (UnrealId id : bots.nativeUnrealId2BotId.keySet()) {
                            try {
                                server.getAct().act((CommandMessage)new Kick(id));
                            }
                            catch (Exception exception2) {}
                        }
                    }
                    server.getPlayers().removeCollectionListener((CollectionEventListener)playerListener);
                    throw throwable;
                }
            }
            for (UT2004BotExecution uT2004BotExecution : bots.bots.values()) {
                uT2004BotExecution.stop();
            }
            for (UnrealId unrealId : bots.nativeUnrealId2BotId.keySet()) {
                try {
                    server.getAct().act((CommandMessage)new Kick(unrealId));
                }
                catch (Exception exception3) {}
            }
        }
        server.getPlayers().removeCollectionListener((CollectionEventListener)playerListener);
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": All custom & native bots are up and running in correct teams..");
        }
        return bots;
    }

    protected void waitHumanPlayers(UT2004Server server, Bots bots) {
        int humanCount;
        int n = humanCount = ((UT2004MatchConfig)this.config).getHumans() == null ? 0 : ((UT2004MatchConfig)this.config).getHumans().size();
        if (humanCount == 0) {
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": No humans should participate within the match.");
            }
            return;
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Waiting for " + humanCount + " human non-spectator players to join the game.");
        }
        LazyMap<Integer, Integer> humansInTeam = new LazyMap<Integer, Integer>(){

            protected Integer create(Integer key) {
                return 0;
            }
        };
        for (UT2004HumanConfig human : ((UT2004MatchConfig)this.config).getHumans().values()) {
            if (this.isTeamMatch()) {
                humansInTeam.put(human.getTeamNumber(), (Integer)humansInTeam.get(human.getTeamNumber()) + 1);
                continue;
            }
            humansInTeam.put(0, (Integer)humansInTeam.get(0) + 1);
        }
        boolean connected = false;
        int waiting = 0;
        int humansConnected = 0;
        while (waiting < 2400) {
            humansConnected = 0;
            LazyMap<Integer, Integer> toConnect = new LazyMap<Integer, Integer>(){

                protected Integer create(Integer key) {
                    return 0;
                }
            };
            for (Integer teamKey : humansInTeam.keySet()) {
                toConnect.put(teamKey, 0);
            }
            for (Player player : server.getPlayers()) {
                if (!UT2004Match.isHumanPlayer(player) || player.isSpectator().booleanValue()) continue;
                ++humansConnected;
                toConnect.put(this.isTeamMatch() ? player.getTeam() : 0, (Integer)toConnect.get(this.isTeamMatch() ? player.getTeam() : 0) + 1);
            }
            if (humansConnected == humanCount) {
                connected = true;
                for (Map.Entry connectedTo : toConnect.entrySet()) {
                    if (connectedTo.getValue() == humansInTeam.get(connectedTo.getKey())) continue;
                    connected = false;
                }
                if (connected) break;
            }
            if (waiting % 8 == 0) {
                String teamReport = "";
                ArrayList teamKeys = new ArrayList(toConnect.keySet());
                Collections.sort(teamKeys);
                boolean first = true;
                for (Integer teamKey : teamKeys) {
                    if (first) {
                        first = false;
                    } else {
                        teamReport = teamReport + ", ";
                    }
                    teamReport = teamReport + "Team" + teamKey + "[" + toConnect.get(teamKey) + "/" + humansInTeam.get(teamKey) + "]";
                }
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": " + humansConnected + " / " + humanCount + " | " + teamReport + " human non-spectator(s) connected, waiting ...");
                }
            }
            ++waiting;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        humansConnected = 0;
        ArrayList<IToken> humansToAssign = new ArrayList<IToken>(((UT2004MatchConfig)this.config).getHumans().keySet());
        for (Player player : server.getPlayers()) {
            if (!UT2004Match.isHumanPlayer(player) || player.isSpectator().booleanValue()) continue;
            ++humansConnected;
            if (humansToAssign.size() == 0) continue;
            IToken humanToken = (IToken)humansToAssign.remove(0);
            bots.humanUnrealId2HumanId.put(player.getId(), humanToken);
            bots.humanId2UnrealId.put(humanToken, player.getId());
            bots.names.put(player.getId(), player.getName());
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Human id assigned. " + humanToken.getToken() + " -> Player[id=" + player.getId() + ", name=" + player.getName() + "].");
            }
            if (this.isTeamMatch() && player.getTeam() == ((UT2004MatchConfig)this.config).getHumans().get(humanToken).getTeamNumber()) continue;
        }
        if (humansConnected != humanCount) {
            throw new PogamutException("Timeout (10 minutes)! " + humansConnected + " / " + humanCount + " human non-spectator(s) connected, invalid, could not start the match!", (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": " + humanCount + " human non-spectator players joined the game.");
        }
    }

    protected UT2004Analyzer startAnalyzer(UCCWrapper ucc, Bots bots, File outputDirectory, boolean humanLikeObserving) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Starting UT2004Analyzer" + (humanLikeObserving ? "[humanLikeObserving enabled]" : "") + "...");
        }
        NullCheck.check((Object)ucc, (String)"ucc");
        NullCheck.check((Object)bots, (String)"bots");
        NullCheck.check((Object)outputDirectory, (String)"outputDirectory");
        UT2004AnalyzerModule module = new UT2004AnalyzerModule();
        UT2004AnalyzerFactory factory = new UT2004AnalyzerFactory(module);
        HashMap fileNames = new HashMap();
        Iterators entryIter = new Iterators(new Iterable[]{bots.unrealId2BotId.entrySet(), bots.nativeUnrealId2BotId.entrySet(), bots.humanUnrealId2HumanId.entrySet()});
        for (Map.Entry entry : entryIter) {
            String name = bots.names.get(entry.getKey());
            if (name != null) {
                fileNames.put(entry.getKey(), ((IToken)entry.getValue()).getToken() + "-" + FilePath.getValidFileName((String)name));
                continue;
            }
            fileNames.put(entry.getKey(), ((IToken)entry.getValue()).getToken());
        }
        UT2004Analyzer analyzer = (UT2004Analyzer)factory.newAgent((IAgentParameters)new UT2004AnalyzerParameters().setAgentId((IAgentId)new AgentId(((UT2004MatchConfig)this.config).getMatchId().getToken() + "-UT2004Analyzer")).setWorldAddress((IWorldConnectionAddress)ucc.getServerAddress()).setObserverModule((UT2004AnalyzerFullObserverModule)new UT2004AnalyzerObsStatsModule()).setObserverAddress(ucc.getObserverAddress()).setWaitForMatchRestart(true).setOutputPath(this.getOutputPath("bots").getAbsolutePath()).setFileNames(fileNames).setHumanLikeObserving(Boolean.valueOf(humanLikeObserving)));
        analyzer.getLogger().setLevel(Level.WARNING);
        analyzer.getLogger().addDefaultConsoleHandler();
        final CountDownLatch observersLatch = new CountDownLatch(bots.unrealId2BotId.size() + bots.nativeUnrealId2BotId.size() + bots.humanUnrealId2HumanId.size());
        final Bots myBots = bots;
        IAnalyzerObserverListener observerListener = new IAnalyzerObserverListener(){

            public void observerAdded(UnrealId botId, IUT2004AnalyzerObserver observer) {
                UT2004MatchConfig.BotType botType = myBots.getType(botId);
                if (botType == null) {
                    return;
                }
                switch (botType) {
                    case BOT: {
                        myBots.botObservers.put(myBots.unrealId2BotId.get(botId), observer);
                        break;
                    }
                    case NATIVE: {
                        myBots.botObservers.put(myBots.nativeUnrealId2BotId.get(botId), observer);
                        break;
                    }
                    case HUMAN: {
                        myBots.botObservers.put(myBots.humanUnrealId2HumanId.get(botId), observer);
                        break;
                    }
                    default: {
                        if (UT2004Match.this.log != null && UT2004Match.this.log.isLoggable(Level.WARNING)) {
                            UT2004Match.this.log.warning(((UT2004MatchConfig)UT2004Match.this.config).getMatchId().getToken() + ": Unknown type of Player[id=" + botId.getStringId() + "], tracked neither as BOT nor NATIVE nor HUMAN.");
                        }
                        return;
                    }
                }
                observersLatch.countDown();
            }

            public void observerRemoved(UnrealId botId, IUT2004AnalyzerObserver observer) {
            }
        };
        analyzer.addListener(observerListener);
        analyzer.start();
        try {
            observersLatch.await(300000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            analyzer.removeListener(observerListener);
            analyzer.kill();
            throw new PogamutInterruptedException("Interrupted while awaiting for observers to be setup for bots.", (Logger)this.log, (Object)this);
        }
        analyzer.removeListener(observerListener);
        if (observersLatch.getCount() > 0L) {
            analyzer.kill();
            throw new PogamutException("Timeout (5min) - not all observers has been attached within 5 minutes.", (Logger)this.log, (Object)this);
        }
        if (analyzer.notInState(new Class[]{IAgentStateUp.class})) {
            analyzer.kill();
            throw new PogamutException("After all observers have been started, analyzer was found DEAD... :-(", (Logger)this.log, (Object)this);
        }
        if (bots.botObservers.size() != ((UT2004MatchConfig)this.config).getBots().size() + ((UT2004MatchConfig)this.config).getNativeBots().size() + ((UT2004MatchConfig)this.config).getHumans().size()) {
            analyzer.kill();
            throw new PogamutException("Not all observers have been attached to running custom bots :-( - bots.botObservers.size() = " + bots.botObservers.size() + "; config.getBots().size() = " + ((UT2004MatchConfig)this.config).getBots().size() + "; config.getNativeBots().size() = " + ((UT2004MatchConfig)this.config).getNativeBots().size() + "; config.getHumans().size() = " + ((UT2004MatchConfig)this.config).getHumans().size(), (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": UT2004Analyzer started.");
        }
        return analyzer;
    }

    protected void matchIsAboutToBegin(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, Bots bots) {
    }

    protected void restartMatch(UT2004Server server, Bots bots) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Restarting match...");
        }
        NullCheck.check((Object)server, (String)"server");
        final BusAwareCountDownLatch latch = new BusAwareCountDownLatch(1, server.getEventBus(), new IComponent[]{server.getWorldView()});
        IWorldEventListener<GameRestarted> listener = new IWorldEventListener<GameRestarted>(){

            public void notify(GameRestarted event) {
                if (event.isFinished()) {
                    latch.countDown();
                }
            }
        };
        if (bots.botObservers.size() > 0 && this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Waiting for 5 seconds, to give GB2004 time to initialize observers...");
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException("Interrupted while giving GB2004 time to hook up listeners...", (Logger)this.log, (Object)this);
        }
        ((UT2004WorldView)server.getWorldView()).addEventListener(GameRestarted.class, (IWorldEventListener)listener);
        server.getAct().act((CommandMessage)new GameConfiguration().setRestart(Boolean.valueOf(true)));
        latch.await(300000L, TimeUnit.MILLISECONDS);
        if (latch.getCount() > 0L) {
            throw new PogamutException("Restart was not successful, event GameRestarted[finished==true] was not received.", (Logger)this.log, (Object)this);
        }
        bots.matchStart = System.currentTimeMillis();
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Match restarted.");
        }
    }

    protected void recordReplay(UT2004Server server, String fileName) {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Recording replay " + fileName);
        }
        server.getAct().act((CommandMessage)new Record(fileName));
    }

    protected abstract UT2004MatchResult waitMatchFinish(UCCWrapper var1, UT2004Server var2, UT2004Analyzer var3, Bots var4, long var5);

    public void restoreUT2004IniBackup() {
        File ut2004File = this.getUT2004IniFile();
        if (this.ut2004FileBackup == null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Could not restore UT2004.ini file, missing backup file reference, ut2004FileBackup == null.");
            }
            return;
        }
        if (this.ut2004FileBackup.isFile() && this.ut2004FileBackup.exists()) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Restoring " + ut2004File.getAbsolutePath() + " into + " + this.ut2004FileBackup.getAbsolutePath() + " ...");
            }
            boolean restore = true;
            try {
                FileUtils.copyFile((File)this.ut2004FileBackup, (File)ut2004File);
            }
            catch (IOException e) {
                restore = false;
            }
            if (restore && this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": UT2004.ini restored from " + this.ut2004FileBackup.getAbsolutePath() + ".");
            } else if (!restore && this.log != null && this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Failed to restore up UT2004.ini from " + this.ut2004FileBackup.getAbsolutePath() + " into + " + ut2004File.getAbsolutePath() + " !!!");
            }
        }
    }

    public void restoreGB2004IniBackup() {
        File gb2004File = this.getGB2004IniFile();
        if (this.gb2004FileBackup == null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Could not restore GameBots2004.ini file, missing backup file reference, gb2004FileBackup == null.");
            }
            return;
        }
        if (this.gb2004FileBackup.isFile() && this.gb2004FileBackup.exists()) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Restoring " + gb2004File.getAbsolutePath() + " into + " + this.gb2004FileBackup.getAbsolutePath() + " ...");
            }
            boolean restore = true;
            try {
                FileUtils.copyFile((File)this.gb2004FileBackup, (File)gb2004File);
            }
            catch (IOException e) {
                restore = false;
            }
            if (restore && this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": GameBots2004.ini restored from " + this.gb2004FileBackup.getAbsolutePath() + ".");
            } else if (!restore && this.log != null && this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Failed to restore up GameBots2004.ini from " + this.gb2004FileBackup.getAbsolutePath() + " into + " + gb2004File.getAbsolutePath() + " !!!");
            }
        }
    }

    protected void copyReplay(UCCWrapper ucc, String fileName, File outputDirectory) {
        boolean ex;
        File destination;
        block4: {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Copying replay file into " + outputDirectory.getAbsolutePath());
            }
            File replayFile = new File(ucc.getConfiguration().getUnrealHome() + File.separator + "Demos" + File.separator + fileName + ".demo4");
            destination = new File(outputDirectory.getAbsoluteFile() + File.separator + "match-" + ((UT2004MatchConfig)this.config).getMatchId().getToken() + "-replay.demo4");
            FilePath.makeDirsToFile((File)destination);
            ex = false;
            try {
                FileUtils.copyFile((File)replayFile, (File)destination);
            }
            catch (IOException e) {
                ex = true;
                if (this.log == null) break block4;
                this.log.warning(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Failed to copy replay file from: " + replayFile.getAbsolutePath() + " into " + destination.getAbsolutePath() + ": " + e.getMessage());
            }
        }
        if (!ex && this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Replay copied into " + destination.getAbsolutePath());
        }
    }

    protected abstract void outputResults(UCCWrapper var1, UT2004Server var2, UT2004Analyzer var3, Bots var4, UT2004MatchResult var5, File var6);

    protected void shutdownAll(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, Bots bots) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Shutting down everything...");
        }
        if (ucc != null) {
            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Killing UCC...");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ucc.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (server != null) {
            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Killing UT2004Server...");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                server.kill();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bots != null) {
            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Killing Custom bots...");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bots.bots != null) {
                for (UT2004BotExecution exec : bots.bots.values()) {
                    try {
                        exec.stop();
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Killing Custom bot observers...");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bots.botObservers != null) {
                for (IUT2004AnalyzerObserver obs : bots.botObservers.values()) {
                    try {
                        obs.kill();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (analyzer != null) {
            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Killing UT2004Analyzer...");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                analyzer.kill();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": UCC, Bots, UT2004Server, UT2004Analyzer + observers were shut down.");
        }
    }

    protected void closeLogger() {
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Closing file output...");
        }
        if (this.fileHandler != null) {
            if (this.log != null) {
                this.log.removeHandler((Handler)this.fileHandler);
            }
            this.fileHandler.close();
            this.fileHandler = null;
        }
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(((UT2004MatchConfig)this.config).getMatchId().getToken() + ": Logging to file stopped.");
        }
    }

    public static class Bots {
        public Map<IToken, UnrealId> botId2UnrealId = new HashMap<IToken, UnrealId>();
        public Map<UnrealId, IToken> unrealId2BotId = new HashMap<UnrealId, IToken>();
        public Map<IToken, UnrealId> nativeBotId2UnrealId = new HashMap<IToken, UnrealId>();
        public Map<UnrealId, IToken> nativeUnrealId2BotId = new HashMap<UnrealId, IToken>();
        public Map<IToken, UnrealId> humanId2UnrealId = new HashMap<IToken, UnrealId>();
        public Map<UnrealId, IToken> humanUnrealId2HumanId = new HashMap<UnrealId, IToken>();
        public Map<UnrealId, String> names = new HashMap<UnrealId, String>();
        public Map<IToken, UT2004BotExecution> bots = new HashMap<IToken, UT2004BotExecution>();
        public Map<IToken, IUT2004AnalyzerObserver> botObservers = new HashMap<IToken, IUT2004AnalyzerObserver>();
        public Set<IToken> diedOff = new HashSet<IToken>();
        public long matchStart = 0L;
        public long matchEnd = 0L;

        public UnrealId getUnrealId(IToken botId) {
            UnrealId result = this.botId2UnrealId.get(botId);
            if (result != null) {
                return result;
            }
            result = this.nativeBotId2UnrealId.get(botId);
            if (result != null) {
                return result;
            }
            return this.humanId2UnrealId.get(botId);
        }

        public IToken getBotId(UnrealId unrealId) {
            IToken result = this.unrealId2BotId.get(unrealId);
            if (result != null) {
                return result;
            }
            result = this.nativeUnrealId2BotId.get(unrealId);
            if (result != null) {
                return result;
            }
            return this.humanUnrealId2HumanId.get(unrealId);
        }

        public boolean isBot(IToken botId) {
            return this.botId2UnrealId.containsKey(botId);
        }

        public boolean isBot(UnrealId unrealId) {
            return this.unrealId2BotId.containsKey(unrealId);
        }

        public boolean isNativeBot(IToken botId) {
            return this.nativeBotId2UnrealId.containsKey(botId);
        }

        public boolean isNativeBot(UnrealId unrealId) {
            return this.nativeUnrealId2BotId.containsKey(unrealId);
        }

        public boolean isHuman(IToken botId) {
            return this.humanId2UnrealId.containsKey(botId);
        }

        public boolean isHuman(UnrealId unrealId) {
            return this.humanUnrealId2HumanId.containsKey(unrealId);
        }

        public UT2004MatchConfig.BotType getType(IToken botId) {
            if (this.isBot(botId)) {
                return UT2004MatchConfig.BotType.BOT;
            }
            if (this.isNativeBot(botId)) {
                return UT2004MatchConfig.BotType.NATIVE;
            }
            if (this.isHuman(botId)) {
                return UT2004MatchConfig.BotType.HUMAN;
            }
            return null;
        }

        public UT2004MatchConfig.BotType getType(UnrealId botId) {
            if (this.isBot(botId)) {
                return UT2004MatchConfig.BotType.BOT;
            }
            if (this.isNativeBot(botId)) {
                return UT2004MatchConfig.BotType.NATIVE;
            }
            if (this.isHuman(botId)) {
                return UT2004MatchConfig.BotType.HUMAN;
            }
            return null;
        }
    }
}

