/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.deathmatch;

import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatch;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchResult;
import cz.cuni.amis.utils.FilePath;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import cz.cuni.amis.utils.maps.HashMapMap;
import cz.cuni.amis.utils.maps.LazyMap;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class UT2004DeathMatchRepeater
implements Callable<List<UT2004DeathMatchResult>>,
Runnable {
    protected UT2004DeathMatchConfig matchConfig;
    protected int repeats;
    protected List<UT2004DeathMatchResult> results = new ArrayList<UT2004DeathMatchResult>();
    protected List<Throwable> exceptions = new ArrayList<Throwable>();
    private LogCategory log;

    public UT2004DeathMatchRepeater() {
    }

    public UT2004DeathMatchRepeater(LogCategory log) {
        this.log = log;
    }

    public UT2004DeathMatchRepeater(UT2004DeathMatchConfig match, int repeats, LogCategory log) {
        NullCheck.check((Object)match, (String)"match");
        this.matchConfig = match;
        this.repeats = repeats;
        if (this.repeats < 0) {
            throw new IllegalArgumentException("repeats = " + repeats + " < 0, can't be!");
        }
        this.log = log;
    }

    protected String getNum(int i, int max) {
        String result = String.valueOf(i);
        String maxStr = String.valueOf(max);
        while (result.length() < maxStr.length()) {
            result = "0" + result;
        }
        return result;
    }

    protected Token getToken(IToken orig, int i, int max) {
        return Tokens.get((String)(orig.getToken() + "-" + this.getNum(i + 1, max) + "_of_" + max));
    }

    public LogCategory getLog() {
        return this.log;
    }

    public void setLog(LogCategory log) {
        this.log = log;
    }

    public UT2004DeathMatchConfig getMatchConfig() {
        return this.matchConfig;
    }

    public void setMatchConfig(UT2004DeathMatchConfig matchConfig) {
        this.matchConfig = matchConfig;
    }

    public int getRepeats() {
        return this.repeats;
    }

    public void setRepeats(int repeats) {
        this.repeats = repeats;
    }

    public List<Throwable> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public List<UT2004DeathMatchResult> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    @Override
    public List<UT2004DeathMatchResult> call() throws Exception {
        this.call();
        return this.getResults();
    }

    @Override
    public void run() {
        if (this.matchConfig == null) {
            throw new PogamutException("No match set into the repeater!", (Object)this);
        }
        if (this.repeats < 0) {
            throw new PogamutException("repeats = " + this.repeats + " < 0, can't be!", (Object)this);
        }
        IToken token = this.matchConfig.getMatchId();
        for (int i = 0; i < this.repeats; ++i) {
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info("Running " + token.getToken() + " match " + (i + 1) + " / " + this.repeats + " ...");
            }
            this.matchConfig.setMatchId((IToken)this.getToken(token, i, this.repeats));
            UT2004DeathMatch match = new UT2004DeathMatch(this.matchConfig, new LogCategory(this.matchConfig.getMatchId().getToken()));
            match.getLog().addHandler(new ILogPublisher(){

                public void close() throws SecurityException {
                }

                public void flush() {
                }

                public void publish(LogRecord record) {
                    if (UT2004DeathMatchRepeater.this.log != null) {
                        UT2004DeathMatchRepeater.this.log.log(record);
                    }
                }
            });
            match.cleanUp();
            boolean exception = false;
            UT2004DeathMatchResult result = null;
            try {
                result = (UT2004DeathMatchResult)match.call();
            }
            catch (Exception e) {
                exception = true;
                this.results.add(null);
                this.exceptions.add(e);
            }
            if (exception) continue;
            this.results.add(result);
            this.exceptions.add(null);
        }
        this.matchConfig.setMatchId(token);
        this.outputAggregatedResults();
    }

    protected void outputAggregatedResults() {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.matchConfig.getMatchId().getToken() + ": Outputting aggregated match results into CSV files...");
        }
        IToken token = this.matchConfig.getMatchId();
        File outputDirectory = new File(this.matchConfig.getOutputDirectory().getAbsolutePath() + File.separator + this.matchConfig.getMatchId().getToken() + "-results");
        outputDirectory.mkdirs();
        this.outputAggregatedResults(outputDirectory);
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            UT2004DeathMatchConfig config = this.matchConfig;
            this.log.info(config.getMatchId().getToken() + ": Aggregated match results output into CSV files.");
        }
    }

    protected void outputAggregatedResults(File outputDirectory) {
        UT2004DeathMatchConfig config = this.matchConfig;
        List<IToken> botIds = config.getAllBotIds();
        LazyMap<IToken, Integer> wins = new LazyMap<IToken, Integer>(){

            protected Integer create(IToken key) {
                return 0;
            }
        };
        LazyMap<IToken, Integer> draws = new LazyMap<IToken, Integer>(){

            protected Integer create(IToken key) {
                return 0;
            }
        };
        int matchFinished = 0;
        for (UT2004DeathMatchResult result : this.results) {
            if (result == null) continue;
            ++matchFinished;
            if (result.isDraw()) {
                for (IToken botId : botIds) {
                    draws.put(botId, 1 + (Integer)draws.get(botId));
                }
                continue;
            }
            wins.put(result.getWinnerBot(), 1 + (Integer)wins.get(result.getWinnerBot()));
        }
        HashMapMap kills = new HashMapMap();
        HashMap<IToken, Integer> scores = new HashMap<IToken, Integer>();
        HashMap<IToken, Integer> deaths = new HashMap<IToken, Integer>();
        HashMap<IToken, Integer> totalKills = new HashMap<IToken, Integer>();
        HashMap totalKilled = new HashMap();
        for (IToken botId1 : botIds) {
            scores.put(botId1, 0);
            deaths.put(botId1, 0);
            totalKills.put(botId1, 0);
            for (IToken botId2 : botIds) {
                kills.put((Object)botId1, (Object)botId2, (Object)0);
            }
        }
        for (UT2004DeathMatchResult result : this.results) {
            if (result == null) continue;
            for (IToken botId1 : botIds) {
                scores.put(botId1, (Integer)scores.get(botId1) + result.getFinalScores().get(botId1).getScore());
                deaths.put(botId1, (Integer)deaths.get(botId1) + result.getFinalScores().get(botId1).getDeaths());
                totalKills.put(botId1, (Integer)totalKills.get(botId1) + result.getTotalKills().get(botId1));
                for (IToken botId2 : botIds) {
                    kills.put((Object)botId1, (Object)botId2, (Object)((Integer)kills.get((Object)botId1, (Object)botId2) + (Integer)result.getKillCounts().get((Object)botId1, (Object)botId2)));
                }
            }
        }
        File resultFile = new File(outputDirectory.getAbsolutePath() + File.separator + "match-" + this.repeats + "x-" + config.getMatchId().getToken() + "-scores-aggregated.csv");
        FilePath.makeDirsToFile((File)resultFile);
        try {
            Formatter writer = new Formatter(resultFile);
            writer.format("botId;matches;matchFinished;win;winRatio;draw;drawRatio;lose;loseRatio;score;scoreAvg;kills;killsAvg;killedByOthers;killedByOthersAvg;deaths;deathsAvg;suicides;suicidesAvg", new Object[0]);
            if (matchFinished > 0) {
                for (IToken botId : botIds) {
                    writer.format(";", new Object[0]);
                    writer.format(botId.getToken(), new Object[0]);
                    writer.format(";", new Object[0]);
                    writer.format(botId.getToken() + "Avg", new Object[0]);
                }
                for (IToken botId : botIds) {
                    writer.format("\n%s;%d;%d;%d;%.3f;%d;%.3f;%d;%.3f;%d;%.3f;%d;%.3f;%d;%.3f;%d;%.3f;%d;%.3f", botId.getToken(), this.repeats, matchFinished, wins.get(botId), (double)((Integer)wins.get(botId)).intValue() / (double)matchFinished, draws.get(botId), (double)((Integer)draws.get(botId)).intValue() / (double)matchFinished, matchFinished - (Integer)wins.get(botId) - (Integer)draws.get(botId), (double)(matchFinished - (Integer)wins.get(botId) - (Integer)draws.get(botId)) / (double)matchFinished, scores.get(botId), (double)((Integer)scores.get(botId)).intValue() / (double)matchFinished, totalKills.get(botId), (double)((Integer)totalKills.get(botId)).intValue() / (double)matchFinished, (Integer)deaths.get(botId) - (Integer)kills.get((Object)botId, (Object)botId), (double)((Integer)deaths.get(botId) - (Integer)kills.get((Object)botId, (Object)botId)) / (double)matchFinished, deaths.get(botId), (double)((Integer)deaths.get(botId)).intValue() / (double)matchFinished, kills.get((Object)botId, (Object)botId), (double)((Integer)kills.get((Object)botId, (Object)botId)).intValue() / (double)matchFinished);
                    for (IToken botId2 : botIds) {
                        writer.format(";%d", kills.get((Object)botId).get(botId2));
                        writer.format(";%.3f", (double)((Integer)kills.get((Object)botId).get(botId2)).intValue() / (double)matchFinished);
                    }
                }
            } else {
                writer.format("NO MATCH FINISHED, ALL HAVE ENDED WITH AN EXCEPTION!", new Object[0]);
            }
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
        catch (IOException e) {
            throw new PogamutIOException("Failed to write results!", (Throwable)e, (Logger)this.log, (Object)this);
        }
        for (IToken botId1 : botIds) {
            File botFile = new File(outputDirectory.getAbsolutePath() + File.separator + "match-" + this.repeats + "x-" + config.getMatchId().getToken() + "-scores-" + botId1.getToken() + ".csv");
            FilePath.makeDirsToFile((File)botFile);
            try {
                Formatter writer = new Formatter(botFile);
                writer.format("match;matches;matchFinished;score;kills;killedByOthers;deaths;suicides", new Object[0]);
                for (IToken iToken : botIds) {
                    writer.format(";", new Object[0]);
                    writer.format(iToken.getToken(), new Object[0]);
                }
                int i = 0;
                for (UT2004DeathMatchResult result : this.results) {
                    ++i;
                    if (result == null) continue;
                    writer.format("\n%d;%d;%d;%d;%d;%d;%d;%d", i, this.repeats, matchFinished, result.getFinalScores().get(botId1).getScore(), result.getTotalKills().get(botId1), result.getWasKilled().get(botId1), result.getFinalScores().get(botId1).getDeaths(), result.getSuicides().get(botId1));
                    for (IToken botId2 : botIds) {
                        writer.format(";%d", result.getKillCounts().get((Object)botId1).get(botId2));
                    }
                }
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
            catch (IOException e) {
                throw new PogamutIOException("Failed to write results!", (Throwable)e, (Logger)this.log, (Object)this);
            }
        }
        ArrayList<IToken> customBots = new ArrayList<IToken>(config.getBots().keySet());
        Collections.sort(customBots, new Comparator<IToken>(){

            @Override
            public int compare(IToken o1, IToken o2) {
                return o1.getToken().compareTo(o2.getToken());
            }
        });
        if (this.results.size() > 0) {
            for (IToken botId1 : customBots) {
                File botFile = new File(outputDirectory.getAbsolutePath() + File.separator + "match-" + this.repeats + "x-" + config.getMatchId().getToken() + "-stats-" + botId1.getToken() + ".csv");
                FilePath.makeDirsToFile((File)botFile);
                try {
                    Formatter writer = new Formatter(botFile);
                    writer.format("match;", new Object[0]);
                    this.results.get(0).getBotObservers().get(botId1).getStats().outputHeader(writer);
                    int n = 0;
                    for (UT2004DeathMatchResult result : this.results) {
                        ++n;
                        if (result == null) continue;
                        writer.format("%d;", n);
                        result.getBotObservers().get(botId1).getStats().outputStatLine(writer, result.getMatchTimeEnd(), new String[0]);
                    }
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
                catch (IOException e) {
                    throw new PogamutIOException("Failed to write results!", (Throwable)e, (Logger)this.log, (Object)this);
                }
            }
        }
    }
}

