/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.deathmatch;

import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.execution.UT2004BotExecution;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentStats;
import cz.cuni.amis.pogamut.ut2004.analyzer.IUT2004AnalyzerObserver;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004Analyzer;
import cz.cuni.amis.pogamut.ut2004.analyzer.stats.UT2004AnalyzerObsStats;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StartPlayers;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerScore;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchResult;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004Match;
import cz.cuni.amis.pogamut.ut2004.tournament.match.result.UT2004MatchResult;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.FilePath;
import cz.cuni.amis.utils.Iterators;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.token.IToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004DeathMatch
extends UT2004Match<UT2004DeathMatchConfig, UT2004DeathMatchResult> {
    private int targetFragCount;

    public UT2004DeathMatch(UT2004DeathMatchConfig config, LogCategory log) {
        super(false, config, log);
    }

    @Override
    protected void changeBotTeam(UT2004Server server, UnrealId botId, int desiredTeam) {
    }

    @Override
    protected UT2004MatchResult waitMatchFinish(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, final UT2004Match.Bots bots, long timeoutInMillis) {
        UT2004DeathMatchResult uT2004DeathMatchResult;
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Waiting for the match to finish...");
        }
        if ((long)(((UT2004DeathMatchConfig)this.config).getTimeLimit() * 60 * 1000 + 300000) > timeoutInMillis) {
            timeoutInMillis = ((UT2004DeathMatchConfig)this.config).getTimeLimit() * 60 * 1000 + 300000;
        }
        HashMap<IToken, 2> customBotObservers = new HashMap<IToken, 2>(((UT2004DeathMatchConfig)this.config).getBots().size());
        FlagListener<IAgentState> serverObs = null;
        FlagListener<Boolean> uccObs = null;
        IWorldEventListener<PlayerScore> scoresListener = null;
        final CountDownLatch waitLatch = new CountDownLatch(1);
        final AdaptableProvider oneOfBotsDiedOut = new AdaptableProvider((Object)false);
        final AdaptableProvider serverDiedOut = new AdaptableProvider((Object)false);
        final HashMap<UnrealId, PlayerScore> scores = new HashMap<UnrealId, PlayerScore>();
        boolean exception = false;
        try {
            scoresListener = new IWorldEventListener<PlayerScore>(){

                public void notify(PlayerScore event) {
                    if (waitLatch == null || waitLatch.getCount() <= 0L) {
                        return;
                    }
                    scores.put(event.getId(), event);
                    if (event.getScore() >= UT2004DeathMatch.this.targetFragCount) {
                        waitLatch.countDown();
                    }
                }
            };
            ((UT2004WorldView)server.getWorldView()).addEventListener(PlayerScore.class, (IWorldEventListener)scoresListener);
            for (final UT2004BotConfig botConfig : ((UT2004DeathMatchConfig)this.config).getBots().values()) {
                FlagListener<Boolean> obs = new FlagListener<Boolean>(){

                    public void flagChanged(Boolean changedValue) {
                        if (!changedValue.booleanValue()) {
                            bots.diedOff.add(botConfig.getBotId());
                            oneOfBotsDiedOut.set((Object)true);
                            waitLatch.countDown();
                        }
                    }
                };
                bots.bots.get(botConfig.getBotId()).getRunning().addListener((FlagListener)obs);
                customBotObservers.put(botConfig.getBotId(), obs);
                if (((Boolean)bots.bots.get(botConfig.getBotId()).getRunning().getFlag()).booleanValue()) continue;
                bots.diedOff.add(botConfig.getBotId());
                oneOfBotsDiedOut.set((Object)true);
                waitLatch.countDown();
                throw new PogamutException("One of custom bots died out from the start, failure!", (Logger)this.log, (Object)this);
            }
            serverObs = new FlagListener<IAgentState>(){

                public void flagChanged(IAgentState changedValue) {
                    if (changedValue instanceof IAgentStateDown) {
                        serverDiedOut.set((Object)true);
                        waitLatch.countDown();
                    }
                }
            };
            server.getState().addListener((FlagListener)serverObs);
            if (server.notInState(new Class[]{IAgentStateUp.class})) {
                serverDiedOut.set((Object)true);
                waitLatch.countDown();
                throw new PogamutException("Server is dead from the start, failure!", (Logger)this.log, (Object)this);
            }
            uccObs = new FlagListener<Boolean>(){

                public void flagChanged(Boolean changedValue) {
                    if (changedValue.booleanValue()) {
                        serverDiedOut.set((Object)true);
                        waitLatch.countDown();
                    }
                }
            };
            ucc.getGameEnding().addListener((FlagListener)uccObs);
            waitLatch.await(timeoutInMillis, TimeUnit.MILLISECONDS);
            if (waitLatch.getCount() > 0L) {
                throw new PogamutException("TIMEOUT! The match did not end in " + timeoutInMillis / 1000L + " secs.", (Logger)this.log, (Object)this);
            }
            bots.matchEnd = System.currentTimeMillis();
            ((UT2004DeathMatchConfig)this.getConfig()).setFragLimit(this.targetFragCount);
            if (((Boolean)oneOfBotsDiedOut.get()).booleanValue()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    throw new PogamutInterruptedException("Interrupted while giving GB2004 time to tear down its connection.", (Logger)this.log, (Object)this);
                }
                try {
                    server.getAct().act((CommandMessage)new StartPlayers());
                }
                catch (Exception e) {
                    serverDiedOut.set((Object)true);
                }
                if (!((Boolean)serverDiedOut.get()).booleanValue()) {
                    this.log.warning("ONE OF BOTS HAS DIED OUT, BUT SERVER IS STILL RUNNING ... POSSIBLE MATCH FAILURE!");
                }
            }
            if (!((Boolean)serverDiedOut.get()).booleanValue() && server.inState(new Class[]{IAgentStateUp.class})) {
                server.kill();
            }
            if (ucc != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Killing UCC...");
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    ucc.stop();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ArrayList<UnrealId> winners = new ArrayList<UnrealId>(1);
            int maxFrags = 0;
            Iterators playersIter = new Iterators(new Iterable[]{bots.unrealId2BotId.entrySet(), bots.nativeUnrealId2BotId.entrySet(), bots.humanUnrealId2HumanId.entrySet()});
            while (playersIter.hasNext()) {
                Map.Entry entry = (Map.Entry)playersIter.next();
                PlayerScore playerScore = (PlayerScore)scores.get(entry.getKey());
                if (playerScore == null) {
                    throw new PogamutException("Can't resolve the match result. One of the bot with botId '" + ((IToken)entry.getValue()).getToken() + "' and corresponding unrealId '" + ((UnrealId)entry.getKey()).getStringId() + "' has no score entry!", (Logger)this.log, (Object)this);
                }
                if (playerScore.getScore() == maxFrags) {
                    winners.add((UnrealId)entry.getKey());
                    continue;
                }
                if (playerScore.getScore() <= maxFrags) continue;
                maxFrags = playerScore.getScore();
                winners.clear();
                winners.add((UnrealId)entry.getKey());
            }
            if (winners.size() == 0) {
                throw new PogamutException("There is no winner, impossible! **puzzled**", (Logger)this.log, (Object)this);
            }
            if (winners.size() > 1) {
                StringBuffer sb = new StringBuffer();
                sb.append("There is more than one bot with highest score == " + maxFrags + ": ");
                boolean first = true;
                for (UnrealId id : winners) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append("Bot[botId=" + bots.getBotId(id) + ", unrealId=" + id.getStringId() + ", score=" + ((PlayerScore)scores.get(id)).getScore() + "]");
                }
                sb.append(".");
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(sb.toString());
                }
            }
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": MATCH FINISHED!");
            }
            uT2004DeathMatchResult = this.processResults(ucc, server, analyzer, bots, winners, scores);
        }
        catch (Exception e) {
            try {
                exception = true;
                throw new PogamutException("Failed to perform the match!", (Throwable)e, (Logger)this.log, (Object)this);
            }
            catch (Throwable throwable) {
                for (Map.Entry entry : customBotObservers.entrySet()) {
                    bots.bots.get(entry.getKey()).getRunning().removeListener((FlagListener)entry.getValue());
                }
                server.getState().removeListener(serverObs);
                ((UT2004WorldView)server.getWorldView()).removeEventListener(PlayerScore.class, (IWorldEventListener)scoresListener);
                throw throwable;
            }
        }
        for (Map.Entry entry : customBotObservers.entrySet()) {
            bots.bots.get(entry.getKey()).getRunning().removeListener((FlagListener)entry.getValue());
        }
        server.getState().removeListener((FlagListener)serverObs);
        ((UT2004WorldView)server.getWorldView()).removeEventListener(PlayerScore.class, (IWorldEventListener)scoresListener);
        return uT2004DeathMatchResult;
    }

    protected UT2004DeathMatchResult processResults(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, List<UnrealId> winners, Map<UnrealId, PlayerScore> finalScores) {
        boolean bl;
        double time;
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Processing results...");
        }
        UT2004DeathMatchResult result = new UT2004DeathMatchResult();
        result.setMatchTimeEnd(((double)bots.matchEnd - (double)bots.matchStart) / 1000.0);
        for (Map.Entry<UnrealId, PlayerScore> entry : finalScores.entrySet()) {
            result.getFinalScores().put(bots.getBotId(entry.getKey()), entry.getValue());
        }
        for (Map.Entry<UnrealId, PlayerScore> entry : bots.botObservers.entrySet()) {
            if (!(entry.getValue() instanceof UT2004AnalyzerObsStats)) {
                throw new PogamutException("There is an observer of wrong class, expecting UT2004AnalyzerObsStats, got " + ((IUT2004AnalyzerObserver)entry.getValue()).getClass().getSimpleName() + "!", (Logger)this.log, (Object)this);
            }
            result.getBotObservers().put((IToken)entry.getKey(), (UT2004AnalyzerObsStats)entry.getValue());
        }
        List<IToken> botIds = ((UT2004DeathMatchConfig)this.config).getAllBotIds();
        for (IToken botId1 : botIds) {
            result.getNames().put(botId1, bots.names.get(bots.getUnrealId(botId1)));
            result.getTotalKills().put(botId1, 0);
            result.getWasKilled().put(botId1, 0);
            result.getSuicides().put(botId1, 0);
            for (IToken botId2 : botIds) {
                result.getKillCounts().put((Object)botId1, (Object)botId2, (Object)0);
            }
        }
        for (Map.Entry<IToken, UT2004AnalyzerObsStats> entry : result.getBotObservers().entrySet()) {
            IToken botId = entry.getKey();
            UT2004AnalyzerObsStats obs = entry.getValue();
            AgentStats stats = obs.getStats();
            for (Map.Entry killed : stats.getKilled().entrySet()) {
                result.getKillCounts().get((Object)botId).put(bots.getBotId((UnrealId)killed.getKey()), killed.getValue());
            }
            for (Map.Entry killedBy : stats.getKilledBy().entrySet()) {
                if (!bots.isNativeBot((UnrealId)killedBy.getKey())) continue;
                result.getKillCounts().get((Object)bots.getBotId((UnrealId)killedBy.getKey())).put(botId, killedBy.getValue());
            }
            result.getSuicides().put(botId, stats.getSuicides());
            result.getKillCounts().put((Object)botId, (Object)botId, (Object)stats.getSuicides());
        }
        for (IToken nativeBotId1 : ((UT2004DeathMatchConfig)this.config).getNativeBots().keySet()) {
            for (IToken nativeBotId2 : ((UT2004DeathMatchConfig)this.config).getNativeBots().keySet()) {
                if (nativeBotId1 == nativeBotId2) continue;
                result.getKillCounts().get((Object)nativeBotId1).put(nativeBotId2, 0);
            }
            result.getSuicides().put(nativeBotId1, 0);
        }
        for (IToken botId : botIds) {
            int totalKills = 0;
            int totalKilled = 0;
            for (IToken other : botIds) {
                if (botId == other) continue;
                totalKills += ((Integer)result.getKillCounts().get((Object)botId, (Object)other)).intValue();
                totalKilled += ((Integer)result.getKillCounts().get((Object)other, (Object)botId)).intValue();
            }
            result.getTotalKills().put(botId, totalKills);
            result.getWasKilled().put(botId, totalKilled);
            if (!((UT2004DeathMatchConfig)this.config).isNativeBot(botId) && !((UT2004DeathMatchConfig)this.config).isHuman(botId)) continue;
            result.getSuicides().put(botId, result.getFinalScores().get(botId).getDeaths() - totalKilled);
        }
        boolean bl2 = false;
        if (!(winners.size() > 0 && finalScores.get(winners.get(0)).getScore() + 1 >= ((UT2004DeathMatchConfig)this.config).fragLimit || (time = result.matchTimeEnd) / 1000.0 + 15.0 >= (double)((UT2004DeathMatchConfig)this.config).getTimeLimit())) {
            bl = true;
        }
        result.matchFailure = bl;
        if (!result.matchFailure && winners.size() <= 0) {
            throw new PogamutException("There is no winner, impossible! **puzzled**", (Logger)this.log, (Object)this);
        }
        if (!result.matchFailure && winners.size() == 1) {
            result.setWinnerBot(bots.getBotId(winners.get(0)));
        } else {
            result.setDraw(true);
        }
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            if (result.matchFailure) {
                this.log.warning(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Results processed, FAILURE!");
            } else {
                this.log.warning(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Results processed, " + (result.isDraw() ? "DRAW!" : "WINNER is Bot[botId=" + result.getWinnerBot().getToken() + ", unrealId=" + bots.getUnrealId(result.getWinnerBot()).getStringId() + "]."));
            }
        }
        return result;
    }

    protected void outputResults_step1(UT2004DeathMatchResult result, File outputDirectory) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Outputting match result into CSV file...");
        }
        File file = new File(outputDirectory.getAbsolutePath() + File.separator + "match-" + ((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + "-result.csv");
        FilePath.makeDirsToFile((File)file);
        try {
            Formatter writer = new Formatter(file);
            writer.format("MatchId;FragLimit;TimeLimit;FragEnd;TimeEnd;Winner\n", new Object[0]);
            Object[] objectArray = new Object[6];
            objectArray[0] = ((UT2004DeathMatchConfig)this.config).getMatchId().getToken();
            objectArray[1] = ((UT2004DeathMatchConfig)this.config).getFragLimit();
            objectArray[2] = ((UT2004DeathMatchConfig)this.config).getTimeLimit();
            objectArray[3] = result.getWinnerBot() == null ? (result.getFinalScores().size() == 0 ? 0 : result.getFinalScores().values().iterator().next().getScore()) : result.getFinalScores().get(result.getWinnerBot()).getScore();
            objectArray[4] = result.getMatchTimeEnd();
            objectArray[5] = result.matchFailure ? "FAILURE" : (result.isDraw() ? "DRAW" : String.valueOf(result.getWinnerBot().getToken()));
            writer.format("%s;%d;%d;%d;%.3f;%s", objectArray);
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
        catch (IOException e) {
            throw new PogamutIOException("Failed to write results!", (Throwable)e, (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Match result output into " + file.getAbsolutePath() + ".");
        }
    }

    protected void outputResults_step2(UT2004DeathMatchResult result, File outputDirectory) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Outputting match scores into CSV file...");
        }
        File file = new File(outputDirectory.getAbsolutePath() + File.separator + "match-" + ((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + "-bot-scores.csv");
        FilePath.makeDirsToFile((File)file);
        try {
            Formatter writer = new Formatter(file);
            ArrayList<IToken> bots = new ArrayList<IToken>(((UT2004DeathMatchConfig)this.config).getBots().keySet());
            ArrayList<IToken> nativeBots = new ArrayList<IToken>(((UT2004DeathMatchConfig)this.config).getNativeBots().keySet());
            ArrayList<IToken> humans = new ArrayList<IToken>(((UT2004DeathMatchConfig)this.config).getHumans().keySet());
            Collections.sort(bots, new Comparator<IToken>(){

                @Override
                public int compare(IToken o1, IToken o2) {
                    return o1.getToken().compareTo(o2.getToken());
                }
            });
            Collections.sort(nativeBots, new Comparator<IToken>(){

                @Override
                public int compare(IToken o1, IToken o2) {
                    return o1.getToken().compareTo(o2.getToken());
                }
            });
            Collections.sort(humans, new Comparator<IToken>(){

                @Override
                public int compare(IToken o1, IToken o2) {
                    return o1.getToken().compareTo(o2.getToken());
                }
            });
            result.setBots(bots);
            result.setNativeBots(nativeBots);
            result.setHumans(humans);
            writer.format("botId", new Object[0]);
            writer.format(";name;score;kills;killedByOthers;deaths;suicides", new Object[0]);
            for (IToken token : ((UT2004DeathMatchConfig)this.config).getAllBotIds()) {
                writer.format(";", new Object[0]);
                writer.format(token.getToken(), new Object[0]);
            }
            for (IToken token : ((UT2004DeathMatchConfig)this.config).getAllBotIds()) {
                writer.format("\n", new Object[0]);
                writer.format(token.getToken(), new Object[0]);
                writer.format(";%s", result.getNames().get(token));
                writer.format(";%d", result.getFinalScores().get(token).getScore());
                writer.format(";%d", result.getTotalKills().get(token));
                writer.format(";%d", result.getWasKilled().get(token));
                writer.format(";%d", result.getFinalScores().get(token).getDeaths());
                writer.format(";%d", result.getSuicides().get(token));
                for (IToken token2 : ((UT2004DeathMatchConfig)this.config).getAllBotIds()) {
                    writer.format(";%d", result.getKillCounts().get((Object)token).get(token2));
                }
            }
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
        catch (IOException e) {
            throw new PogamutIOException("Failed to write results!", (Throwable)e, (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Match scores output into " + file.getAbsolutePath() + ".");
        }
    }

    @Override
    protected void outputResults(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, UT2004MatchResult result, File outputDirectory) {
        if (!(result instanceof UT2004DeathMatchResult)) {
            throw new PogamutException("Can't out results! Expected results of class UT2004DeathMatchResult and got " + result.getClass().getSimpleName() + "!", (Logger)this.log, (Object)this);
        }
        this.outputResults_step1((UT2004DeathMatchResult)result, outputDirectory);
        this.outputResults_step2((UT2004DeathMatchResult)result, outputDirectory);
    }

    @Override
    public UT2004DeathMatchResult execute() {
        try {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Executing!");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        UCCWrapper ucc = null;
        UT2004Server server = null;
        UT2004Match.Bots bots = null;
        UT2004Analyzer analyzer = null;
        String recordFileName = ((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + "-replay-" + UT2004Match.getCurrentDate();
        boolean exception = false;
        this.targetFragCount = ((UT2004DeathMatchConfig)this.getConfig()).getFragLimit();
        ((UT2004DeathMatchConfig)this.getConfig()).setFragLimit(this.targetFragCount + 10);
        try {
            this.setupLogger();
            this.validate();
            this.createUT2004Ini();
            this.createGB2004Ini();
            ucc = this.startUCC();
            server = this.startControlServer(ucc);
            bots = this.startBots(ucc, server);
            this.waitHumanPlayers(server, bots);
            analyzer = this.startAnalyzer(ucc, bots, this.getOutputPath("bots"), ((UT2004DeathMatchConfig)this.config).isHumanLikeLogEnabled());
            this.matchIsAboutToBegin(ucc, server, analyzer, bots);
            this.restartMatch(server, bots);
            this.recordReplay(server, recordFileName);
            UT2004DeathMatchResult result = (UT2004DeathMatchResult)this.waitMatchFinish(ucc, server, analyzer, bots, ((UT2004DeathMatchConfig)this.config).getTimeLimit() * 1000 + 60000);
            this.copyReplay(ucc, recordFileName, this.getOutputPath());
            this.outputResults(ucc, server, analyzer, bots, result, this.getOutputPath());
            this.shutdownAll(ucc, server, analyzer, bots);
            ucc = null;
            server = null;
            analyzer = null;
            bots = null;
            UT2004DeathMatchResult uT2004DeathMatchResult = result;
            return uT2004DeathMatchResult;
        }
        catch (Exception e) {
            if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(ExceptionToString.process((String)(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": EXCEPTION!"), (Throwable)e));
            }
            exception = true;
            if (e instanceof PogamutException) {
                throw (PogamutException)e;
            }
            throw new PogamutException((Throwable)e, (Logger)this.log, (Object)this);
        }
        finally {
            ((UT2004DeathMatchConfig)this.getConfig()).setFragLimit(this.targetFragCount);
            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Cleaning up...");
                }
            }
            catch (Exception exception2) {}
            if (ucc != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Killing UCC...");
                    }
                }
                catch (Exception exception3) {}
                try {
                    ucc.stop();
                }
                catch (Exception exception4) {}
            }
            if (server != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Killing UT2004Server...");
                    }
                }
                catch (Exception exception5) {}
                try {
                    server.kill();
                }
                catch (Exception exception6) {}
            }
            if (bots != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Killing Custom bots...");
                    }
                }
                catch (Exception exception7) {}
                for (UT2004BotExecution exec : bots.bots.values()) {
                    try {
                        exec.stop();
                    }
                    catch (Exception exception8) {}
                }
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Killing Custom bot observers...");
                    }
                }
                catch (Exception exception9) {}
                for (IUT2004AnalyzerObserver obs : bots.botObservers.values()) {
                    try {
                        obs.kill();
                    }
                    catch (Exception exception10) {}
                }
            }
            if (analyzer != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Killing UT2004Analyzer...");
                    }
                }
                catch (Exception exception11) {}
                try {
                    analyzer.kill();
                }
                catch (Exception exception12) {}
            }
            try {
                this.restoreUT2004IniBackup();
            }
            catch (Exception exception13) {}
            try {
                this.restoreGB2004IniBackup();
            }
            catch (Exception exception14) {}
            try {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    if (exception) {
                        this.log.warning(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Cleaned up, MATCH FAILED!");
                    } else {
                        this.log.warning(((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + ": Cleaned up, match finished successfully.");
                    }
                }
            }
            catch (Exception exception15) {}
            try {
                this.closeLogger();
            }
            catch (Exception exception16) {}
        }
    }
}

