/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.deathmatch;

import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentStats;
import cz.cuni.amis.pogamut.ut2004.analyzer.IUT2004AnalyzerObserver;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004Analyzer;
import cz.cuni.amis.pogamut.ut2004.analyzer.stats.UT2004AnalyzerObsStats;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StartPlayers;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerScore;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchResult;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004Match;
import cz.cuni.amis.pogamut.ut2004.tournament.match.result.UT2004MatchResult;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.FilePath;
import cz.cuni.amis.utils.Iterators;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.token.IToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004DeathMatch
extends UT2004Match<UT2004DeathMatchConfig, UT2004DeathMatchResult> {
    private int targetFragCount;

    public UT2004DeathMatch(UT2004DeathMatchConfig config, LogCategory log) {
        super(false, config, log);
    }

    @Override
    protected void changeBotTeam(UT2004Server server, UnrealId botId, int desiredTeam) {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected UT2004MatchResult waitMatchFinish(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, long timeoutInMillis) {
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Waiting for the match to finish...");
        }
        if ((long)(((UT2004DeathMatchConfig)this.config).getTimeLimit() * 60 * 1000 + 300000) > timeoutInMillis) {
            timeoutInMillis = ((UT2004DeathMatchConfig)this.config).getTimeLimit() * 60 * 1000 + 300000;
        }
        customBotObservers = new HashMap<IToken, 2>(((UT2004DeathMatchConfig)this.config).getBots().size());
        serverObs = null;
        uccObs = null;
        scoresListener = null;
        waitLatch = new CountDownLatch(1);
        oneOfBotsDiedOut = new AdaptableProvider((Object)false);
        serverDiedOut = new AdaptableProvider((Object)false);
        scores = new HashMap<UnrealId, PlayerScore>();
        exception = false;
        try {
            scoresListener = new IWorldEventListener<PlayerScore>(){

                public void notify(PlayerScore event) {
                    if (waitLatch == null || waitLatch.getCount() <= 0L) {
                        return;
                    }
                    scores.put(event.getId(), event);
                    if (event.getScore() >= UT2004DeathMatch.this.targetFragCount) {
                        waitLatch.countDown();
                    }
                }
            };
            ((UT2004WorldView)server.getWorldView()).addEventListener(PlayerScore.class, (IWorldEventListener)scoresListener);
            for (UT2004BotConfig botConfig : ((UT2004DeathMatchConfig)this.config).getBots().values()) {
                obs = new FlagListener<Boolean>(){

                    public void flagChanged(Boolean changedValue) {
                        if (!changedValue.booleanValue()) {
                            oneOfBotsDiedOut.set((Object)true);
                            waitLatch.countDown();
                        }
                    }
                };
                bots.bots.get(botConfig.getBotId()).getRunning().addListener((FlagListener)obs);
                customBotObservers.put(botConfig.getBotId(), obs);
                if (((Boolean)bots.bots.get(botConfig.getBotId()).getRunning().getFlag()).booleanValue()) continue;
                oneOfBotsDiedOut.set((Object)true);
                waitLatch.countDown();
                throw new PogamutException("One of custom bots died out from the start, failure!", (Logger)this.log, (Object)this);
            }
            serverObs = new FlagListener<IAgentState>(){

                public void flagChanged(IAgentState changedValue) {
                    if (changedValue instanceof IAgentStateDown) {
                        serverDiedOut.set((Object)true);
                        waitLatch.countDown();
                    }
                }
            };
            server.getState().addListener((FlagListener)serverObs);
            if (server.notInState(new Class[]{IAgentStateUp.class})) {
                serverDiedOut.set((Object)true);
                waitLatch.countDown();
                throw new PogamutException("Server is dead from the start, failure!", (Logger)this.log, (Object)this);
            }
            uccObs = new FlagListener<Boolean>(){

                public void flagChanged(Boolean changedValue) {
                    if (changedValue.booleanValue()) {
                        serverDiedOut.set((Object)true);
                        waitLatch.countDown();
                    }
                }
            };
            ucc.getGameEnding().addListener((FlagListener)uccObs);
            waitLatch.await(timeoutInMillis, TimeUnit.MILLISECONDS);
            if (waitLatch.getCount() > 0L) {
                throw new PogamutException("TIMEOUT! The match did not end in " + timeoutInMillis / 1000L + " secs.", (Logger)this.log, (Object)this);
            }
            bots.matchEnd = System.currentTimeMillis();
            ((UT2004DeathMatchConfig)this.getConfig()).setFragLimit(this.targetFragCount);
            if (((Boolean)oneOfBotsDiedOut.get()).booleanValue()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    throw new PogamutInterruptedException("Interrupted while giving GB2004 time to tear down its connection.", (Logger)this.log, (Object)this);
                }
                try {
                    server.getAct().act((CommandMessage)new StartPlayers());
                }
                catch (Exception e) {
                    serverDiedOut.set((Object)true);
                }
                if (!((Boolean)serverDiedOut.get()).booleanValue()) {
                    this.log.warning("ONE OF BOTS HAS DIED OUT, BUT SERVER IS STILL RUNNING ... POSSIBLE MATCH FAILURE!");
                }
            }
            if (!((Boolean)serverDiedOut.get()).booleanValue() && server.inState(new Class[]{IAgentStateUp.class})) {
                server.kill();
            }
            if (ucc != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Killing UCC...");
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    ucc.stop();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            winners = new ArrayList<UnrealId>(1);
            maxFrags = 0;
            playersIter = new Iterators(new Iterable[]{bots.unrealId2BotId.entrySet(), bots.nativeUnrealId2BotId.entrySet(), bots.humanUnrealId2HumanId.entrySet()});
            while (playersIter.hasNext()) {
                entry = (Map.Entry)playersIter.next();
                playerScore = (PlayerScore)scores.get(entry.getKey());
                if (playerScore == null) {
                    throw new PogamutException("Can't resolve the match result. One of the bot with botId '" + ((IToken)entry.getValue()).getToken() + "' and corresponding unrealId '" + ((UnrealId)entry.getKey()).getStringId() + "' has no score entry!", (Logger)this.log, (Object)this);
                }
                if (playerScore.getScore() == maxFrags) {
                    winners.add((UnrealId)entry.getKey());
                    continue;
                }
                if (playerScore.getScore() <= maxFrags) continue;
                maxFrags = playerScore.getScore();
                winners.clear();
                winners.add((UnrealId)entry.getKey());
            }
            if (winners.size() == 0) {
                throw new PogamutException("There is no winner, impossible! **puzzled**", (Logger)this.log, (Object)this);
            }
            if (winners.size() > 1) {
                sb = new StringBuffer();
                sb.append("There is more than one bot with highest score == " + maxFrags + ": ");
                first = true;
                for (UnrealId id : winners) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append("Bot[botId=" + bots.getBotId(id) + ", unrealId=" + id.getStringId() + ", score=" + ((PlayerScore)scores.get(id)).getScore() + "]");
                }
                sb.append(".");
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(sb.toString());
                }
            }
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": MATCH FINISHED!");
            }
            var24_29 = this.processResults(ucc, server, analyzer, bots, winners, scores);
            return var24_29;
        }
        catch (Exception e) {
            exception = true;
            throw new PogamutException("Failed to perform the match!", (Throwable)e, (Logger)this.log, (Object)this);
        }
        finally {
            ** for (entry : customBotObservers.entrySet())
        }
lbl-1000:
        // 1 sources

        {
            bots.bots.get(entry.getKey()).getRunning().removeListener((FlagListener)entry.getValue());
            continue;
        }
lbl117:
        // 1 sources

        server.getState().removeListener(serverObs);
        ((UT2004WorldView)server.getWorldView()).removeEventListener(PlayerScore.class, (IWorldEventListener)scoresListener);
        throw var23_34;
    }

    protected UT2004DeathMatchResult processResults(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, List<UnrealId> winners, Map<UnrealId, PlayerScore> finalScores) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Processing results...");
        }
        UT2004DeathMatchResult result = new UT2004DeathMatchResult();
        result.setMatchTimeEnd(((double)bots.matchEnd - (double)bots.matchStart) / 1000.0);
        for (Map.Entry<UnrealId, PlayerScore> entry : finalScores.entrySet()) {
            result.getFinalScores().put(bots.getBotId(entry.getKey()), entry.getValue());
        }
        for (Map.Entry<IToken, IUT2004AnalyzerObserver> entry : bots.botObservers.entrySet()) {
            if (!(entry.getValue() instanceof UT2004AnalyzerObsStats)) {
                throw new PogamutException("There is an observer of wrong class, expecting UT2004AnalyzerObsStats, got " + entry.getValue().getClass().getSimpleName() + "!", (Logger)this.log, (Object)this);
            }
            result.getBotObservers().put(entry.getKey(), (UT2004AnalyzerObsStats)entry.getValue());
        }
        List<IToken> list = ((UT2004DeathMatchConfig)this.config).getAllBotIds();
        for (IToken iToken : list) {
            result.getNames().put(iToken, bots.names.get(bots.getUnrealId(iToken)));
            result.getTotalKills().put(iToken, 0);
            result.getWasKilled().put(iToken, 0);
            result.getSuicides().put(iToken, 0);
            for (IToken botId2 : list) {
                result.getKillCounts().put((Object)iToken, (Object)botId2, (Object)0);
            }
        }
        for (Map.Entry entry : result.getBotObservers().entrySet()) {
            IToken botId = (IToken)entry.getKey();
            UT2004AnalyzerObsStats obs = (UT2004AnalyzerObsStats)entry.getValue();
            AgentStats stats = obs.getStats();
            for (Map.Entry killed : stats.getKilled().entrySet()) {
                result.getKillCounts().get((Object)botId).put(bots.getBotId((UnrealId)killed.getKey()), (Integer)killed.getValue());
            }
            for (Map.Entry killedBy : stats.getKilledBy().entrySet()) {
                if (!bots.isNativeBot((UnrealId)killedBy.getKey())) continue;
                result.getKillCounts().get((Object)bots.getBotId((UnrealId)killedBy.getKey())).put(botId, (Integer)killedBy.getValue());
            }
            result.getSuicides().put(botId, stats.getSuicides());
            result.getKillCounts().put((Object)botId, (Object)botId, (Object)stats.getSuicides());
        }
        for (IToken iToken : ((UT2004DeathMatchConfig)this.config).getNativeBots().keySet()) {
            for (IToken nativeBotId2 : ((UT2004DeathMatchConfig)this.config).getNativeBots().keySet()) {
                if (iToken == nativeBotId2) continue;
                result.getKillCounts().get((Object)iToken).put(nativeBotId2, 0);
            }
            result.getSuicides().put(iToken, 0);
        }
        for (IToken iToken : list) {
            int totalKills = 0;
            int totalKilled = 0;
            for (IToken other : list) {
                if (iToken == other) continue;
                totalKills += ((Integer)result.getKillCounts().get((Object)iToken, (Object)other)).intValue();
                totalKilled += ((Integer)result.getKillCounts().get((Object)other, (Object)iToken)).intValue();
            }
            result.getTotalKills().put(iToken, totalKills);
            result.getWasKilled().put(iToken, totalKilled);
            if (!((UT2004DeathMatchConfig)this.config).isNativeBot(iToken) && !((UT2004DeathMatchConfig)this.config).isHuman(iToken)) continue;
            result.getSuicides().put(iToken, result.getFinalScores().get(iToken).getDeaths() - totalKilled);
        }
        if (winners.size() <= 0) {
            throw new PogamutException("There is no winner, impossible! **puzzled**", (Logger)this.log, (Object)this);
        }
        if (winners.size() == 1) {
            result.setWinnerBot(bots.getBotId(winners.get(0)));
        } else {
            result.setDraw(true);
        }
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Results processed, " + (result.isDraw() ? "DRAW!" : "WINNER is Bot[botId=" + result.getWinnerBot().getToken() + ", unrealId=" + bots.getUnrealId(result.getWinnerBot()).getStringId() + "]."));
        }
        return result;
    }

    protected void outputResults_step1(UT2004DeathMatchResult result, File outputDirectory) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Outputting match result into CSV file...");
        }
        File file = new File(String.valueOf(outputDirectory.getAbsolutePath()) + File.separator + "match-" + ((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + "-result.csv");
        FilePath.makeDirsToFile((File)file);
        try {
            Formatter writer = new Formatter(file);
            writer.format("MatchId;FragLimit;TimeLimit;FragEnd;TimeEnd;Winner\n", new Object[0]);
            Object[] objectArray = new Object[6];
            objectArray[0] = ((UT2004DeathMatchConfig)this.config).getMatchId().getToken();
            objectArray[1] = ((UT2004DeathMatchConfig)this.config).getFragLimit();
            objectArray[2] = ((UT2004DeathMatchConfig)this.config).getTimeLimit();
            objectArray[3] = result.getWinnerBot() == null ? (result.getFinalScores().size() == 0 ? 0 : result.getFinalScores().values().iterator().next().getScore()) : result.getFinalScores().get(result.getWinnerBot()).getScore();
            objectArray[4] = result.getMatchTimeEnd();
            objectArray[5] = result.isDraw() ? "DRAW" : String.valueOf(result.getWinnerBot().getToken());
            writer.format("%s;%d;%d;%d;%.3f;%s", objectArray);
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
        catch (IOException e) {
            throw new PogamutIOException("Failed to write results!", (Throwable)e, (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Match result output into " + file.getAbsolutePath() + ".");
        }
    }

    protected void outputResults_step2(UT2004DeathMatchResult result, File outputDirectory) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Outputting match scores into CSV file...");
        }
        File file = new File(String.valueOf(outputDirectory.getAbsolutePath()) + File.separator + "match-" + ((UT2004DeathMatchConfig)this.config).getMatchId().getToken() + "-bot-scores.csv");
        FilePath.makeDirsToFile((File)file);
        try {
            Formatter writer = new Formatter(file);
            ArrayList<IToken> bots = new ArrayList<IToken>(((UT2004DeathMatchConfig)this.config).getBots().keySet());
            ArrayList<IToken> nativeBots = new ArrayList<IToken>(((UT2004DeathMatchConfig)this.config).getNativeBots().keySet());
            ArrayList<IToken> humans = new ArrayList<IToken>(((UT2004DeathMatchConfig)this.config).getHumans().keySet());
            Collections.sort(bots, new Comparator<IToken>(){

                @Override
                public int compare(IToken o1, IToken o2) {
                    return o1.getToken().compareTo(o2.getToken());
                }
            });
            Collections.sort(nativeBots, new Comparator<IToken>(){

                @Override
                public int compare(IToken o1, IToken o2) {
                    return o1.getToken().compareTo(o2.getToken());
                }
            });
            Collections.sort(humans, new Comparator<IToken>(){

                @Override
                public int compare(IToken o1, IToken o2) {
                    return o1.getToken().compareTo(o2.getToken());
                }
            });
            result.setBots(bots);
            result.setNativeBots(nativeBots);
            result.setHumans(humans);
            writer.format("botId", new Object[0]);
            writer.format(";name;score;kills;killedByOthers;deaths;suicides", new Object[0]);
            for (IToken token : ((UT2004DeathMatchConfig)this.config).getAllBotIds()) {
                writer.format(";", new Object[0]);
                writer.format(token.getToken(), new Object[0]);
            }
            for (IToken token : ((UT2004DeathMatchConfig)this.config).getAllBotIds()) {
                writer.format("\n", new Object[0]);
                writer.format(token.getToken(), new Object[0]);
                writer.format(";%s", result.getNames().get(token));
                writer.format(";%d", result.getFinalScores().get(token).getScore());
                writer.format(";%d", result.getTotalKills().get(token));
                writer.format(";%d", result.getWasKilled().get(token));
                writer.format(";%d", result.getFinalScores().get(token).getDeaths());
                writer.format(";%d", result.getSuicides().get(token));
                for (IToken token2 : ((UT2004DeathMatchConfig)this.config).getAllBotIds()) {
                    writer.format(";%d", result.getKillCounts().get((Object)token).get(token2));
                }
            }
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
        catch (IOException e) {
            throw new PogamutIOException("Failed to write results!", (Throwable)e, (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Match scores output into " + file.getAbsolutePath() + ".");
        }
    }

    @Override
    protected void outputResults(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, UT2004MatchResult result, File outputDirectory) {
        if (!(result instanceof UT2004DeathMatchResult)) {
            throw new PogamutException("Can't out results! Expected results of class UT2004DeathMatchResult and got " + result.getClass().getSimpleName() + "!", (Logger)this.log, (Object)this);
        }
        this.outputResults_step1((UT2004DeathMatchResult)result, outputDirectory);
        this.outputResults_step2((UT2004DeathMatchResult)result, outputDirectory);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public UT2004DeathMatchResult execute() {
        block84: {
            try {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Executing!");
                }
            }
            catch (Exception var1_1) {
                // empty catch block
            }
            ucc = null;
            server = null;
            bots = null;
            analyzer = null;
            recordFileName = String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + "-replay-" + UT2004Match.getCurrentDate();
            exception = false;
            this.targetFragCount = ((UT2004DeathMatchConfig)this.getConfig()).getFragLimit();
            ((UT2004DeathMatchConfig)this.getConfig()).setFragLimit(this.targetFragCount + 10);
            try {
                this.setupLogger();
                this.validate();
                this.createUT2004Ini();
                this.createGB2004Ini();
                ucc = this.startUCC();
                server = this.startControlServer(ucc);
                bots = this.startBots(ucc, server);
                this.waitHumanPlayers(server, bots);
                analyzer = this.startAnalyzer(ucc, bots, this.getOutputPath("bots"), ((UT2004DeathMatchConfig)this.config).isHumanLikeLogEnabled());
                this.matchIsAboutToBegin(ucc, server, analyzer, bots);
                this.restartMatch(server, bots);
                this.recordReplay(server, recordFileName);
                result = (UT2004DeathMatchResult)this.waitMatchFinish(ucc, server, analyzer, bots, ((UT2004DeathMatchConfig)this.config).getTimeLimit() * 1000 + 60000);
                this.copyReplay(ucc, recordFileName, this.getOutputPath());
                this.outputResults(ucc, server, analyzer, bots, result, this.getOutputPath());
                this.shutdownAll(ucc, server, analyzer, bots);
                ucc = null;
                server = null;
                analyzer = null;
                bots = null;
                var9_10 = result;
                return var9_10;
            }
            catch (Exception e) {
                if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                    this.log.severe(ExceptionToString.process((String)(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": EXCEPTION!"), (Throwable)e));
                }
                exception = true;
                if (e instanceof PogamutException) {
                    throw (PogamutException)e;
                }
                throw new PogamutException((Throwable)e, (Logger)this.log, (Object)this);
            }
            finally {
                ((UT2004DeathMatchConfig)this.getConfig()).setFragLimit(this.targetFragCount);
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Cleaning up...");
                    }
                }
                catch (Exception obs) {}
                if (ucc != null) {
                    try {
                        if (this.log != null && this.log.isLoggable(Level.INFO)) {
                            this.log.info(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Killing UCC...");
                        }
                    }
                    catch (Exception obs) {}
                    try {
                        ucc.stop();
                    }
                    catch (Exception obs) {}
                }
                if (server != null) {
                    try {
                        if (this.log != null && this.log.isLoggable(Level.INFO)) {
                            this.log.info(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Killing UT2004Server...");
                        }
                    }
                    catch (Exception obs) {}
                    try {
                        server.kill();
                    }
                    catch (Exception obs) {}
                }
                if (bots == null) break block84;
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Killing Custom bots...");
                    }
                }
                catch (Exception obs) {}
                ** for (exec : bots.bots.values())
            }
lbl-1000:
            // 1 sources

            {
                try {
                    exec.stop();
                }
                catch (Exception var12_44) {
                    // empty catch block
                }
                continue;
            }
lbl87:
            // 1 sources

            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Killing Custom bot observers...");
                }
            }
            catch (Exception exec) {
                // empty catch block
            }
            for (IUT2004AnalyzerObserver obs : bots.botObservers.values()) {
                try {
                    obs.kill();
                }
                catch (Exception var12_46) {
                    // empty catch block
                }
            }
        }
        if (analyzer != null) {
            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Killing UT2004Analyzer...");
                }
            }
            catch (Exception var10_33) {
                // empty catch block
            }
            try {
                analyzer.kill();
            }
            catch (Exception var10_34) {
                // empty catch block
            }
        }
        try {
            this.restoreUT2004IniBackup();
        }
        catch (Exception var10_35) {
            // empty catch block
        }
        try {
            this.restoreGB2004IniBackup();
        }
        catch (Exception var10_36) {
            // empty catch block
        }
        try {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                if (exception) {
                    this.log.warning(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Cleaned up, MATCH FAILED!");
                } else {
                    this.log.warning(String.valueOf(((UT2004DeathMatchConfig)this.config).getMatchId().getToken()) + ": Cleaned up, match finished successfully.");
                }
            }
        }
        catch (Exception var10_37) {
            // empty catch block
        }
        try {
            this.closeLogger();
        }
        catch (Exception var10_38) {
            // empty catch block
        }
        throw var8_47;
    }
}

