/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.botexecution;

import cz.cuni.amis.pogamut.ut2004.tournament.botexecution.UT2004BotExecutionConfig;
import cz.cuni.amis.pogamut.ut2004.utils.PogamutUT2004Property;
import cz.cuni.amis.utils.StreamSink;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004BotExecution {
    protected UT2004BotExecutionConfig config;
    protected Flag<Boolean> running = new Flag((Object)false);
    protected Process botProcess = null;
    protected StreamSink streamSinkOutput = null;
    protected StreamSink streamSinkError = null;
    protected Logger log;
    protected Runnable shutDownHook = new Runnable(){

        @Override
        public void run() {
            if (UT2004BotExecution.this.botProcess != null) {
                UT2004BotExecution.this.botProcess.destroy();
            }
        }
    };
    protected Thread shutDownHookThread;
    protected Runnable waitForEnd = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                UT2004BotExecution.this.botProcess.waitFor();
                return;
            }
            catch (InterruptedException e) {
                Flag<Boolean> flag = UT2004BotExecution.this.running;
                synchronized (flag) {
                    if (!((Boolean)UT2004BotExecution.this.running.getFlag()).booleanValue()) {
                        return;
                    }
                }
                if (UT2004BotExecution.this.log == null) return;
                if (!UT2004BotExecution.this.log.isLoggable(Level.WARNING)) return;
                UT2004BotExecution.this.log.warning("Interrupted while waiting for the botProcess(" + UT2004BotExecution.this.config.getBotId().getToken() + ") to end!");
                return;
            }
            finally {
                Flag<Boolean> flag = UT2004BotExecution.this.running;
                synchronized (flag) {
                    if (!((Boolean)UT2004BotExecution.this.running.getFlag()).booleanValue()) {
                        return;
                    }
                    if (UT2004BotExecution.this.waitForEndThread == Thread.currentThread()) {
                        UT2004BotExecution.this.shutdown(true);
                    }
                }
            }
        }
    };
    protected Thread waitForEndThread;

    public UT2004BotExecution(UT2004BotExecutionConfig config, Logger log) {
        this.log = log;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String host, int port) throws PogamutIOException {
        Flag<Boolean> flag = this.running;
        synchronized (flag) {
            if (((Boolean)this.running.getFlag()).booleanValue()) {
                throw new PogamutException("Could not start the bot again, it is already running! stop() it first!", this.log, (Object)this);
            }
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Starting bot: " + this.config);
            }
            if (!this.config.isBotJarExist()) {
                throw new PogamutException("Could not start the bot according to config " + this.config + " as the bot jar does not exist at specified place " + this.config.getJarFile().getAbsolutePath() + "!", (Object)this);
            }
            String javaHome = System.getProperty("JAVA_HOME");
            boolean linux = System.getProperty("os.name").toLowerCase().contains("linux");
            String command = javaHome == null ? (linux ? "java" : "java.exe") : javaHome + (linux ? "/bin/java" : "\\bin\\java.exe");
            String fullCommand = command + " \"-D" + PogamutUT2004Property.POGAMUT_UT2004_BOT_HOST.getKey() + "=" + host + "\"" + " \"-D" + PogamutUT2004Property.POGAMUT_UT2004_BOT_PORT.getKey() + "=" + port + "\"" + " -jar \"" + this.config.getJarFile().getAbsolutePath() + "\"";
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info("Executing command: " + fullCommand);
            }
            ProcessBuilder procBuilder = new ProcessBuilder(command, "-D" + PogamutUT2004Property.POGAMUT_UT2004_BOT_HOST.getKey() + "=" + host, "-D" + PogamutUT2004Property.POGAMUT_UT2004_BOT_PORT.getKey() + "=" + port, "-jar", this.config.getJarFile().getAbsolutePath());
            procBuilder.directory(new File(this.config.getJarFile().getParent()));
            try {
                this.botProcess = procBuilder.start();
            }
            catch (IOException e) {
                if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                    this.log.severe("Could not start the bot: " + e.getMessage());
                }
                this.botProcess = null;
                throw new PogamutIOException("Failed to start the botProcess(" + this.config.getBotId().getToken() + "). IOException: " + e.getMessage(), (Throwable)e, (Object)this);
            }
            this.streamSinkError = this.config.isRedirectStdErr() ? new StreamSink(this.config.getBotId().getToken() + "-StdErrSink", this.botProcess.getErrorStream(), this.log, this.config.getBotId().getToken() + "-StdErr") : new StreamSink(this.config.getBotId().getToken() + "-StdErrSink", this.botProcess.getErrorStream());
            this.streamSinkError.start();
            this.streamSinkOutput = this.config.isRedirectStdOut() ? new StreamSink(this.config.getBotId().getToken() + "-StdOutSink", this.botProcess.getInputStream(), this.log, this.config.getBotId().getToken() + "-StdOut") : new StreamSink(this.config.getBotId().getToken() + "-StdOutSink", this.botProcess.getInputStream());
            this.streamSinkOutput.start();
            this.shutDownHookThread = new Thread(this.shutDownHook, this.config.getBotId().getToken() + "-JVMShutdownHook");
            Runtime.getRuntime().addShutdownHook(this.shutDownHookThread);
            this.waitForEndThread = new Thread(this.waitForEnd, this.config.getBotId().getToken() + "-WaitForProcessEnd");
            this.running.setFlag((Object)true);
            this.waitForEndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown(boolean waitForEndThread) {
        Flag<Boolean> flag = this.running;
        synchronized (flag) {
            if (!((Boolean)this.running.getFlag()).booleanValue()) {
                return;
            }
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Shutting down botProcess(" + this.config.getBotId().getToken() + ")!");
            }
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... destroying botProcess(" + this.config.getBotId().getToken() + ").");
            }
            if (this.botProcess != null) {
                try {
                    this.botProcess.destroy();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.botProcess = null;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... destroying streamSinkError(" + this.config.getBotId().getToken() + ").");
            }
            try {
                if (this.streamSinkError != null) {
                    this.streamSinkError.interrupt();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.streamSinkError = null;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... destroying streamSinkOutput(" + this.config.getBotId().getToken() + ").");
            }
            try {
                if (this.streamSinkOutput != null) {
                    this.streamSinkOutput.interrupt();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.streamSinkOutput = null;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... destroying waitForEnd(" + this.config.getBotId().getToken() + ").");
            }
            if (!waitForEndThread) {
                try {
                    if (this.waitForEndThread != null) {
                        this.waitForEndThread.interrupt();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.waitForEndThread = null;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... removing shutDownHook(" + this.config.getBotId().getToken() + ").");
            }
            if (this.shutDownHookThread != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutDownHookThread);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.shutDownHookThread = null;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... setting running-flag(" + this.config.getBotId().getToken() + ") to FALSE.");
            }
            this.running.setFlag((Object)false);
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Shutdown(" + this.config.getBotId().getToken() + ") finished.");
            }
        }
    }

    public void stop() {
        this.shutdown(false);
    }

    public Process getBotProcess() {
        return this.botProcess;
    }

    public ImmutableFlag<Boolean> getRunning() {
        return this.running.getImmutable();
    }

    public boolean isRunning() {
        return (Boolean)this.running.getFlag();
    }
}

