/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.summary;

import cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.one.TDMOneMatchExcelReport;
import cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.one.TDMOneMatchResult;
import cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.one.TDMOneMatchTableResults;
import cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.summary.TDMMatchesResult;
import cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.summary.TDMMatchesTableResults;
import cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.summary.TDMMatchesTableTeamResult;
import cz.cuni.amis.pogamut.ut2004.tournament.utils.ExcelReport;
import cz.cuni.amis.utils.maps.LazyMap;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.biff.WritableWorkbookImpl;

public class TDMMatchesExcelReport
extends ExcelReport {
    private File resultDir;
    private File outputFile;
    private static final Pattern DIR_NAME = Pattern.compile("([0-9]*)-(.*)");
    private FileOutputStream outputStream;
    private WritableWorkbookImpl work;
    private TDMMatchesTableResults tableResults;
    private List<TDMMatchesTableTeamResult> players;

    public TDMMatchesExcelReport(File resultDir, File outputFile) {
        this.resultDir = resultDir;
        this.outputFile = outputFile;
    }

    @Override
    public void info(String msg) {
        System.out.println("[INFO] " + msg);
    }

    @Override
    public void warn(String msg) {
        System.out.println("[WARN] " + msg);
    }

    @Override
    public void error(String msg) {
        System.out.println("[ERROR] " + msg);
    }

    private static String getName(File file) {
        if (file.getAbsolutePath().indexOf("/") > 0) {
            return file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf("/") + 1);
        }
        return file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf("\\") + 1);
    }

    public synchronized void generate() {
        ArrayList<TDMOneMatchTableResults> mapResults = new ArrayList<TDMOneMatchTableResults>();
        File[] fileArray = this.resultDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                String name;
                Matcher m;
                File dir = fileArray[n2];
                if (dir.isDirectory() && (m = DIR_NAME.matcher(name = TDMMatchesExcelReport.getName(dir))).find()) {
                    String mapNumberStr = m.group(1);
                    String mapName = m.group(2);
                    int mapNumber = 0;
                    try {
                        mapNumber = Integer.parseInt(mapNumberStr);
                    }
                    catch (Exception e) {
                        break block14;
                    }
                    TDMOneMatchTableResults mapResult = new TDMOneMatchExcelReport(dir, new File(dir, "Result-" + name + ".xls"), mapName, mapNumber).generate();
                    mapResults.add(mapResult);
                }
            }
            ++n2;
        }
        LazyMap<String, Set<String>> teamPairs = new LazyMap<String, Set<String>>(){

            protected Set<String> create(String key) {
                return new HashSet<String>();
            }
        };
        for (TDMOneMatchTableResults mapResult : mapResults) {
            for (String teamA : mapResult.teams.keySet()) {
                for (String teamB : mapResult.teams.keySet()) {
                    if (teamA.compareTo(teamB) >= 0) continue;
                    ((Set)teamPairs.get(teamA)).add(teamB);
                }
            }
        }
        this.tableResults = new TDMMatchesTableResults();
        for (String team1 : teamPairs.keySet()) {
            for (String team2 : (Set)teamPairs.get(team1)) {
                int score1 = 0;
                int score2 = 0;
                int frags1 = 0;
                int frags2 = 0;
                int deaths1 = 0;
                int deaths2 = 0;
                int exceptions1 = 0;
                int exceptions2 = 0;
                for (TDMOneMatchTableResults mapResult : mapResults) {
                    TDMOneMatchResult oneResult = mapResult.getMatchResult(team1, team2);
                    if (oneResult == null) continue;
                    if (oneResult.isException(team1)) {
                        ++exceptions1;
                    }
                    if (oneResult.isException(team2)) {
                        ++exceptions2;
                    }
                    if (oneResult.isWin(team1)) {
                        ++score1;
                    }
                    if (oneResult.isWin(team2)) {
                        ++score2;
                    }
                    frags1 += oneResult.getScore(team1);
                    frags2 += oneResult.getScore(team2);
                    deaths1 += oneResult.getScore(team2);
                    deaths2 += oneResult.getScore(team1);
                }
                this.tableResults.addResult(team1, team2, score1, score2, frags1, frags2, deaths1, deaths2, exceptions1, exceptions2);
            }
        }
        this.players = this.tableResults.resolve();
        this.produceExcel(this.outputFile);
    }

    @Override
    protected void produceExcel(File outputFile, WritableWorkbookImpl workbook, WritableSheet sheet) throws Exception {
        this.info("OUTPUTING RESULTS");
        for (TDMMatchesTableTeamResult player : this.players) {
            this.info("-- " + player.position + ". " + player.team + " (W" + player.wins + ":D" + player.draws + ":L" + player.loses + ":E" + player.exceptions + ") (F" + player.frags + ":D" + player.deaths + ")");
        }
        ArrayList<TDMMatchesTableTeamResult> playersAlpha = new ArrayList<TDMMatchesTableTeamResult>(this.players);
        Collections.sort(playersAlpha, new Comparator<TDMMatchesTableTeamResult>(){

            @Override
            public int compare(TDMMatchesTableTeamResult o1, TDMMatchesTableTeamResult o2) {
                return o1.team.compareTo(o2.team);
            }
        });
        sheet.addCell((WritableCell)this.newStringCell("A", 0, "DeathMatch Tournament"));
        sheet.addCell((WritableCell)this.newStringCell("A", 1, "Table"));
        sheet.addCell((WritableCell)this.newStringCell("A", 2, ""));
        sheet.addCell(this.center((WritableCell)this.newStringCell("A", 3, "No.")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("B", 3, "Participant")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("C", 3, "Frags")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("D", 3, ":")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("E", 3, "Deaths")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("F", 3, "#Wins")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("G", 3, "#Draws")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("H", 3, "#Loses")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("I", 3, "#Exceptions")));
        int col = 0;
        int row = 3;
        for (TDMMatchesTableTeamResult player : this.players) {
            sheet.addCell(this.center((WritableCell)this.newIntCell("A", ++row, player.position)));
            sheet.addCell((WritableCell)this.newStringCell("B", row, player.team));
            sheet.addCell(this.center((WritableCell)this.newIntCell("C", row, player.frags)));
            sheet.addCell(this.center((WritableCell)this.newStringCell("D", row, ":")));
            sheet.addCell(this.center((WritableCell)this.newIntCell("E", row, player.deaths)));
            sheet.addCell(this.center((WritableCell)this.newIntCell("F", row, player.wins)));
            sheet.addCell(this.center((WritableCell)this.newIntCell("G", row, player.draws)));
            sheet.addCell(this.center((WritableCell)this.newIntCell("H", row, player.loses)));
            sheet.addCell(this.center((WritableCell)this.newIntCell("I", row, player.exceptions)));
        }
        int startCol = 10;
        int startRow = 3;
        col = startCol + 1;
        row = startRow;
        sheet.addCell((WritableCell)this.newStringCell(col++, row, "TABLE"));
        for (TDMMatchesTableTeamResult player : playersAlpha) {
            sheet.addCell((WritableCell)this.newStringCell(col++, row, ""));
            sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, player.team))));
            sheet.addCell((WritableCell)this.newStringCell(col++, row, ""));
        }
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Frags"))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, ""))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Deaths"))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Wins"))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Draws"))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Loses"))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Exceptions"))));
        for (TDMMatchesTableTeamResult player1 : playersAlpha) {
            col = startCol + 1;
            sheet.addCell((WritableCell)this.newStringCell(col++, ++row, player1.team));
            for (TDMMatchesTableTeamResult player2 : playersAlpha) {
                if (player1 == player2) {
                    sheet.addCell((WritableCell)this.newStringCell(col++, row, ""));
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, "X")));
                    sheet.addCell((WritableCell)this.newStringCell(col++, row, ""));
                    continue;
                }
                TDMMatchesResult match = this.tableResults.getMatchResult(player1.team, player2.team);
                if (match == null) {
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, "x")));
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, ":")));
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, "x")));
                    continue;
                }
                sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, match.getScore(player1.team))));
                sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, ":")));
                sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, match.getScore(player2.team))));
            }
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.frags)));
            sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, ":")));
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.deaths)));
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.wins)));
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.draws)));
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.loses)));
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.exceptions)));
        }
    }
}

