/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.tdm.table;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.summary.TDMMatchesExcelReport;
import java.io.File;

public class MainExcel {
    private static final char ARG_RESULT_DIR_SHORT = 'r';
    private static final String ARG_RESULT_DIR_LONG = "result-directory";
    private static final char ARG_OUTPUT_DIR_SHORT = 'o';
    private static final String ARG_OUTPUT_DIR_LONG = "output-directory";
    private static final char ARG_OUTPUT_FILE_NAME_SHORT = 'f';
    private static final String ARG_OUTPUT_FILE_NAME_LONG = "output-file-name";
    private static JSAP jsap;
    private static JSAPResult config;
    private static boolean headerOutput;
    private static String resultDir;
    private static String outputDir;
    private static String outputFileName;
    private static File resultDirFile;
    private static File outputDirFile;
    private static File outputFile;

    static {
        headerOutput = false;
    }

    private static void fail(String errorMessage) {
        MainExcel.fail(errorMessage, null);
    }

    private static void fail(String errorMessage, Throwable e) {
        MainExcel.header();
        System.out.println("ERROR: " + errorMessage);
        System.out.println();
        if (e != null) {
            e.printStackTrace();
            System.out.println("");
        }
        System.out.println("Usage: java -jar ut2004-tournament-tdm-excel-onejar.jar ");
        System.out.println("                " + jsap.getUsage());
        System.out.println();
        System.out.println(jsap.getHelp());
        System.out.println();
        throw new RuntimeException("FAILURE: " + errorMessage);
    }

    private static void header() {
        if (headerOutput) {
            return;
        }
        System.out.println();
        System.out.println("====================================================");
        System.out.println("Pogamut UT2004 TeamDeathMatch Table Result Generator");
        System.out.println("====================================================");
        System.out.println();
        headerOutput = true;
    }

    private static void info(String msg) {
        System.out.println("[INFO]    " + msg);
    }

    private static void warning(String msg) {
        System.out.println("[WARNING] " + msg);
    }

    private static void severe(String msg) {
        System.out.println("[SEVERE]  " + msg);
    }

    private static void initJSAP() throws JSAPException {
        jsap = new JSAP();
        FlaggedOption opt8 = new FlaggedOption(ARG_RESULT_DIR_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('r').setLongFlag(ARG_RESULT_DIR_LONG).setDefault(".");
        opt8.setHelp("PATH/TO/directory where to search for results (output directory of TDMTable).");
        jsap.registerParameter((Parameter)opt8);
        FlaggedOption opt9 = new FlaggedOption(ARG_OUTPUT_DIR_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('o').setLongFlag(ARG_OUTPUT_DIR_LONG).setDefault(".");
        opt9.setHelp("PATH/TO/directory where to output results (does not need to exist).");
        jsap.registerParameter((Parameter)opt9);
        FlaggedOption opt1 = new FlaggedOption(ARG_OUTPUT_FILE_NAME_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('f').setLongFlag(ARG_OUTPUT_FILE_NAME_LONG).setDefault("TDMTable-Results.xls");
        opt1.setHelp("Name of the filename to produce. If it won't end with .xls, it will be extended with this suffix.");
        jsap.registerParameter((Parameter)opt1);
    }

    /*
     * Unable to fully structure code
     */
    private static void readConfig(String[] args) {
        block3: {
            block4: {
                System.out.println("Parsing command arguments.");
                try {
                    MainExcel.config = MainExcel.jsap.parse(args);
                }
                catch (Exception e) {
                    MainExcel.fail(e.getMessage());
                    System.out.println("");
                    e.printStackTrace();
                    throw new RuntimeException("FAILURE!");
                }
                if (MainExcel.config.success()) break block3;
                error = "Invalid arguments specified.";
                errorIter = MainExcel.config.getErrorMessageIterator();
                if (errorIter.hasNext()) ** GOTO lbl17
                error = String.valueOf(error) + "\n-- No details given.";
                break block4;
lbl-1000:
                // 1 sources

                {
                    error = String.valueOf(error) + "\n-- " + errorIter.next();
lbl17:
                    // 2 sources

                    ** while (errorIter.hasNext())
                }
            }
            MainExcel.fail(error);
        }
        MainExcel.resultDir = MainExcel.config.getString("result-directory");
        MainExcel.outputDir = MainExcel.config.getString("output-directory");
        MainExcel.outputFileName = MainExcel.config.getString("output-file-name");
    }

    private static void sanityChecks() {
        System.out.println("Sanity checks...");
        resultDirFile = new File(resultDir);
        if (!resultDirFile.exists() || !resultDirFile.isDirectory()) {
            MainExcel.fail("Result directory was not found at '" + resultDirFile.getAbsolutePath() + "', path resolved from configuration read as '" + resultDir + "'.");
        }
        System.out.println("-- Result directory found at '" + resultDirFile.getAbsolutePath() + "'");
        outputDirFile = new File(outputDir);
        boolean outputDirExist = true;
        if (!outputDirFile.exists()) {
            outputDirExist = false;
            outputDirFile.mkdirs();
        }
        if (!outputDirFile.exists() || !outputDirFile.isDirectory()) {
            MainExcel.fail("Failed to create output directory at '" + outputDirFile.getAbsolutePath() + "', path resolved from configuration read as '" + outputDir + "'.");
        }
        System.out.println("-- Output directory " + (outputDirExist ? "found" : "created") + " at '" + outputDirFile.getAbsolutePath() + "'");
        if (!outputFileName.toLowerCase().endsWith(".xls")) {
            outputFileName = String.valueOf(outputFileName) + ".xls";
        }
        outputFile = new File(outputDir, outputFileName);
        System.out.println("-- Going to write results into file '" + outputFile.getAbsolutePath() + "'");
        if (outputFile.exists()) {
            if (!outputFile.isFile()) {
                MainExcel.fail("Cannot overwrite output file as it exists and is not a file. Output file at '" + outputFile.getAbsolutePath() + "' resolved from configuration read as '" + outputFileName + "'.");
            } else {
                MainExcel.warning("Going to overwrite file '" + outputFile.getAbsolutePath() + "' resolved from configuration read as '" + outputFileName + "'.");
            }
        }
        System.out.println("Sanity checks OK!");
    }

    private static void generate() {
        TDMMatchesExcelReport report = new TDMMatchesExcelReport(resultDirFile, outputFile);
        report.generate();
    }

    public static void main(String[] args) throws JSAPException {
        if (args == null || args.length == 0) {
            args = new String[]{"-r", "d:\\Workspaces\\MFF\\NAIL068-UmeleBytosti\\Lectures\\AB2018-Labs\\Lab-06-TDM\\Students\\_Results\\", "-o", "d:\\Workspaces\\MFF\\NAIL068-UmeleBytosti\\Lectures\\AB2018-Labs\\Lab-06-TDM\\Students\\_Results\\"};
        }
        MainExcel.initJSAP();
        MainExcel.header();
        MainExcel.readConfig(args);
        MainExcel.sanityChecks();
        try {
            MainExcel.generate();
        }
        catch (Exception e) {
            MainExcel.fail("Failed to generate results.", e);
        }
        System.out.println("DONE!");
    }
}

