/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report;

import cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report.DMMatchResult;
import cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report.DMTablePlayerResult;
import cz.cuni.amis.pogamut.ut2004.tournament.utils.CSV;
import cz.cuni.amis.utils.Const;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.maps.HashMapMap;
import cz.cuni.amis.utils.maps.LazyMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class DMTableResults {
    public Map<String, DMTablePlayerResult> players = new LazyMap<String, DMTablePlayerResult>(){

        protected DMTablePlayerResult create(String key) {
            return new DMTablePlayerResult(key);
        }
    };
    public HashMapMap<String, String, DMMatchResult> results = new HashMapMap();

    protected void info(String msg) {
        System.out.println("[INFO] " + msg);
    }

    protected void warn(String msg) {
        System.out.println("[WARN] " + msg);
    }

    protected void error(String msg) {
        System.out.println("[ERROR] " + msg);
    }

    public DMMatchResult getMatchResult(String plr1, String plr2) {
        if (plr1.compareToIgnoreCase(plr2) > 0) {
            String temp = plr2;
            plr2 = plr1;
            plr1 = temp;
        }
        return (DMMatchResult)this.results.get((Object)plr1, (Object)plr2);
    }

    public DMMatchResult addResult(String plr1, String plr2, int score1, int score2, boolean[] botLogicEx, String[] botEx) {
        if (plr1.compareToIgnoreCase(plr2) == 0) {
            throw new RuntimeException("Could not add result for " + plr1 + " vs. " + plr2 + " as their names are the same!");
        }
        if (plr1.compareToIgnoreCase(plr2) > 0) {
            String temp = plr2;
            plr2 = plr1;
            plr1 = temp;
            int tempI = score2;
            score2 = score1;
            score1 = tempI;
            boolean tempB = botLogicEx[1];
            botLogicEx[1] = botLogicEx[0];
            botLogicEx[0] = tempB;
            String tempS = botEx[1];
            botEx[1] = botEx[0];
            botEx[0] = tempS;
        }
        DMTablePlayerResult player1 = this.players.get(plr1);
        DMTablePlayerResult player2 = this.players.get(plr2);
        DMMatchResult result = new DMMatchResult(plr1, plr2, score1, score2, botLogicEx[0], botLogicEx[1], botEx[0], botEx[1]);
        DMMatchResult old = (DMMatchResult)this.results.put((Object)plr1, (Object)plr2, (Object)result);
        if (old != null) {
            throw new RuntimeException("There are more than one result for " + plr1 + " vs. " + plr2 + "! First result [" + old.score1 + ":" + old.score2 + "], second result [" + score1 + ":" + score2 + "].");
        }
        player1.result(result);
        player2.result(result);
        return result;
    }

    public List<DMTablePlayerResult> resolve() {
        int end;
        this.info("RESOLVING TABLE");
        List results = MyCollections.asList(this.players.values());
        Collections.sort(results, new Comparator<DMTablePlayerResult>(){

            @Override
            public int compare(DMTablePlayerResult o1, DMTablePlayerResult o2) {
                if (o1.wins == o2.wins) {
                    DMMatchResult result = DMTableResults.this.getMatchResult(o1.player, o2.player);
                    if (result == null) {
                        return 0;
                    }
                    return result.getScore(o2.player) - result.getScore(o1.player);
                }
                return o2.wins - o1.wins;
            }
        });
        int i = 0;
        while (i < results.size()) {
            int start = i;
            end = results.size() - 1;
            int j = i + 1;
            while (j < results.size()) {
                if (((DMTablePlayerResult)results.get((int)i)).wins != ((DMTablePlayerResult)results.get((int)j)).wins) {
                    end = j - 1;
                    break;
                }
                ++j;
            }
            i = end + 1;
            if (start == end) {
                ((DMTablePlayerResult)results.get((int)start)).position = start + 1;
                continue;
            }
            if (start + 1 == end) {
                DMTablePlayerResult result1 = (DMTablePlayerResult)results.get(start);
                DMTablePlayerResult result2 = (DMTablePlayerResult)results.get(start + 1);
                String player1 = ((DMTablePlayerResult)results.get((int)start)).player;
                String player2 = ((DMTablePlayerResult)results.get((int)(start + 1))).player;
                DMMatchResult match = this.getMatchResult(player1, player2);
                if (match != null) {
                    if (match.isWin(player1)) {
                        result1.position = start + 1;
                        result2.position = start + 2;
                        continue;
                    }
                    if (match.isWin(player2)) {
                        result1.position = start + 2;
                        result2.position = start + 1;
                        continue;
                    }
                }
                result1.position = end + 1;
                result2.position = end + 1;
            }
            j = start;
            while (j <= end) {
                ((DMTablePlayerResult)results.get((int)j)).position = end + 1;
                ++j;
            }
        }
        int start = 0;
        while (start < results.size()) {
            int position = ((DMTablePlayerResult)results.get((int)start)).position;
            end = start + 1;
            while (end < results.size() && position == ((DMTablePlayerResult)results.get((int)end)).position) {
                ++end;
            }
            if (start == --end) {
                ++start;
                continue;
            }
            boolean dominating = false;
            int candidate = start;
            while (candidate <= end) {
                boolean candidateDominating = true;
                DMTablePlayerResult result = (DMTablePlayerResult)results.get(candidate);
                String candidatePlr = result.player;
                int other = start;
                while (other <= end) {
                    String otherPlr;
                    DMMatchResult match;
                    if (candidate != other && !(match = this.getMatchResult(candidatePlr, otherPlr = ((DMTablePlayerResult)results.get((int)other)).player)).isWin(candidatePlr)) {
                        candidateDominating = false;
                        break;
                    }
                    ++other;
                }
                if (candidateDominating) {
                    if (candidate != start) {
                        DMTablePlayerResult candidateResult = (DMTablePlayerResult)results.get(candidate);
                        DMTablePlayerResult startResult = (DMTablePlayerResult)results.get(start);
                        results.set(start, candidateResult);
                        results.set(candidate, startResult);
                    }
                    ((DMTablePlayerResult)results.get((int)start)).position -= end - start;
                    dominating = true;
                    break;
                }
                ++candidate;
            }
            if (dominating) {
                ++start;
                continue;
            }
            start = end + 1;
        }
        return results;
    }

    public void probeResults(File dir) {
        this.probeResults(dir);
    }

    public void probeResults(File dir, boolean recursive) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists()) {
                if (file.isDirectory() && recursive) {
                    this.probeResults(file, recursive);
                }
                if (file.exists() && file.isFile()) {
                    try {
                        this.probeResultFile(file);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to process file: " + file.getAbsolutePath(), e);
                    }
                }
            }
            ++n2;
        }
    }

    private void probeResultFile(File file) throws FileNotFoundException, IOException {
        if (!(file.exists() && file.isFile() && file.getAbsolutePath().toLowerCase().endsWith("-result.csv"))) {
            return;
        }
        this.info("Found result file: " + file.getAbsolutePath());
        File botScoresFile = new File(file.getAbsolutePath().replace("-result.csv", "-bot-scores.csv"));
        if (!botScoresFile.exists()) {
            this.error("Cannot locate bot-scores file at: " + botScoresFile);
            return;
        }
        this.info("Found bot-scores file: " + botScoresFile.getAbsolutePath());
        File logFile = new File(file.getAbsolutePath().replace("-result.csv", ".log"));
        if (!logFile.exists()) {
            this.error("Cannot locate log file at: " + logFile);
            return;
        }
        this.info("Found log file: " + logFile.getAbsolutePath());
        CSV csv = new CSV(file, ";", true);
        if (csv.rows.size() != 1) {
            this.warn("-- Result file contains invalid number of data rows (" + csv.rows.size() + "), ignoring.");
            return;
        }
        if (!csv.keys.contains("Winner")) {
            this.warn("-- Result file does not contain column 'Winner'. Ignoring.");
            return;
        }
        String winner = csv.rows.get(0).getString("Winner");
        if (winner.toLowerCase().contains("failure")) {
            this.error("-- Result file is indicating that the match has FAILED!");
            return;
        }
        this.probeBotScoresAndLogFile(botScoresFile, logFile);
    }

    private void probeBotScoresAndLogFile(File botScoresFile, File logFile) throws FileNotFoundException, IOException {
        if (!(botScoresFile.exists() && botScoresFile.isFile() && botScoresFile.getAbsolutePath().toLowerCase().endsWith("-bot-scores.csv"))) {
            return;
        }
        CSV csv = new CSV(botScoresFile, ";", true);
        if (csv.rows.size() != 2) {
            this.warn("-- Bot-scores file contains invalid number of data rows (" + csv.rows.size() + "), ignoring.");
            return;
        }
        if (!csv.keys.contains("botId")) {
            this.warn("-- Bot-scores file does not contain column 'botId'. Ignoring.");
            return;
        }
        if (!csv.keys.contains("score")) {
            this.warn("-- Bot-scores file does not contain column 'score'. Ignoring.");
            return;
        }
        CSV.CSVRow row1 = csv.rows.get(0);
        String player1 = row1.getString("botId");
        int score1 = row1.getInt("score");
        CSV.CSVRow row2 = csv.rows.get(1);
        String player2 = row2.getString("botId");
        int score2 = row2.getInt("score");
        boolean[] botLogicEx = new boolean[2];
        String[] botEx = new String[]{"", ""};
        boolean[] fatalErrorEvent = new boolean[2];
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(logFile));
                while (reader.ready()) {
                    String line = reader.readLine();
                    String player = null;
                    int plrIndex = -1;
                    int otherIndex = -1;
                    if (line.contains(" " + player1 + "-StdOut ")) {
                        plrIndex = 0;
                        otherIndex = 1;
                        player = player1;
                    } else {
                        if (!line.contains(" " + player2 + "-StdOut ")) continue;
                        plrIndex = 1;
                        otherIndex = 0;
                        player = player2;
                    }
                    if (line.endsWith("Logic iteration exception.")) {
                        botLogicEx[plrIndex] = true;
                    }
                    if (line.endsWith(" FatalErrorEvent[")) {
                        fatalErrorEvent[plrIndex] = true;
                    }
                    if (!fatalErrorEvent[plrIndex]) continue;
                    int n = plrIndex;
                    botEx[n] = String.valueOf(botEx[n]) + Const.NEW_LINE + line;
                    if (!line.endsWith(" " + player + "-StdOut ]")) continue;
                    fatalErrorEvent[plrIndex] = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error("Failed to probe log file at: " + logFile.getAbsolutePath());
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        DMMatchResult result = this.addResult(player1, player2, score1, score2, botLogicEx, botEx);
        this.info("-- " + result.toString());
    }
}

