/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report;

public class DMMatchResult {
    public String player1;
    public String player2;
    public int score1;
    public int score2;
    public boolean player1Exception;
    public boolean player2Exception;
    public String player1ExceptionTrace;
    public String player2ExceptionTrace;

    public DMMatchResult(String player1, String player2, int score1, int score2, boolean bot1LogicEx, boolean bot2LogicEx, String bot1Ex, String bot2Ex) {
        this.player1 = player1;
        this.player2 = player2;
        this.score1 = score1;
        this.score2 = score2;
        this.player1Exception = bot1LogicEx;
        this.player2Exception = bot2LogicEx;
        this.player1ExceptionTrace = bot1Ex;
        this.player2ExceptionTrace = bot2Ex;
    }

    public boolean isException() {
        return this.player1Exception || this.player2Exception;
    }

    public boolean isException(String player) {
        if (this.player1.equals(player) && this.player1Exception) {
            return true;
        }
        return this.player2.equals(player) && this.player2Exception;
    }

    public boolean isWin(String player) {
        if (this.isException() && !this.isException(player)) {
            return true;
        }
        if (this.player1.equals(player) && this.score1 > this.score2) {
            return true;
        }
        return this.player2.equals(player) && this.score1 < this.score2;
    }

    public int getScore(String player) {
        if (this.player1.equals(player)) {
            return this.score1;
        }
        if (this.player2.equals(player)) {
            return this.score2;
        }
        return 0;
    }

    public String getException(String player) {
        if (this.player1.equals(player)) {
            return this.player1ExceptionTrace;
        }
        if (this.player2.equals(player)) {
            return this.player2ExceptionTrace;
        }
        return "";
    }

    public String toString() {
        return String.valueOf(this.player1) + "-vs-" + this.player2 + "[" + (this.player1Exception ? "E" : Integer.valueOf(this.score1)) + ":" + (this.player2Exception ? "E" : Integer.valueOf(this.score2)) + "]";
    }
}

