/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report;

import cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report.DMMatchResult;
import cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report.DMTablePlayerResult;
import cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report.DMTableResults;
import cz.cuni.amis.pogamut.ut2004.tournament.utils.ExcelReport;
import cz.cuni.amis.utils.FileAppender;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.biff.WritableWorkbookImpl;

public class DMExcelReport
extends ExcelReport {
    private File resultDir;
    private File outputFile;
    private DMTableResults table;
    private List<DMTablePlayerResult> players;

    public DMExcelReport(File resultDir, File outputFile) {
        this.resultDir = resultDir;
        this.outputFile = outputFile;
    }

    public synchronized void generate() {
        this.table = this.gatherResults(this.resultDir);
        this.players = this.table.resolve();
        this.produceExcel(this.outputFile);
    }

    private DMTableResults gatherResults(File resultDir) {
        this.info("GATHERING RESULTS");
        DMTableResults results = new DMTableResults();
        results.probeResults(resultDir, true);
        return results;
    }

    @Override
    protected void produceExcel(File outputFile, WritableWorkbookImpl workbook, WritableSheet sheet) throws Exception {
        this.info("OUTPUTING RESULTS");
        for (DMTablePlayerResult player : this.players) {
            this.info("-- " + player.position + ". " + player.player + " (W" + player.wins + ":D" + player.draws + ":L" + player.loses + ":E" + player.exceptions + ") (F" + player.frags + ":D" + player.deaths + ")");
        }
        ArrayList<DMTablePlayerResult> playersAlpha = new ArrayList<DMTablePlayerResult>(this.players);
        Collections.sort(playersAlpha, new Comparator<DMTablePlayerResult>(){

            @Override
            public int compare(DMTablePlayerResult o1, DMTablePlayerResult o2) {
                return o1.player.compareTo(o2.player);
            }
        });
        this.info("CREATING EXCEL FILE");
        sheet.addCell((WritableCell)this.newStringCell("A", 0, "DeathMatch Tournament"));
        sheet.addCell((WritableCell)this.newStringCell("A", 1, "Table"));
        sheet.addCell((WritableCell)this.newStringCell("A", 2, ""));
        sheet.addCell(this.center((WritableCell)this.newStringCell("A", 3, "No.")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("B", 3, "Participant")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("C", 3, "Frags")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("D", 3, ":")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("E", 3, "Deaths")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("F", 3, "#Wins")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("G", 3, "#Draws")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("H", 3, "#Loses")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("I", 3, "#Exceptions")));
        int col = 0;
        int row = 3;
        for (DMTablePlayerResult player : this.players) {
            sheet.addCell(this.center((WritableCell)this.newIntCell("A", ++row, player.position)));
            sheet.addCell((WritableCell)this.newStringCell("B", row, player.player));
            sheet.addCell(this.center((WritableCell)this.newIntCell("C", row, player.frags)));
            sheet.addCell(this.center((WritableCell)this.newStringCell("D", row, ":")));
            sheet.addCell(this.center((WritableCell)this.newIntCell("E", row, player.deaths)));
            sheet.addCell(this.center((WritableCell)this.newIntCell("F", row, player.wins)));
            sheet.addCell(this.center((WritableCell)this.newIntCell("G", row, player.draws)));
            sheet.addCell(this.center((WritableCell)this.newIntCell("H", row, player.loses)));
            sheet.addCell(this.center((WritableCell)this.newIntCell("I", row, player.exceptions)));
        }
        int startCol = 10;
        int startRow = 3;
        col = startCol + 1;
        row = startRow;
        sheet.addCell((WritableCell)this.newStringCell(col++, row, "TABLE"));
        for (DMTablePlayerResult player : playersAlpha) {
            sheet.addCell((WritableCell)this.newStringCell(col++, row, ""));
            sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, player.player))));
            sheet.addCell((WritableCell)this.newStringCell(col++, row, ""));
        }
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Frags"))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, ""))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Deaths"))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Wins"))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Draws"))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Loses"))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Exceptions"))));
        for (DMTablePlayerResult player1 : playersAlpha) {
            File exceptions = new File(String.valueOf(outputFile.getAbsolutePath()) + "." + player1.player + ".errors");
            col = startCol + 1;
            sheet.addCell((WritableCell)this.newStringCell(col++, ++row, player1.player));
            for (DMTablePlayerResult player2 : playersAlpha) {
                if (player1 == player2) {
                    sheet.addCell((WritableCell)this.newStringCell(col++, row, ""));
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, "X")));
                    sheet.addCell((WritableCell)this.newStringCell(col++, row, ""));
                    continue;
                }
                DMMatchResult match = this.table.getMatchResult(player1.player, player2.player);
                if (match == null) {
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, "x")));
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, ":")));
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, "x")));
                    continue;
                }
                if (match.isException(player1.player)) {
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, "E")));
                    FileAppender.appendToFile((File)exceptions, (String)match.getException(player1.player));
                } else {
                    sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, match.getScore(player1.player))));
                }
                sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, ":")));
                if (match.isException(player2.player)) {
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, "E")));
                    continue;
                }
                sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, match.getScore(player2.player))));
            }
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.frags)));
            sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, ":")));
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.deaths)));
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.wins)));
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.draws)));
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.loses)));
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.exceptions)));
        }
    }
}

