/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report;

import cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report.CSV;
import cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report.DMMatchResult;
import cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report.DMTablePlayerResult;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.maps.HashMapMap;
import cz.cuni.amis.utils.maps.LazyMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class DMTableResults {
    public Map<String, DMTablePlayerResult> players = new LazyMap<String, DMTablePlayerResult>(){

        protected DMTablePlayerResult create(String key) {
            return new DMTablePlayerResult(key);
        }
    };
    public HashMapMap<String, String, DMMatchResult> results = new HashMapMap();

    protected void info(String msg) {
        System.out.println("[INFO] " + msg);
    }

    protected void warn(String msg) {
        System.out.println("[WARN] " + msg);
    }

    protected void error(String msg) {
        System.out.println("[ERROR] " + msg);
    }

    public DMMatchResult getMatchResult(String plr1, String plr2) {
        if (plr1.compareToIgnoreCase(plr2) > 0) {
            String temp = plr2;
            plr2 = plr1;
            plr1 = temp;
        }
        return (DMMatchResult)this.results.get((Object)plr1, (Object)plr2);
    }

    public DMMatchResult addResult(String plr1, String plr2, int score1, int score2) {
        if (plr1.compareToIgnoreCase(plr2) == 0) {
            throw new RuntimeException("Could not add result for " + plr1 + " vs. " + plr2 + " as their names are the same!");
        }
        if (plr1.compareToIgnoreCase(plr2) > 0) {
            String temp = plr2;
            plr2 = plr1;
            plr1 = temp;
        }
        DMTablePlayerResult player1 = this.players.get(plr1);
        DMTablePlayerResult player2 = this.players.get(plr2);
        DMMatchResult result = new DMMatchResult(plr1, plr2, score1, score2);
        DMMatchResult old = (DMMatchResult)this.results.put((Object)plr1, (Object)plr2, (Object)result);
        if (old != null) {
            throw new RuntimeException("There are more than one result for " + plr1 + " vs. " + plr2 + "! First result [" + old.score1 + ":" + old.score2 + "], second result [" + score1 + ":" + score2 + "].");
        }
        player1.result(result);
        player2.result(result);
        return result;
    }

    public List<DMTablePlayerResult> resolve() {
        this.info("RESOLVING TABLE");
        List results = MyCollections.asList(this.players.values());
        Collections.sort(results, new Comparator<DMTablePlayerResult>(){

            @Override
            public int compare(DMTablePlayerResult o1, DMTablePlayerResult o2) {
                return o2.wins - o1.wins;
            }
        });
        int i = 0;
        while (i < results.size()) {
            int j;
            int start = i;
            int end = results.size() - 1;
            for (j = i + 1; j < results.size(); ++j) {
                if (((DMTablePlayerResult)results.get((int)i)).wins == ((DMTablePlayerResult)results.get((int)j)).wins) continue;
                end = j - 1;
                break;
            }
            i = end + 1;
            if (start == end) {
                ((DMTablePlayerResult)results.get((int)start)).position = start + 1;
                continue;
            }
            if (start + 1 == end) {
                DMTablePlayerResult result1 = (DMTablePlayerResult)results.get(start);
                DMTablePlayerResult result2 = (DMTablePlayerResult)results.get(start + 1);
                String player1 = ((DMTablePlayerResult)results.get((int)start)).player;
                String player2 = ((DMTablePlayerResult)results.get((int)(start + 1))).player;
                DMMatchResult match = this.getMatchResult(player1, player2);
                if (match != null) {
                    if (match.isWin(player1)) {
                        result1.position = start + 1;
                        result2.position = start + 2;
                        continue;
                    }
                    if (match.isWin(player2)) {
                        result1.position = start + 2;
                        result2.position = start + 1;
                        continue;
                    }
                }
                result1.position = end + 1;
                result2.position = end + 1;
            }
            for (j = start; j <= end; ++j) {
                ((DMTablePlayerResult)results.get((int)j)).position = end + 1;
            }
        }
        Collections.sort(results, new Comparator<DMTablePlayerResult>(){

            @Override
            public int compare(DMTablePlayerResult o1, DMTablePlayerResult o2) {
                return o1.position - o1.position;
            }
        });
        return results;
    }

    public void probeResults(File dir) {
        this.probeResults(dir);
    }

    public void probeResults(File dir, boolean recursive) {
        for (File file : dir.listFiles()) {
            if (!file.exists()) continue;
            if (file.isDirectory() && recursive) {
                this.probeResults(file, recursive);
            }
            if (!file.exists() || !file.isFile()) continue;
            try {
                this.probeFile(file);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to process file: " + file.getAbsolutePath(), e);
            }
        }
    }

    private void probeFile(File file) throws FileNotFoundException, IOException {
        if (!(file.exists() && file.isFile() && file.getAbsolutePath().toLowerCase().endsWith("-bot-scores.csv"))) {
            return;
        }
        this.info("Found results: " + file.getAbsolutePath());
        CSV csv = new CSV(file, ";", true);
        if (csv.rows.size() != 2) {
            this.warn("-- Result file contains invalid number of data rows (" + csv.rows.size() + "), ignoring.");
            return;
        }
        if (!csv.keys.contains("botId")) {
            this.warn("-- Result file does not contain column 'botId'. Ignoring.");
            return;
        }
        if (!csv.keys.contains("score")) {
            this.warn("-- Result file does not contain column 'score'. Ignoring.");
            return;
        }
        CSV.CSVRow row1 = csv.rows.get(0);
        String player1 = row1.getString("botId");
        int score1 = row1.getInt("score");
        CSV.CSVRow row2 = csv.rows.get(1);
        String player2 = row2.getString("botId");
        int score2 = row2.getInt("score");
        DMMatchResult result = this.addResult(player1, player2, score1, score2);
        this.info("-- " + result.toString());
    }
}

