/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.ut2004.ut2004testfw.utils;

import cz.cuni.amis.pogamut.ut2004.ut2004testfw.utils.CsvReader.CsvRow;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author tommasino
 */
public class CsvReader extends BufferedReader {

    /**
     *
     */
    private String[] names;
    /**
     *
     */
    private String delimeter;
    /**
     *
     */
    private ArrayList<CsvRow> rows;

    /**
     *
     * @param filename
     * @param delimeter
     * @throws FileNotFoundException
     * @throws IOException
     */
    public CsvReader(String filename, String delimeter) throws FileNotFoundException, IOException {
        super(new FileReader(filename));
        this.delimeter = delimeter;
        String line = readLine();
        if (line != null) {
            names = line.split(delimeter);
        }
        rows = new ArrayList<CsvRow>();
    }

    /**
     *
     * @return
     * @throws IOException
     */
    public final CsvRow readRow() throws IOException {
        String line = readLine();
        if (line == null) {
            return null;
        }
        HashMap<String, String> row = new HashMap<String, String>();
        String[] values = line.split(delimeter);
        for (int i = 0; i < names.length && i < values.length; i++) {
            row.put(names[i], values[i]);
        }
        CsvRow r = new CsvRow(row);
        rows.add(r);
        return r;
    }

    /**
     *
     */
    public class CsvRow {

        /**
         *
         */
        private Map<String, String> row;

        /**
         *
         * @param row
         */
        public CsvRow(Map<String, String> row) {
            this.row = row;
        }

        /**
         *
         * @param name
         * @return
         */
        public String getString(String name) {
            String val = row.get(name);
            if (val == null) {
                return "";
            }
            return val;
        }

        /**
         *
         * @param name
         * @return
         */
        public int getInt(String name) {
            try {
                int number = Integer.parseInt(getString(name));
                return number;
            } catch (NumberFormatException e) {
                return -1;
            }
        }

        /**
         *
         * @param name
         * @return
         */
        public double getDouble(String name) {
            try {
                double number = Double.parseDouble(getString(name));
                return number;
            } catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
    }
}
