/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.ut2004testfw;

import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004Match;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.PerformanceReport;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.config.BotTemplate;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.config.MatchConfig;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.measure.IMeasure;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.utils.CsvReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MatchesExecutor {
    private static final int BUFFER_SIZE = 1024;
    private ArrayList<MatchConfig> matchSets;
    private ArrayList<IMeasure> measures;
    private HashMap<String, BotTemplate> botMap;
    private String utPath;
    private String outputDirectory;
    private int testId;

    public MatchesExecutor(ArrayList<MatchConfig> matchSets, ArrayList<BotTemplate> bots, ArrayList<IMeasure> measures, String utPath, String outputDirectory) {
        this.matchSets = matchSets;
        this.measures = measures;
        this.outputDirectory = outputDirectory;
        this.utPath = utPath;
        this.testId = this.generateTestId();
        this.botMap = new HashMap();
        for (BotTemplate bot : bots) {
            if (this.botMap.containsKey(bot.getId())) {
                System.err.println("Duplicate bot id: " + bot.getId());
                continue;
            }
            this.botMap.put(bot.getId(), bot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeMatch(int run, UT2004Match match, MatchConfig config, String outputPath) {
        for (BotTemplate bot : this.botMap.values()) {
            Object out;
            if (!bot.observe()) continue;
            File[] candidates = match.getOutputPath("bots").listFiles();
            ArrayList reports = new ArrayList();
            for (File can : candidates) {
                if (!can.getName().matches(bot.getId() + "[0-9]*_[0-9]{3}\\.csv")) continue;
                String sid = can.getName();
                sid = sid.substring(sid.lastIndexOf("_") + 1, sid.indexOf(".csv"));
                int iid = Integer.parseInt(sid);
                while (reports.size() <= iid) {
                    reports.add(new ArrayList());
                }
                ((ArrayList)reports.get(iid)).add(can);
            }
            if (reports.isEmpty()) {
                return;
            }
            Collections.sort(reports, new Comparator<ArrayList<File>>(){

                @Override
                public int compare(ArrayList<File> t, ArrayList<File> t1) {
                    if (t == null) {
                        return 1;
                    }
                    if (t1 == null) {
                        return -1;
                    }
                    return (int)(t1.get(0).lastModified() - t.get(0).lastModified());
                }
            });
            ArrayList reportList = (ArrayList)reports.get(0);
            for (IMeasure measure : this.measures) {
                System.out.println(measure.getName());
                measure.init();
                try {
                    for (File report : reportList) {
                        CsvReader.CsvRow row;
                        Logger.getLogger(PerformanceReport.class.getName()).log(Level.INFO, "Reading report {0}", report.getName());
                        CsvReader reader = new CsvReader(report.getAbsolutePath(), ";");
                        while ((row = reader.readRow()) != null) {
                            measure.next(row);
                        }
                        measure.reportEnd();
                    }
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(PerformanceReport.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(PerformanceReport.class.getName()).log(Level.SEVERE, null, ex);
                }
                try {
                    out = new BufferedWriter(new FileWriter(outputPath, true));
                    ((Writer)out).write(this.testId + ";" + measure.getName() + ";" + config.getId() + ";" + run + ";" + measure.getMeasure() + "\n");
                    ((BufferedWriter)out).close();
                }
                catch (IOException ex) {
                    Logger.getLogger(PerformanceReport.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            File od = match.getOutputPath();
            File replay = null;
            for (File f : od.listFiles()) {
                if (!f.getName().endsWith(".demo4")) continue;
                replay = f;
                break;
            }
            if (replay == null) continue;
            System.out.println(replay.getAbsolutePath());
            out = new File(this.outputDirectory, config.getId() + "-" + run + "-replay.demo4");
            System.out.println(((File)out).getAbsolutePath());
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                fis = new FileInputStream(replay);
                fos = new FileOutputStream((File)out);
                byte[] buf = new byte[1024];
                int i = 0;
                while ((i = fis.read(buf)) != -1) {
                    fos.write(buf, 0, i);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    if (fos == null) continue;
                    fos.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public void executeMatches() {
        Logger.getLogger(MatchesExecutor.class.getName()).log(Level.INFO, "Starting matches");
        for (MatchConfig config : this.matchSets) {
            for (int i = 0; i < config.getRuns(); ++i) {
                File[] output;
                UT2004Match match = config.createMatch(this.utPath, this.botMap);
                match.getLog().setLevel(Level.SEVERE);
                match.getLog().addConsoleHandler();
                match.cleanUp();
                try {
                    match.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.analyzeMatch(i, match, config, this.outputDirectory + File.separator + "results");
                for (File res : output = match.getOutputPath("bots").listFiles()) {
                    res.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateTestId() {
        File idFile = new File(this.outputDirectory + File.separator + "id");
        int id = -1;
        if (!idFile.exists()) {
            id = 1;
        } else {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(idFile));
                id = Integer.parseInt(reader.readLine()) + 1;
            }
            catch (FileNotFoundException ex) {
                id = 1;
                Logger.getLogger(MatchesExecutor.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                id = 1;
                Logger.getLogger(MatchesExecutor.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(idFile, false));
            out.write(id + "\n");
        }
        catch (IOException ex) {
            Logger.getLogger(MatchesExecutor.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        File resultFile = new File(this.outputDirectory + File.separator + "results");
        if (!resultFile.exists()) {
            out = null;
            try {
                out = new BufferedWriter(new FileWriter(resultFile, false));
                out.write("testId;measureName;matchId;runId;measureResult\n");
            }
            catch (IOException ex) {
                Logger.getLogger(MatchesExecutor.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return id;
    }
}

