function getElementsByClassName(className){
    var hasClassName = new RegExp("(?:^|\\s)" + className + "(?:$|\\s)");
    var allElements = document.getElementsByTagName("*");
    var results = [];

    var element;
    for (var i = 0; (element = allElements[i]) != null; i++) {
        var elementClass = element.className;
        if (elementClass && elementClass.indexOf(className) != -1 && hasClassName.test(elementClass))
            results.push(element);
    }

    return results;
}

var timer;
var menuId=0;
var timerOn=0;

function display(id){
  if(timerOn)
    hideElement();
  clearTimeout(timer);
  var toDisplay = document.getElementById(id);
  toDisplay.style.visibility="visible";
  toDisplay.style.display="block";
}

function hide(id){ 
  if(timerOn)
    hideElement();
  menuId=id;
  timer = setTimeout("hideElement()",50);
  timerOn=1;
}

function interruptHide(){
  clearTimeout(timer);
  timerOn=0;
}

function hideElement(){
  var toHide = document.getElementById(menuId);
  toHide.style.visibility="hidden";
  toHide.style.display="none";
  timerOn=0;
}

function displayGroup(group){
  var all = getElementsByClassName("group");
  var i;
  for(i=0;i<all.length;i++){
    if(all[i].id==group){                             
      all[i].style.visibility="visible";
      all[i].style.display="block";
    }else{  
      all[i].style.visibility="hidden";
      all[i].style.display="none";
    }
  }
  var pickers = getElementsByClassName("picker");
  for(i=0;i<pickers.length;i++){
    if(pickers[i].id==group+"Picker"){                             
      pickers[i].className="picker selected";
    }else{                      
      pickers[i].className="picker";
    }
  }
  
  return false;
}
var tooltip=function(){
    var id = 'tt';
    var top = 3;
    var left = 3;
    var maxw = 300;
    var speed = 10;
    var timer = 20;
    var endalpha = 95;
    var alpha = 0;
    var tt,t,c,b,h;
    var ie = document.all ? true : false;
    return{
        show:function(v,w){
            if(tt == null){
                tt = document.createElement('div');
                tt.setAttribute('id',id);
                t = document.createElement('div');
                t.setAttribute('id',id + 'top');
                c = document.createElement('div');
                c.setAttribute('id',id + 'cont');
                b = document.createElement('div');
                b.setAttribute('id',id + 'bot');
                tt.appendChild(t);
                tt.appendChild(c);
                tt.appendChild(b);
                document.body.appendChild(tt);
                tt.style.opacity = 0;
                tt.style.filter = 'alpha(opacity=0)';
                document.onmousemove = this.pos;
            }
            tt.style.display = 'block';
            c.innerHTML = v;
            tt.style.width = w ? w + 'px' : 'auto';
            if(!w && ie){
                t.style.display = 'none';
                b.style.display = 'none';
                tt.style.width = tt.offsetWidth;
                t.style.display = 'block';
                b.style.display = 'block';
            }
            if(tt.offsetWidth > maxw){
                tt.style.width = maxw + 'px'
                }
            h = parseInt(tt.offsetHeight) + top;
            clearInterval(tt.timer);
            tt.timer = setInterval(function(){
                tooltip.fade(1)
                },timer);
        },
        pos:function(e){
            var u = ie ? event.clientY + document.documentElement.scrollTop : e.pageY;
            var l = ie ? event.clientX + document.documentElement.scrollLeft : e.pageX;
            tt.style.top = (u - h) + 'px';
            tt.style.left = (l + left) + 'px';
        },
        fade:function(d){
            var a = alpha;
            if((a != endalpha && d == 1) || (a != 0 && d == -1)){
                var i = speed;
                if(endalpha - a < speed && d == 1){
                    i = endalpha - a;
                }else if(alpha < speed && d == -1){
                    i = a;
                }
                alpha = a + (i * d);
                tt.style.opacity = alpha * .01;
                tt.style.filter = 'alpha(opacity=' + alpha + ')';
            }else{
                clearInterval(tt.timer);
                if(d == -1){
                    tt.style.display = 'none'
                    }
            }
        },
        hide:function(){
            clearInterval(tt.timer);
            tt.timer = setInterval(function(){
                tooltip.fade(-1)
                },timer);
        }
    };
}();