/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.ut2004testfw.utils;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CsvReader
extends BufferedReader {
    private String[] names;
    private String delimeter;

    public CsvReader(String filename, String delimeter) throws FileNotFoundException, IOException {
        super(new FileReader(filename));
        this.delimeter = delimeter;
        String line = this.readLine();
        if (line != null) {
            this.names = line.split(delimeter);
        }
    }

    public CsvRow readRow() throws IOException {
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        HashMap<String, String> row = new HashMap<String, String>();
        String[] values = line.split(this.delimeter);
        for (int i = 0; i < this.names.length && i < values.length; ++i) {
            row.put(this.names[i], values[i]);
        }
        return new CsvRow(row);
    }

    public class CsvRow {
        private Map<String, String> row;

        public CsvRow(Map<String, String> row) {
            this.row = row;
        }

        public String getString(String name) {
            String val = this.row.get(name);
            if (val == null) {
                return "";
            }
            return val;
        }

        public int getInt(String name) {
            try {
                int number = Integer.parseInt(this.getString(name));
                return number;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }

        public double getDouble(String name) {
            try {
                double number = Double.parseDouble(this.getString(name));
                return number;
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
    }
}

