/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.ut2004testfw;

import cz.cuni.amis.pogamut.ut2004.ut2004testfw.MatchConfig;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.MatchesExecutor;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.measure.IMeasure;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.utils.CsvReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;

public class PerformanceReport
extends AbstractMavenReport {
    private ArrayList<MatchConfig> matchSets;
    private ArrayList<IMeasure> measures;
    private String utPath;
    private String botPath;
    private String botName;
    private static final String[] grouping = new String[]{"matchId", "matchId;testId", "matchId;testId;runId"};
    private String outputDirectory;
    private MavenProject project;
    private Renderer siteRenderer;

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    private File generateGraph(String group, String key, ArrayList<Double> series) throws IOException {
        HistogramDataset dataset = new HistogramDataset();
        dataset.setType(HistogramType.RELATIVE_FREQUENCY);
        double[] serie = new double[series.size()];
        for (int i = 0; i < serie.length; ++i) {
            serie[i] = series.get(i);
        }
        dataset.addSeries((Comparable)((Object)"test"), serie, serie.length > 20 ? 20 : serie.length);
        String measure = key.substring(0, key.indexOf(45));
        String name = key.substring(key.indexOf(45) + 1);
        JFreeChart chart = ChartFactory.createHistogram((String)name, (String)measure, (String)"occurence", (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        File saveDir = new File(this.getOutputDirectory() + File.separator + "matches" + File.separator + "graphs" + File.separator + group + File.separator);
        saveDir.mkdirs();
        File saveFile = new File(saveDir, key + ".png");
        ChartUtilities.saveChartAsPNG((File)saveFile, (JFreeChart)chart, (int)600, (int)400);
        return saveFile;
    }

    private ArrayList<File> generateGraphs(String group) throws FileNotFoundException, IOException {
        File[] graphs;
        File dir = new File(this.getOutputDirectory() + File.separator + "matches" + File.separator + "graphs");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (File graph : graphs = dir.listFiles()) {
            graph.delete();
        }
        String[] groups = group.split(";");
        CsvReader reader = new CsvReader(this.getOutputDirectory() + File.separator + "matches" + File.separator + "results", ";");
        CsvReader.CsvRow row = null;
        HashMap dataMap = new HashMap();
        StringBuilder builder = new StringBuilder();
        while ((row = reader.readRow()) != null) {
            builder.append(row.getString("measureName"));
            for (String g : groups) {
                builder.append("-").append(row.getString(g));
            }
            String key = builder.toString();
            builder.delete(0, builder.length());
            if (!dataMap.containsKey(key)) {
                dataMap.put(key, new ArrayList());
            }
            ((ArrayList)dataMap.get(key)).add(row.getDouble("measureResult"));
        }
        ArrayList<File> g = new ArrayList<File>();
        for (String key : dataMap.keySet()) {
            File graph = this.generateGraph(group, key, (ArrayList)dataMap.get(key));
            g.add(graph);
        }
        return g;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        File outputDir = new File(this.getOutputDirectory() + File.separator + "matches" + File.separator);
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        MatchesExecutor executor = new MatchesExecutor(this.matchSets, this.measures, this.utPath, this.botPath, this.botName, this.getOutputDirectory() + File.separator + "matches");
        executor.executeMatches();
        try {
            this.writeReport();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(PerformanceReport.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PerformanceReport.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void copyResourceTo(String resource, File dir) throws FileNotFoundException, IOException {
        PerformanceReport.class.getResourceAsStream(resource);
        InputStream fis = PerformanceReport.class.getResourceAsStream(resource);
        FileOutputStream fos = new FileOutputStream(new File(dir, resource));
        try {
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    private void writeReport() throws FileNotFoundException, IOException {
        Sink sink = this.getSink();
        sink.head();
        sink.title();
        sink.text("Bot Performance");
        sink.title_();
        sink.head_();
        sink.body();
        File res = new File(this.getOutputDirectory() + File.separator + "matches" + File.separator + "res" + File.separator);
        if (!res.exists()) {
            if (!res.mkdirs()) {
                throw new IOException("The resource folder '" + res.getAbsolutePath() + "' could not be created");
            }
            this.copyResourceTo("/results.css", res);
            this.copyResourceTo("/display.js", res);
        }
        sink.rawText("<link rel=\"stylesheet\" href=\"./matches/res/results.css\" type=\"text/css\" />");
        sink.rawText("<script type=\"text/javascript\" src=\"./matches/res/display.js\"></script>");
        sink.section1();
        sink.sectionTitle1();
        sink.text("Bot Performance");
        sink.sectionTitle1_();
        sink.rawText("<span id=\"pickerBox\">");
        sink.rawText("<a class=\"picker\" href=\"javascript:;\" onclick=\"displayGroup('matchId')\">Grouped by match</a>");
        sink.rawText("<a class=\"picker\" href=\"javascript:;\" onclick=\"displayGroup('matchId;testId')\">Grouped by match and test id</a>");
        sink.rawText("<a class=\"picker\" href=\"javascript:;\" onclick=\"displayGroup('matchId;testId;runId')\">Grouped by match, test id and run id</a>");
        sink.rawText("</span>");
        sink.rawText("<div id=\"graphBox\">");
        boolean visible = true;
        for (String group : grouping) {
            ArrayList<File> charts = this.generateGraphs(group);
            this.generateTable(group, charts, sink, visible);
            visible = false;
        }
        sink.rawText("</div>");
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void generateTable(String group, ArrayList<File> charts, Sink sink, boolean visible) {
        sink.rawText("<div class=\"group\" id=\"" + group + "\" style=\"visibility:" + (visible ? "visible" : "hidden;display:none") + ";\">");
        ArrayList<String> measures = new ArrayList<String>();
        HashMap table = new HashMap();
        for (File chart : charts) {
            String name = chart.getName();
            String key = name.substring(name.indexOf(45) + 1);
            String measure = name.substring(0, name.indexOf(45));
            if (!measures.contains(measure)) {
                measures.add(measure);
            }
            if (!table.containsKey(key)) {
                table.put(key, new ArrayList());
            }
            ((ArrayList)table.get(key)).add(chart);
        }
        sink.rawText("<table><tr>");
        Collections.sort(measures);
        for (String measure : measures) {
            sink.rawText("<th>");
            sink.rawText(measure);
            sink.rawText("</th>");
        }
        sink.rawText("</tr>");
        ArrayList keySet = new ArrayList(table.keySet());
        Collections.sort(keySet);
        Collections.reverse(keySet);
        for (String key : keySet) {
            sink.rawText("<tr>");
            ArrayList c = (ArrayList)table.get(key);
            Collections.sort(c);
            for (File f : c) {
                sink.rawText("<td>");
                sink.rawText("<img src=\"matches" + File.separator + "graphs" + File.separator + group + File.separator + f.getName() + "\" />");
                sink.rawText("</td>");
            }
            sink.rawText("</tr>");
        }
        sink.rawText("</table></div>");
    }

    public String getOutputName() {
        return "performance-report";
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.performance-report.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.performance-report.description");
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("performance-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

