/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.ut2004.ut2004testfw.utils;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author tommasino
 */
public class CsvReader extends BufferedReader{

    private String[] names;
    private String delimeter;

    public CsvReader(String filename, String delimeter) throws FileNotFoundException, IOException{
        super(new FileReader(filename));
        this.delimeter = delimeter;
        String line = readLine();
        if(line != null)
            names = line.split(delimeter);
    }

    public CsvRow readRow() throws IOException{
        String line = readLine();
        if(line == null)
            return null;
        HashMap<String,String> row = new HashMap<String,String>();
        String[] values = line.split(delimeter);
        for(int i=0; i<names.length && i<values.length; i++)
            row.put(names[i], values[i]);
        return new CsvRow(row);
    }

    public class CsvRow{
        private Map<String,String> row;

        public CsvRow(Map<String,String> row){
            this.row = row;
        }

        public String getString(String name){
            String val = row.get(name);
            if(val == null)
                return "";
            return val;
        }

        public int getInt(String name){
            try{
                int number = Integer.parseInt(getString(name));
                return number;
            }catch(NumberFormatException e){
                return -1;
            }
        }

        public double getDouble(String name){
            try{
                double number = Double.parseDouble(getString(name));
                return number;
            }catch(NumberFormatException e){
                return Double.NaN;
            }
        }
    }
}
