/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.teamcomm.server;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnection;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.custom.ICustomControlMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendControlMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StartPlayers;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerJoinsGame;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerLeft;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerMessage;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.TCMinaServer;
import cz.cuni.amis.pogamut.ut2004.teamcomm.server.BotTCRecord;
import cz.cuni.amis.pogamut.ut2004.teamcomm.server.UT2004TCServerModule;
import cz.cuni.amis.pogamut.ut2004.teamcomm.server.UT2004TCServerParams;
import cz.cuni.amis.pogamut.ut2004.teamcomm.server.protocol.TCControlMessages;
import cz.cuni.amis.pogamut.ut2004.teamcomm.server.protocol.messages.TCControlServerAlive;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;
import cz.cuni.amis.utils.maps.LazyMap;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004TCServer
extends UT2004Server
implements IUT2004Server {
    public static final UnrealId SERVER_UNREAL_ID = UnrealId.get((String)"TC_CONTROL_SERVER");
    private static final double ALIVE_MESSAGE_INTERVAL_SECS = 30.0;
    private IWorldEventListener<BeginMessage> myBeginMessageListener = new IWorldEventListener<BeginMessage>(){

        public void notify(BeginMessage event) {
            UT2004TCServer.this.timeUpdate(event);
        }
    };
    private IWorldEventListener<EndMessage> myEndMessageListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            UT2004TCServer.this.batchEnd(event);
        }
    };
    private IWorldEventListener<PlayerJoinsGame> myPlayerJoinsGameMessageListener = new IWorldEventListener<PlayerJoinsGame>(){

        public void notify(PlayerJoinsGame event) {
            UT2004TCServer.this.playerJoinsGame(event);
        }
    };
    private IWorldEventListener<PlayerLeft> myPlayerLeftMessageListener = new IWorldEventListener<PlayerLeft>(){

        public void notify(PlayerLeft event) {
            UT2004TCServer.this.playerLeft(event);
        }
    };
    private IWorldObjectEventListener<PlayerMessage, WorldObjectUpdatedEvent<PlayerMessage>> myPlayerListener = new IWorldObjectEventListener<PlayerMessage, WorldObjectUpdatedEvent<PlayerMessage>>(){

        public void notify(WorldObjectUpdatedEvent<PlayerMessage> event) {
            UT2004TCServer.this.playerUpdate((IWorldObjectEvent<PlayerMessage>)event);
        }
    };
    private Object mutex = new Object();
    private TCControlMessages messages = new TCControlMessages();
    private TCMinaServer minaServer;
    private long utSimTime = -1L;
    private double utTimeLast = -1.0;
    private double utTimeCurrent = -1.0;
    private double utTimeDelta = -1.0;
    private Map<UnrealId, BotTCRecord<PlayerMessage>> records = new LazyMap<UnrealId, BotTCRecord<PlayerMessage>>(){

        protected BotTCRecord<PlayerMessage> create(UnrealId key) {
            return new BotTCRecord<PlayerMessage>(key);
        }
    };
    private Set<UnrealId> leftPlayers = new HashSet<UnrealId>();
    private double lastAlive = -1.0;

    @Inject
    public UT2004TCServer(UT2004AgentParameters params, IAgentLogger agentLogger, IComponentBus bus, SocketConnection connection, UT2004WorldView worldView, IAct act) {
        super(params, agentLogger, bus, connection, worldView, act);
        this.minaServer = new TCMinaServer(this, new InetSocketAddress(this.getParams().getBindHost(), this.getParams().getBindPort()), (Logger)this.getLogger().getCategory("TCMinaServer"));
        ((UT2004WorldView)this.getWorldView()).addEventListener(BeginMessage.class, this.myBeginMessageListener);
        ((UT2004WorldView)this.getWorldView()).addEventListener(EndMessage.class, this.myEndMessageListener);
        ((UT2004WorldView)this.getWorldView()).addEventListener(PlayerJoinsGame.class, this.myPlayerJoinsGameMessageListener);
        ((UT2004WorldView)this.getWorldView()).addEventListener(PlayerLeft.class, this.myPlayerLeftMessageListener);
        ((UT2004WorldView)this.getWorldView()).addObjectListener(PlayerMessage.class, WorldObjectUpdatedEvent.class, this.myPlayerListener);
    }

    public UT2004TCServerParams getParams() {
        UT2004AgentParameters params = super.getParams();
        if (!(params instanceof UT2004TCServerParams)) {
            throw new RuntimeException("Invalid parameters passed, expecting UT2004TCServerParams, got " + params);
        }
        return (UT2004TCServerParams)params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        super.init();
        this.log.setLevel(Level.INFO);
        Object object = this.mutex;
        synchronized (object) {
            this.getAct().act((CommandMessage)new StartPlayers(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopAgent() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.minaServer != null) {
                this.minaServer.stop();
                this.minaServer = null;
            }
        }
        super.stopAgent();
    }

    public long getSimTime() {
        return this.utSimTime;
    }

    public PlayerMessage getPlayer(UnrealId source) {
        if (!this.records.containsKey(source)) {
            return null;
        }
        BotTCRecord<PlayerMessage> record = this.records.get(source);
        if (record == null) {
            return null;
        }
        return record.getPlayer();
    }

    private void deleteRecord(UnrealId id) {
        BotTCRecord<PlayerMessage> record = this.records.remove(id);
        if (record != null) {
            this.minaServer.botLeft(id);
        }
        this.leftPlayers.add(id);
    }

    private void ensureRecord(PlayerMessage object) {
        this.records.put(object.getId(), new BotTCRecord<PlayerMessage>(object.getId(), object));
    }

    protected void playerUpdate(IWorldObjectEvent<PlayerMessage> event) {
        if (!this.records.containsKey(event.getId())) {
            if (this.leftPlayers.contains(event.getId())) {
                this.leftPlayers.remove(event.getId());
                return;
            }
            this.log.info(((PlayerMessage)event.getObject()).getId().getStringId() + ": First PlayerMessage received.");
            this.sendAlive();
        }
        this.ensureRecord((PlayerMessage)event.getObject());
    }

    protected void playerLeft(PlayerLeft event) {
        this.log.info(event.getId().getStringId() + ": Player has LEFT the game.");
        this.deleteRecord(event.getId());
        this.minaServer.botLeft(event.getId());
    }

    protected void playerJoinsGame(PlayerJoinsGame event) {
        this.log.info(event.getId().getStringId() + ": Player has JOINED the game.");
    }

    protected void batchEnd(EndMessage event) {
    }

    protected void timeUpdate(BeginMessage event) {
        this.utSimTime = event.getSimTime();
        this.utTimeLast = this.utTimeCurrent;
        this.utTimeCurrent = event.getTime();
        this.utTimeDelta = this.utTimeCurrent - this.utTimeLast;
        if (this.utSimTime > 0L && this.utTimeCurrent > 0.0 && (this.lastAlive < 0.0 || this.utTimeCurrent - this.lastAlive > 30.0)) {
            if (!((Boolean)this.minaServer.getRunning().getFlag()).booleanValue()) {
                this.log.info("Starting MINA SERVER!");
                this.minaServer.start();
            }
            this.sendAlive();
        }
    }

    private void sendAlive() {
        this.log.fine("Sending ALIVE message");
        this.lastAlive = this.utTimeCurrent;
        TCControlServerAlive message = new TCControlServerAlive();
        message.setHost(this.getParams().getBindHost());
        message.setPort(this.getParams().getBindPort());
        SendControlMessage command = this.messages.write((ICustomControlMessage)message);
        command.setSendAll(Boolean.valueOf(true));
        this.getAct().act((CommandMessage)command);
    }

    public static UT2004TCServer startTCServer() {
        return UT2004TCServer.startTCServer("localhost", 3010);
    }

    public static UT2004TCServer startTCServer(String bindHost, int bindPort) {
        UT2004TCServerModule module = new UT2004TCServerModule();
        UT2004ServerFactory factory = new UT2004ServerFactory((UT2004ServerModule)module);
        UT2004ServerRunner serverRunner = new UT2004ServerRunner((IAgentFactory)factory);
        UT2004TCServerParams params = new UT2004TCServerParams();
        params.setBindHost("localhost");
        params.setBindPort(3010);
        return (UT2004TCServer)((Object)serverRunner.setLogLevel(Level.INFO).setMain(false).startAgents((IAgentParameters[])new UT2004TCServerParams[]{params}).get(0));
    }

    public static void main(String[] args) {
        UT2004TCServer.startTCServer();
    }
}

