/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.ut2004;

import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.PoshEngine;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.engine.timer.SystemClockTimer;
import cz.cuni.amis.pogamut.sposh.executor.ILogicWorkExecutor;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotLogicController;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;

@AgentScoped
public abstract class SposhLogicController<BOT extends UT2004Bot>
extends UT2004BotLogicController<BOT> {
    public static final String SPOSH_LOG_CATEGORY = "SPOSH";
    private PoshEngine engine;
    private ILogicWorkExecutor workExecutor;
    private ITimer timer;

    public void initializeController(BOT bot) {
        PoshPlan plan;
        super.initializeController(bot);
        try {
            plan = this.parsePlan(this.getPlan());
        }
        catch (Exception ex) {
            Logger.getLogger(SposhLogicController.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        this.engine = this.createEngine(plan);
    }

    protected abstract ILogicWorkExecutor createWorkExecutor();

    protected final ILogicWorkExecutor getWorkExecutor() {
        if (this.workExecutor == null) {
            this.workExecutor = this.createWorkExecutor();
        }
        return this.workExecutor;
    }

    public final void logic() {
        this.getWorkExecutor().logicBeforePlan();
        PoshEngine.EvaluationResultInfo result = null;
        if (this.getEngine().getLog() != null) {
            this.getEngine().getLog().info("Invoking SPOSH engine.");
        }
        while (true) {
            result = this.getEngine().evaluatePlan((IWorkExecutor)this.getWorkExecutor());
            if (result.type == null || result.type != FireResult.Type.CONTINUE) break;
            if (this.getEngine().getLog() == null) continue;
            this.getEngine().getLog().info("Plan evaluation continues...");
        }
        if (this.getEngine().getLog() != null) {
            this.getEngine().getLog().info("Plan evaluation end.");
        }
        this.getWorkExecutor().logicAfterPlan();
    }

    protected ITimer createTimer() {
        return new SystemClockTimer();
    }

    protected final ITimer getTimer() {
        if (this.timer == null) {
            this.timer = this.createTimer();
        }
        return this.timer;
    }

    private PoshPlan parsePlan(String planSource) throws ParseException {
        StringReader planReader = new StringReader(planSource);
        PoshParser parser = new PoshParser((Reader)planReader);
        return parser.parsePlan();
    }

    private PoshEngine createEngine(PoshPlan plan) {
        return new PoshEngine(plan, this.getTimer(), (Logger)this.bot.getLogger().getCategory(SPOSH_LOG_CATEGORY));
    }

    protected final PoshEngine getEngine() {
        return this.engine;
    }

    protected abstract String getPlan() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getPlanFromStream(InputStream in) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuilder plan = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                plan.append(line);
            }
        }
        finally {
            br.close();
        }
        return plan.toString();
    }

    protected final String getPlanFromFile(String filename) throws IOException {
        FileInputStream f = new FileInputStream(filename);
        return this.getPlanFromStream(f);
    }

    protected final String getPlanFromResource(String resourcePath) throws IOException {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        return this.getPlanFromStream(cl.getResourceAsStream(resourcePath));
    }
}

