package cz.cuni.amis.pogamut.sposh.context;

import java.util.Random;
import java.util.logging.Level;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectListener;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.sposh.JavaBehaviour;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004BotController;


//
// 3rd change
//
/**
 * For old version of POSH - obsolete, not used. Now Context is used in
 * combination with senses and actions.
 *
 * @author vejmanm
 * @param <BOT>
 */
public class USAR2004Behaviour<BOT extends USAR2004Bot> extends JavaBehaviour<BOT>
{
    /**
     * Random number generator that is usually useful to have during decision
     * making.
     */
    protected Random random = new Random(System.currentTimeMillis());
    /**
     * User log - it's log-level is initially set to {@link Level#ALL}.
     *
     * @deprecated use {@link UT2004BotController#log} instead
     */
    protected LogCategory user = null;
    /**
     * Alias for user's log.
     */
    protected LogCategory log = null;

    /**
     * Listener registrator that probes declared methods for the presence of {@link EventListener}, {@link ObjectClassEventListener},
     * {@link ObjectClassListener}, {@link ObjectEventListener} and {@link ObjectListener}
     * annotations and automatically registers them as listeners on a specific
     * events. <p><p> Note that this registrator is usable for 'this' object
     * only! It will work only for 'this' object.
     */
    protected AnnotationListenerRegistrator listenerRegistrator;
    /**
     * Shortcut for the {@link UT2004BotModuleController#getWorldView()}.
     */
    protected IWorldView world;
    /**
     * Shortcut for the {@link UT2004BotModuleController#getAct()}.
     */
    protected IAct act;

    public USAR2004Behaviour(String name, BOT bot)
    {
        super(name, bot);
        log = bot.getLogger().getCategory(USAR2004BotController.USER_LOG_CATEGORY_ID);
        log.setLevel(Level.ALL);
        user = log;
    }

    /**
     * Called after the construction of the {@link UT2004Behaviour} before the
     * GameBots2004 greets the bot even before
     * {@link UT2004Behaviour#prepareBehaviour(UT2004Bot)} method. <p><p>
     * <b>NOTE:</b> This is Pogamut's developers reserved method - do not
     * override it and if you do, always use 'super' to call parent's
     * initializeBehaviour.
     */
    protected void initializeBehaviour(BOT bot)
    {
        initializeModules(bot);

        initializeListeners(bot);
    }

    /**
     * Initializes {@link UT2004Behaviour#listenerRegistrator} and calls {@link AnnotationListenerRegistrator#addListeners()}
     * method to probe all declared methods for event-annotation presence.
     *
     * @param bot
     */
    protected void initializeListeners(BOT bot)
    {
        listenerRegistrator = new AnnotationListenerRegistrator(this, getWorldView(), bot.getLogger().getCategory("Listeners"));
        listenerRegistrator.addListeners();
    }


    /**
     * Initializes memory/command modules of the bot.
     *
     * @param bot
     */
    protected void initializeModules(BOT bot)
    {
        world = getWorldView();
        act = getAct();
    }

    /**
     * Called after the behaviour construction to initialize user's data
     * structures.
     *
     * @param bot
     */
    protected void prepareBehaviour(BOT bot)
    {
    }


    public IWorldView getWorldView()
    {
        return bot.getWorldView();
    }

    public IAct getAct()
    {
        return bot.getAct();
    }

}
