/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.utils;

import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.UT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.UCCGameType;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapperConf;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;
import java.io.File;
import java.util.logging.Level;

public class GameBots2004 {
    private UCCWrapper uccWrapper;
    private UT2004ServerProvider serverProvider;
    private UT2004Server server;
    private Thread thread;
    private IGameBots2004Task task;
    private LogCategory log;

    public GameBots2004(IGameBots2004Task task) {
        this.task = task;
        this.log = new LogCategory("GameBots2004");
    }

    public synchronized void start(File ut2004Home, UCCGameType gameType, String mapName) {
        if (this.uccWrapper != null) {
            throw new RuntimeException("Cannot be start() as it is already running.");
        }
        UCCWrapperConf conf = new UCCWrapperConf();
        conf.setUnrealHome(ut2004Home.getAbsolutePath()).setGameType(gameType).setMapName(mapName);
        this.start(conf);
    }

    public synchronized void start(UCCWrapperConf conf) {
        this.log.warning("STARTING!");
        this.log.warning("Starting UCC Wrapper...");
        this.uccWrapper = new UCCWrapper(conf);
        UT2004AgentParameters params = new UT2004AgentParameters();
        params.setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress(this.uccWrapper.getHost(), this.uccWrapper.getControlPort()));
        UT2004ServerModule module = new UT2004ServerModule();
        UT2004ServerFactory factory = new UT2004ServerFactory(module);
        UT2004ServerRunner runner = new UT2004ServerRunner(factory);
        runner.setLogLevel(Level.SEVERE);
        this.log.warning("Starting UT2004Server...");
        this.server = (UT2004Server)runner.startAgents(new UT2004AgentParameters[]{params}).get(0);
        this.log.warning("Starting the thread...");
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                GameBots2004.this.task.start(GameBots2004.this.uccWrapper, GameBots2004.this.server);
            }
        }, "GameBots2004-Thread");
        this.thread.start();
        this.log.warning("Started.");
    }

    public synchronized void stop() {
        if (this.uccWrapper == null) {
            return;
        }
        this.log.warning("STOPPING!");
        this.log.warning("Ending the task...");
        try {
            this.task.end();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.log.warning("Interrupting the thread...");
        try {
            this.thread.interrupt();
            this.thread.join(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.thread = null;
        this.log.warning("Killing the UT2004Server...");
        try {
            this.server.kill();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = null;
        this.log.warning("Stopping the UCC Wrapper...");
        try {
            this.uccWrapper.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.uccWrapper = null;
        this.log.warning("Stopped.");
    }

    public static interface IGameBots2004Task {
        public void start(UCCWrapper var1, UT2004Server var2);

        public void end();
    }
}

