/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ICompositeWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ILocalWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.IStaticWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.LocationProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.PropertyId;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.RotationProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.VelocityProperty;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Entity;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EntityLocal;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EntityLocalImpl;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EntityShared;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EntitySharedImpl;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EntityStatic;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EntityStaticImpl;
import cz.cuni.amis.utils.AdvancedEquals;
import cz.cuni.amis.utils.SafeEquals;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.HashMap;
import java.util.Map;

public class EntityMessage
extends Entity
implements IWorldObjectUpdatedEvent,
ICompositeWorldObjectUpdatedEvent {
    protected ITeamId TeamId;
    protected UnrealId Id = null;
    protected boolean Id_Set = false;
    protected boolean Visible = false;
    protected boolean Visible_Set = false;
    protected Location Location = null;
    protected boolean Location_Set = false;
    protected Rotation Rotation = null;
    protected boolean Rotation_Set = false;
    protected Velocity Velocity = null;
    protected boolean Velocity_Set = false;
    protected String Type = null;
    protected boolean Type_Set = false;
    protected String EntityClass = null;
    protected boolean EntityClass_Set = false;
    private EntityLocal localPart = null;
    private EntityShared sharedPart = null;
    private EntityStatic staticPart = null;

    public EntityMessage() {
    }

    public EntityMessage(UnrealId Id, boolean Visible, Location Location2, Rotation Rotation2, Velocity Velocity2, String Type2, String EntityClass) {
        this.Id = Id;
        this.Visible = Visible;
        this.Location = Location2;
        this.Rotation = Rotation2;
        this.Velocity = Velocity2;
        this.Type = Type2;
        this.EntityClass = EntityClass;
    }

    public EntityMessage(EntityMessage original) {
        this.Id = original.getId();
        this.Visible = original.isVisible();
        this.Location = original.getLocation();
        this.Rotation = original.getRotation();
        this.Velocity = original.getVelocity();
        this.Type = original.getType();
        this.EntityClass = original.getEntityClass();
        this.TeamId = original.getTeamId();
        this.SimTime = original.getSimTime();
    }

    protected void setTeamId(ITeamId TeamId) {
        this.TeamId = TeamId;
    }

    public ITeamId getTeamId() {
        return this.TeamId;
    }

    @Override
    public UnrealId getId() {
        return this.Id;
    }

    @Override
    public boolean isVisible() {
        return this.Visible;
    }

    @Override
    public Location getLocation() {
        return this.Location;
    }

    @Override
    public Rotation getRotation() {
        return this.Rotation;
    }

    @Override
    public Velocity getVelocity() {
        return this.Velocity;
    }

    @Override
    public String getType() {
        return this.Type;
    }

    @Override
    public String getEntityClass() {
        return this.EntityClass;
    }

    public EntityLocal getLocal() {
        if (this.localPart != null) {
            return this.localPart;
        }
        this.localPart = new EntityLocalMessage();
        return this.localPart;
    }

    public EntityShared getShared() {
        if (this.sharedPart != null) {
            return this.sharedPart;
        }
        this.sharedPart = new EntitySharedMessage();
        return this.sharedPart;
    }

    public EntityStatic getStatic() {
        if (this.staticPart != null) {
            return this.staticPart;
        }
        this.staticPart = new EntityStaticMessage();
        return this.staticPart;
    }

    public IWorldObjectUpdateResult<IWorldObject> update(IWorldObject object) {
        if (object == null) {
            return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.CREATED, (IWorldObject)this);
        }
        if (!(object instanceof EntityMessage)) {
            throw new PogamutException("Can't update different class than EntityMessage, got class " + object.getClass().getSimpleName() + "!", (Object)this);
        }
        EntityMessage toUpdate = (EntityMessage)object;
        boolean updated = false;
        if (toUpdate.Visible != this.isVisible()) {
            toUpdate.Visible = this.isVisible();
            updated = true;
        }
        if (this.getLocation() != null && !SafeEquals.equals((Object)toUpdate.Location, (Object)this.getLocation())) {
            toUpdate.Location = this.getLocation();
            updated = true;
        }
        if (this.getRotation() != null && !SafeEquals.equals((Object)toUpdate.Rotation, (Object)this.getRotation())) {
            toUpdate.Rotation = this.getRotation();
            updated = true;
        }
        if (this.getVelocity() != null && !SafeEquals.equals((Object)toUpdate.Velocity, (Object)this.getVelocity())) {
            toUpdate.Velocity = this.getVelocity();
            updated = true;
        }
        toUpdate.SimTime = this.SimTime;
        if (updated) {
            return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.UPDATED, (IWorldObject)toUpdate);
        }
        return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.SAME, (IWorldObject)toUpdate);
    }

    public ILocalWorldObjectUpdatedEvent getLocalEvent() {
        return new EntityLocalImpl.EntityLocalUpdate(this.getLocal(), this.SimTime);
    }

    public ISharedWorldObjectUpdatedEvent getSharedEvent() {
        return new EntitySharedImpl.EntitySharedUpdate(this.getShared(), this.SimTime, this.getTeamId());
    }

    public IStaticWorldObjectUpdatedEvent getStaticEvent() {
        return new EntityStaticImpl.EntityStaticUpdate(this.getStatic(), this.SimTime);
    }

    @Override
    public String toString() {
        return super.toString() + "[Id = " + String.valueOf(this.getId()) + " | Visible = " + String.valueOf(this.isVisible()) + " | Location = " + String.valueOf(this.getLocation()) + " | Rotation = " + String.valueOf(this.getRotation()) + " | Velocity = " + String.valueOf(this.getVelocity()) + " | Type = " + String.valueOf(this.getType()) + " | EntityClass = " + String.valueOf(this.getEntityClass()) + " | ]";
    }

    @Override
    public String toHtmlString() {
        return super.toString() + "[<br/><b>Id</b> = " + String.valueOf(this.getId()) + " <br/> <b>Visible</b> = " + String.valueOf(this.isVisible()) + " <br/> <b>Location</b> = " + String.valueOf(this.getLocation()) + " <br/> <b>Rotation</b> = " + String.valueOf(this.getRotation()) + " <br/> <b>Velocity</b> = " + String.valueOf(this.getVelocity()) + " <br/> <b>Type</b> = " + String.valueOf(this.getType()) + " <br/> <b>EntityClass</b> = " + String.valueOf(this.getEntityClass()) + " <br/> <br/>]";
    }

    public class EntityLocalMessage
    extends EntityLocal {
        @Override
        public EntityLocalMessage clone() {
            return this;
        }

        @Override
        public EntityLocalMessage getLocal() {
            return this;
        }

        @Override
        public ISharedWorldObject getShared() {
            throw new UnsupportedOperationException("Could not return LOCAL as SHARED");
        }

        @Override
        public IStaticWorldObject getStatic() {
            throw new UnsupportedOperationException("Could not return LOCAL as STATIC");
        }

        @Override
        public UnrealId getId() {
            return EntityMessage.this.Id;
        }

        @Override
        public boolean isVisible() {
            return EntityMessage.this.Visible;
        }

        @Override
        public String toString() {
            return super.toString() + "[Id = " + String.valueOf(this.getId()) + " | Visible = " + String.valueOf(this.isVisible()) + " | ]";
        }

        @Override
        public String toHtmlString() {
            return super.toString() + "[<br/><b>Id</b> = " + String.valueOf(this.getId()) + " <br/> <b>Visible</b> = " + String.valueOf(this.isVisible()) + " <br/> <br/>]";
        }
    }

    public class EntitySharedMessage
    extends EntityShared {
        protected HashMap<PropertyId, ISharedProperty> propertyMap = new HashMap(3);
        protected LocationProperty myLocation;
        protected RotationProperty myRotation;
        protected VelocityProperty myVelocity;

        public EntitySharedMessage() {
            this.myLocation = new LocationProperty((WorldObjectId)this.getId(), "Location", EntityMessage.this.Location, Entity.class);
            this.myRotation = new RotationProperty((WorldObjectId)this.getId(), "Rotation", EntityMessage.this.Rotation, Entity.class);
            this.myVelocity = new VelocityProperty((WorldObjectId)this.getId(), "Velocity", EntityMessage.this.Velocity, Entity.class);
            this.propertyMap.put(this.myLocation.getPropertyId(), (ISharedProperty)this.myLocation);
            this.propertyMap.put(this.myRotation.getPropertyId(), (ISharedProperty)this.myRotation);
            this.propertyMap.put(this.myVelocity.getPropertyId(), (ISharedProperty)this.myVelocity);
        }

        @Override
        public EntitySharedMessage clone() {
            return this;
        }

        public ISharedProperty getProperty(PropertyId id) {
            return this.propertyMap.get(id);
        }

        public Map<PropertyId, ISharedProperty> getProperties() {
            return this.propertyMap;
        }

        @Override
        public UnrealId getId() {
            return EntityMessage.this.Id;
        }

        @Override
        public Location getLocation() {
            return (Location)this.myLocation.getValue();
        }

        @Override
        public Rotation getRotation() {
            return (Rotation)this.myRotation.getValue();
        }

        @Override
        public Velocity getVelocity() {
            return (Velocity)this.myVelocity.getValue();
        }

        @Override
        public String toString() {
            return super.toString() + "[Id = " + String.valueOf(this.getId()) + " | Location = " + String.valueOf(this.getLocation()) + " | Rotation = " + String.valueOf(this.getRotation()) + " | Velocity = " + String.valueOf(this.getVelocity()) + " | ]";
        }

        @Override
        public String toHtmlString() {
            return super.toString() + "[<br/><b>Id</b> = " + String.valueOf(this.getId()) + " <br/> <b>Location</b> = " + String.valueOf(this.getLocation()) + " <br/> <b>Rotation</b> = " + String.valueOf(this.getRotation()) + " <br/> <b>Velocity</b> = " + String.valueOf(this.getVelocity()) + " <br/> <br/>]";
        }
    }

    public class EntityStaticMessage
    extends EntityStatic {
        @Override
        public EntityStaticMessage clone() {
            return this;
        }

        @Override
        public UnrealId getId() {
            return EntityMessage.this.Id;
        }

        @Override
        public String getType() {
            return EntityMessage.this.Type;
        }

        @Override
        public String getEntityClass() {
            return EntityMessage.this.EntityClass;
        }

        @Override
        public boolean isDifferentFrom(IStaticWorldObject other) {
            if (other == null) {
                return true;
            }
            if (other == this) {
                return false;
            }
            EntityStatic obj = (EntityStatic)other;
            if (!AdvancedEquals.equalsOrNull((Object)this.getId(), (Object)obj.getId())) {
                System.out.println("!!!!!PROPERTY UPDATE ERROR!!!! on property Id on object class EntityStatic");
                return true;
            }
            if (!AdvancedEquals.equalsOrNull((Object)this.getType(), (Object)obj.getType())) {
                System.out.println("!!!!!PROPERTY UPDATE ERROR!!!! on property Type on object class EntityStatic");
                return true;
            }
            if (!AdvancedEquals.equalsOrNull((Object)this.getEntityClass(), (Object)obj.getEntityClass())) {
                System.out.println("!!!!!PROPERTY UPDATE ERROR!!!! on property EntityClass on object class EntityStatic");
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return super.toString() + "[Id = " + String.valueOf(this.getId()) + " | Type = " + String.valueOf(this.getType()) + " | EntityClass = " + String.valueOf(this.getEntityClass()) + " | ]";
        }

        @Override
        public String toHtmlString() {
            return super.toString() + "[<br/><b>Id</b> = " + String.valueOf(this.getId()) + " <br/> <b>Type</b> = " + String.valueOf(this.getType()) + " <br/> <b>EntityClass</b> = " + String.valueOf(this.getEntityClass()) + " <br/> <br/>]";
        }
    }
}

