/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathTracer;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshEdge;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathTracer.IPathTraceContext;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathTracer.RayPath;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathTracer.XyProjectionNavMeshPathTraceContext;
import java.awt.geom.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.Ray2D;
import math.geom3d.line.LineSegment3D;

public class NavMeshPathTracer {
    public static RayPath<NavMeshPolygon, NavMeshEdge> trace(NavMeshPolygon startPolygon, Location start, Vector2D direction2d, Predicate<RayPath<NavMeshPolygon, NavMeshEdge>> keepGoingCondition) {
        return NavMeshPathTracer.trace(startPolygon, start, direction2d, XyProjectionNavMeshPathTraceContext.getInstance(), keepGoingCondition);
    }

    public static <TPolygon, TEdge> RayPath<TPolygon, TEdge> trace(TPolygon startPolygon, Location start, Vector2D direction2d, IPathTraceContext<TPolygon, TEdge> context, Predicate<RayPath<TPolygon, TEdge>> keepGoingCondition) {
        RayPath rayPath = new RayPath(startPolygon);
        math.geom2d.Point2D start2d = context.project(start);
        Ray2D ray = new Ray2D(start2d, start2d.plus(direction2d));
        TPolygon currentPolygon = startPolygon;
        Object previousPolygon = null;
        do {
            Object intersectingEdge = null;
            LineSegment2D intersectingEdge2d = null;
            math.geom2d.Point2D intersection2d = null;
            for (TEdge edge : context.getEdges(currentPolygon)) {
                LineSegment2D edge2d;
                if (previousPolygon != null && previousPolygon.equals(context.getAdjacentPolygonByEdge(currentPolygon, edge)) || (intersection2d = ray.getIntersection((LinearShape2D)(edge2d = new LineSegment2D((Point2D)context.project(context.getSourceVertex(edge)), (Point2D)context.project(context.getDestinationVertex(edge)))))) == null) continue;
                intersectingEdge = edge;
                intersectingEdge2d = edge2d;
                break;
            }
            if (intersectingEdge == null) {
                if (rayPath.getSteps().size() == 0) {
                    return rayPath;
                }
                RayPath.PathStep lastStep = (RayPath.PathStep)Iterables.getLast(rayPath.getSteps());
                if (lastStep == null) {
                    return rayPath;
                }
                lastStep.polygon = null;
                return rayPath;
            }
            assert (intersectingEdge != null);
            assert (intersectingEdge2d != null);
            assert (intersection2d != null);
            LineSegment3D edge3d = new LineSegment3D(context.getSourceVertex(intersectingEdge).asPoint3D(), context.getDestinationVertex(intersectingEdge).asPoint3D());
            Location edge3DDir = context.getDestinationVertex(intersectingEdge).sub(context.getSourceVertex(intersectingEdge));
            Location intersection = context.getSourceVertex(intersectingEdge).add(edge3DDir.scale(intersectingEdge2d.project((Point2D)intersection2d)));
            previousPolygon = currentPolygon;
            currentPolygon = context.getAdjacentPolygonByEdge(currentPolygon, intersectingEdge);
            rayPath.addStep(intersection, intersectingEdge, currentPolygon);
        } while (currentPolygon != null && keepGoingCondition.apply(rayPath));
        return rayPath;
    }
}

