/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.polygonPathFunnel;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshBoundary;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshVertex;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.polygonPathFunnel.FunnelRay;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.polygonPathFunnel.FunnelZone;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.polygonPathFunnel.PolygonPathSmoothingFunnelAlgorithm;
import java.awt.geom.Point2D;
import math.geom2d.line.LineSegment2D;
import math.geom3d.Point3D;
import math.geom3d.line.LineSegment3D;

public class Funnel {
    protected FunnelRay leftRay;
    protected FunnelRay rightRay;

    public Funnel(FunnelRay leftRay, FunnelRay rightRay) {
        assert (leftRay.getVantagePoint() == rightRay.getVantagePoint());
        this.leftRay = leftRay;
        this.rightRay = rightRay;
    }

    public static Funnel createFromBoundary(ILocated vantagePoint, NavMeshBoundary boundary, int index) {
        NavMeshVertex boundarySourceVertex = boundary.getSourceVertex();
        NavMeshVertex boundaryDestinationVertex = boundary.getDestinationVertex();
        LineSegment2D gateway = PolygonPathSmoothingFunnelAlgorithm.xyPlaneSubsystem.project(boundary.asLineSegment3D());
        FunnelRay leftRay = null;
        FunnelRay rightRay = null;
        math.geom2d.Point2D vantagePoint2D = PolygonPathSmoothingFunnelAlgorithm.xyPlaneSubsystem.project(vantagePoint.getLocation().asPoint3D());
        if (gateway.getSignedDistance((Point2D)vantagePoint2D) < 0.0) {
            leftRay = FunnelRay.createLeftRay(vantagePoint, boundary, index, boundarySourceVertex);
            rightRay = FunnelRay.createRightRay(vantagePoint, boundary, index, boundaryDestinationVertex);
        } else {
            leftRay = FunnelRay.createLeftRay(vantagePoint, boundary, index, boundaryDestinationVertex);
            rightRay = FunnelRay.createRightRay(vantagePoint, boundary, index, boundarySourceVertex);
        }
        return new Funnel(leftRay, rightRay);
    }

    public FunnelRay getLeftRay() {
        return this.leftRay;
    }

    public FunnelRay getRightRay() {
        return this.rightRay;
    }

    public ILocated getVantagePoint() {
        return this.leftRay.getVantagePoint();
    }

    public FunnelZone determineZone(Point3D point) {
        if (this.leftRay.isOnOutsideSide(point)) {
            return FunnelZone.OUTSIDE_LEFT;
        }
        if (this.rightRay.isOnOutsideSide(point)) {
            return FunnelZone.OUTSIDE_RIGHT;
        }
        return FunnelZone.INSIDE;
    }

    public LineSegment3D getGateway() {
        return new LineSegment3D(this.leftRay.getCrossing().getLocation().asPoint3D(), this.rightRay.getCrossing().getLocation().asPoint3D());
    }
}

