/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.AStar;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.PrecomputedPathFuture;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshConstants;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.grounder.NavMeshDropGrounder;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.INavMeshAtom;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshBoundary;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.OffMeshPoint;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.AStar.NavMeshAStarNode;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.polygonPathFunnel.PolygonPathSmoothingFunnelAlgorithm;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import math.geom3d.line.LineSegment3D;
import math.geom3d.plane.Plane3D;
import math.geom3d.plane.Plane3DCoordinateSubsystem;

@Deprecated
public class NavMeshSegmentedAStarPathPlanner
implements IPathPlanner<ILocated> {
    protected Supplier<Collection<NavPoint>> navGraphProvider;
    protected NavMeshDropGrounder grounder;
    protected NavMesh navMesh;
    protected Logger log;
    protected FloydWarshallMap fwMap;
    protected Collection<NavPoint> allNavPoints;
    protected boolean hasTeleports;

    public NavMeshSegmentedAStarPathPlanner(Supplier<Collection<NavPoint>> navGraphProvider, NavMeshDropGrounder grounder, NavMesh navMesh, Logger log) {
        this.navGraphProvider = navGraphProvider;
        this.grounder = grounder;
        this.navMesh = navMesh;
        this.log = log;
        this.fwMap = null;
        this.allNavPoints = null;
        this.hasTeleports = false;
    }

    public IPathFuture<ILocated> computePath(ILocated from, ILocated to) {
        return new PrecomputedPathFuture((Object)from, (Object)to, this.getPath(from, to));
    }

    public double getDistance(ILocated from, ILocated to) {
        IPathFuture<ILocated> path = this.computePath(from, to);
        if (path.isDone()) {
            List list = path.get();
            if (list.size() == 0) {
                return Double.POSITIVE_INFINITY;
            }
            ILocated location = (ILocated)list.get(0);
            double result = 0.0;
            int i = 1;
            while (i < list.size()) {
                ILocated next = (ILocated)list.get(i);
                result += location.getLocation().getDistance(next.getLocation());
                location = next;
                ++i;
            }
            return result;
        }
        return Double.POSITIVE_INFINITY;
    }

    public List<INavMeshAtom> getPolygonPath(INavMeshAtom fromAtom, INavMeshAtom toAtom) {
        NavMeshAStarNode node2;
        ArrayList<NavMeshAStarNode> pickable = new ArrayList<NavMeshAStarNode>();
        ArrayList<NavMeshAStarNode> expanded = new ArrayList<NavMeshAStarNode>();
        NavMeshAStarNode firstNode = new NavMeshAStarNode(null, fromAtom, 0.0, fromAtom.getLocation().getDistance(toAtom.getLocation()));
        pickable.add(firstNode);
        NavMeshAStarNode targetNode = null;
        if (fromAtom.equals(toAtom)) {
            targetNode = firstNode;
        }
        while (targetNode == null) {
            if (pickable.isEmpty()) {
                return null;
            }
            NavMeshAStarNode best = (NavMeshAStarNode)pickable.get(0);
            for (NavMeshAStarNode node2 : pickable) {
                if (!(node2.getEstimatedTotalCost() < best.getEstimatedTotalCost())) continue;
                best = node2;
            }
            List<INavMeshAtom> neighbors = best.getAtom().getNeighbors();
            for (INavMeshAtom atom : neighbors) {
                boolean add = true;
                for (NavMeshAStarNode expNode : expanded) {
                    if (!expNode.getAtom().equals(atom)) continue;
                    add = false;
                }
                if (!add) continue;
                double costFromStart = best.getCostFromStart() + best.getAtom().getLocation().getDistance(atom.getLocation());
                double estimatedCostToTarget = atom.getLocation().getDistance(toAtom.getLocation());
                NavMeshAStarNode newNode = new NavMeshAStarNode(best, atom, costFromStart, estimatedCostToTarget);
                pickable.add(newNode);
                if (!atom.equals(toAtom)) continue;
                targetNode = newNode;
            }
            pickable.remove(best);
            expanded.add(best);
        }
        ArrayList<INavMeshAtom> path = new ArrayList<INavMeshAtom>();
        node2 = targetNode;
        while (node2 != null) {
            path.add(node2.getAtom());
            node2 = node2.getPrevious();
        }
        Collections.reverse(path);
        return path;
    }

    public List<INavMeshAtom> getPolygonPath(Location from, Location to) {
        return this.getPolygonPath(this.ground(from), this.ground(to));
    }

    private List<ILocated> convertAtomPathToPointPath(ILocated from, ILocated to, List<INavMeshAtom> atomPath, BoundaryCrossingStrategy boundaryCrossingStrategy) {
        ArrayList<ILocated> path = new ArrayList<ILocated>();
        path.add(from);
        ArrayList polygonSubpath = Lists.newArrayList();
        for (INavMeshAtom atom : atomPath) {
            boolean isPreviousInside;
            if (atom instanceof OffMeshPoint) {
                OffMeshPoint point = (OffMeshPoint)atom;
                if (polygonSubpath.size() > 0) {
                    ILocated leadIn = path.size() > 0 ? (ILocated)path.get(path.size() - 1) : from;
                    path.addAll(this.findCrossings(leadIn, polygonSubpath, point, boundaryCrossingStrategy));
                    polygonSubpath.clear();
                }
                path.add(point);
                continue;
            }
            assert (atom instanceof NavMeshPolygon);
            NavMeshPolygon polygon = (NavMeshPolygon)atom;
            if (path.isEmpty() && !(isPreviousInside = this.polygonContainsPoint(polygon, new math.geom2d.Point2D(from.getLocation().x, from.getLocation().y)))) {
                path.add((ILocated)polygon.getCenter());
            }
            polygonSubpath.add(polygon);
        }
        if (polygonSubpath.size() > 0) {
            path.addAll(this.findCrossings((ILocated)path.get(path.size() - 1), polygonSubpath, to, boundaryCrossingStrategy));
        }
        path.add(to);
        return path;
    }

    private List<ILocated> findCrossings(ILocated leadIn, List<NavMeshPolygon> polygonPath, ILocated leadOut, BoundaryCrossingStrategy boundaryCrossingStrategy) {
        ArrayList boundaries = Lists.newArrayList();
        int i = 0;
        while (i < polygonPath.size() - 1) {
            NavMeshPolygon p1 = polygonPath.get(i);
            NavMeshPolygon p2 = polygonPath.get(i + 1);
            boundaries.add(p1.getAdjPolygonToBoundaryMap().get(p2));
            ++i;
        }
        switch (boundaryCrossingStrategy) {
            case CENTER: {
                return this.findCenterCrossings(leadIn, boundaries, leadOut);
            }
            case SHORTEST: {
                return PolygonPathSmoothingFunnelAlgorithm.findShortestPathCrossings(leadIn, boundaries, leadOut);
            }
        }
        throw new AssertionError((Object)"Unrecognized strategy");
    }

    private List<ILocated> findCenterCrossings(ILocated leadIn, List<NavMeshBoundary> boundaries, ILocated leadOut) {
        ArrayList crossings = Lists.newArrayList();
        for (NavMeshBoundary boundary : boundaries) {
            LineSegment3D boundaryLs = new LineSegment3D(boundary.getSourceVertex().getLocation().asPoint3D(), boundary.getDestinationVertex().getLocation().asPoint3D());
            crossings.add(new Location(boundaryLs.getPoint(0.5)).addZ(NavMeshConstants.liftPolygonLocation));
        }
        return crossings;
    }

    public List<ILocated> getPath(ILocated from, ILocated to) {
        List<INavMeshAtom> polygonPath = null;
        if (this.allNavPoints == null) {
            this.initNavPoints();
        }
        if (this.fwMap != null && this.allNavPoints != null) {
            List<NavPoint> path;
            NavPoint fromNp = (NavPoint)DistanceUtils.getNearest(this.allNavPoints, (ILocated)from);
            NavPoint toNp = (NavPoint)DistanceUtils.getNearest(this.allNavPoints, (ILocated)to);
            if (this.hasTeleports && (path = this.fwMap.getPath(fromNp, toNp)) != null) {
                INavMeshAtom atomFrom = this.ground(from.getLocation());
                boolean skip = false;
                for (NavPoint np : path) {
                    if (skip) {
                        atomFrom = this.getNearestOffmeshPoint(np.getLocation());
                        skip = false;
                        continue;
                    }
                    if (!np.isTeleporter()) continue;
                    INavMeshAtom atomTo = this.getNearestOffmeshPoint(np.getLocation());
                    List<INavMeshAtom> pathPart = this.getPolygonPath(atomFrom, atomTo);
                    if (pathPart == null) {
                        polygonPath = null;
                        break;
                    }
                    if (polygonPath == null) {
                        polygonPath = pathPart;
                    } else {
                        polygonPath.addAll(pathPart);
                    }
                    skip = true;
                }
                if (polygonPath != null) {
                    INavMeshAtom atomTo = this.ground(to.getLocation());
                    List<INavMeshAtom> pathPart = this.getPolygonPath(atomFrom, atomTo);
                    if (pathPart != null) {
                        polygonPath.addAll(pathPart);
                    } else {
                        polygonPath = null;
                    }
                }
            }
        }
        if (polygonPath == null) {
            polygonPath = this.getPolygonPath(from.getLocation(), to.getLocation());
        }
        if (polygonPath == null) {
            return null;
        }
        List<ILocated> path = this.convertAtomPathToPointPath(from, to, polygonPath, BoundaryCrossingStrategy.SHORTEST);
        return path;
    }

    public void setFwMap(FloydWarshallMap fwMap) {
        this.fwMap = fwMap;
    }

    public void clear() {
        this.allNavPoints = null;
        this.fwMap = null;
        this.hasTeleports = false;
    }

    private boolean polygonContainsPoint(NavMeshPolygon polygon, math.geom2d.Point2D point2D) {
        Plane3DCoordinateSubsystem xyPlaneCoordSubsystem = Plane3D.xyPlane.getCoordinateSubsystem();
        return xyPlaneCoordSubsystem.project(polygon.getShape()).contains((Point2D)point2D);
    }

    private void initNavPoints() {
        this.allNavPoints = (Collection)this.navGraphProvider.get();
        this.hasTeleports = false;
        for (NavPoint np : this.allNavPoints) {
            if (!np.isTeleporter()) continue;
            this.hasTeleports = true;
            break;
        }
    }

    private INavMeshAtom ground(Location location) {
        return this.grounder.forceGround((ILocated)location);
    }

    private INavMeshAtom getNearestOffmeshPoint(Location location) {
        return (INavMeshAtom)DistanceUtils.getNearest(this.navMesh.getOffMeshPoints(), (ILocated)location);
    }

    static enum BoundaryCrossingStrategy {
        CENTER,
        SHORTEST;

    }
}

