/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.construction.IDeferredConstructor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.construction.NodeConstructionCoordinator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.INavMeshAtom;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.OffMeshEdge;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.internal.NavMeshNavGraphGlue;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OffMeshPoint
implements ILocated,
INavMeshAtom,
Serializable {
    private static final long serialVersionUID = 1L;
    protected NavMeshNavGraphGlue navGraphGlue;
    protected UnrealId navPointId;
    protected NavMeshPolygon polygon;
    protected ArrayList<OffMeshEdge> outgoingEdges = new ArrayList();
    protected transient List<OffMeshEdge> constOutgoingEdges;
    protected ArrayList<OffMeshEdge> incomingEdges = new ArrayList();
    protected transient List<OffMeshEdge> constIncomingEdges;
    protected ArrayList<INavMeshAtom> neighbors = new ArrayList();
    protected transient List<INavMeshAtom> constNeighbors;

    public OffMeshPoint(NavMeshNavGraphGlue navGraphGlue, NavPoint navPoint, final Integer polygonId, final Collection<NavPointNeighbourLink> outgoingNavLinks, final Collection<NavPointNeighbourLink> incomingNavLinks, final NodeConstructionCoordinator constructionCoordinator) {
        this.navGraphGlue = navGraphGlue;
        this.navPointId = navPoint.getId();
        this.initializeConstCollections();
        constructionCoordinator.addDeferredConstructor(new IDeferredConstructor(){

            @Override
            public void construct() {
                if (polygonId != null) {
                    OffMeshPoint.this.polygon = constructionCoordinator.getPolygonById(polygonId);
                    OffMeshPoint.this.neighbors.add(OffMeshPoint.this.polygon);
                } else {
                    OffMeshPoint.this.polygon = null;
                }
                for (NavPointNeighbourLink link : outgoingNavLinks) {
                    OffMeshPoint.this.outgoingEdges.add(constructionCoordinator.getOffMeshEdgeByNavLink(link));
                    OffMeshPoint.this.neighbors.add(constructionCoordinator.getOffMeshPointByNavPoint(link.getToNavPoint()));
                }
                for (NavPointNeighbourLink link : incomingNavLinks) {
                    OffMeshPoint.this.incomingEdges.add(constructionCoordinator.getOffMeshEdgeByNavLink(link));
                }
            }
        });
    }

    public NavPoint getNavPoint() {
        return this.navGraphGlue.getNavPoint(this.navPointId);
    }

    public NavMeshPolygon getPolygon() {
        return this.polygon;
    }

    public List<OffMeshEdge> getOutgoingEdges() {
        return this.constOutgoingEdges;
    }

    public List<OffMeshEdge> getIncomingEdges() {
        return this.constIncomingEdges;
    }

    public Location getLocation() {
        return this.getNavPoint().getLocation();
    }

    @Override
    public List<INavMeshAtom> getNeighbors() {
        return this.constNeighbors;
    }

    public String toString() {
        return "OFP( " + this.getNavPoint().toString() + " )";
    }

    protected void initializeConstCollections() {
        this.constOutgoingEdges = Collections.unmodifiableList(this.outgoingEdges);
        this.constIncomingEdges = Collections.unmodifiableList(this.incomingEdges);
        this.constNeighbors = Collections.unmodifiableList(this.neighbors);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeConstCollections();
    }
}

