/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.INavMeshDraw;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.IUT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.UT2004Draw;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshEdge;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.OffMeshEdge;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.OffMeshPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DrawStayingDebugLines;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.LinkFlag;
import java.util.List;
import java.util.logging.Logger;
import math.geom3d.Point3D;

public class NavMeshDraw
extends UT2004Draw
implements INavMeshDraw {
    private NavMesh navMesh;
    private static final int zOffset = 30;

    public NavMeshDraw(NavMesh navMesh, Logger log, IUT2004ServerProvider serverProvider) {
        super(log, serverProvider);
        this.navMesh = navMesh;
    }

    @Override
    public boolean draw(boolean drawMesh, boolean drawOffMeshLinks) {
        if (this.navMesh == null || !this.navMesh.isLoaded()) {
            return false;
        }
        if (drawMesh) {
            boolean isFirst = true;
            for (NavMeshPolygon polygon : this.navMesh.getPolygons()) {
                DrawStayingDebugLines d = new DrawStayingDebugLines();
                String lines = this.polygonToDebugString(polygon);
                d.setVectors(lines);
                d.setColor(new Location(255.0, 255.0, 255.0));
                d.setClearAll(isFirst);
                isFirst = false;
                this.getServer().getAct().act((CommandMessage)d);
            }
        }
        if (drawOffMeshLinks) {
            for (OffMeshPoint op : this.navMesh.getOffMeshPoints()) {
                for (OffMeshEdge edge : op.getOutgoingEdges()) {
                    DrawStayingDebugLines d = new DrawStayingDebugLines();
                    String lines = this.offMeshEdgeToDebugString(edge);
                    d.setVectors(lines);
                    d.setColor(this.getColorForOffMeshConnection(edge, this.getServer()));
                    d.setClearAll(false);
                    this.getServer().getAct().act((CommandMessage)d);
                }
            }
        }
        return true;
    }

    private Location getColorForOffMeshConnection(OffMeshEdge oe, UT2004Server server) {
        NavPoint from = (NavPoint)((UT2004WorldView)((Object)server.getWorldView())).get((WorldObjectId)oe.getFrom().getNavPoint().getId(), NavPoint.class);
        NavPoint to = (NavPoint)((UT2004WorldView)((Object)server.getWorldView())).get((WorldObjectId)oe.getTo().getNavPoint().getId(), NavPoint.class);
        if (from == null || to == null) {
            return new Location(255.0, 255.0, 100.0);
        }
        if (from.isLiftCenter() || to.isLiftCenter()) {
            return new Location(0.0, 0.0, 255.0);
        }
        if (from.isTeleporter() && to.isTeleporter()) {
            return new Location(150.0, 0.0, 255.0);
        }
        NavPointNeighbourLink oeLink = oe.getLink();
        if (oeLink == null) {
            return new Location(255.0, 255.0, 100.0);
        }
        NavPointNeighbourLink link = from.getOutgoingEdges().get(oeLink.getId());
        if (link != null) {
            int linkFlags = link.getFlags();
            LinkFlag.DOOR.get();
            if ((linkFlags & LinkFlag.FLY.get()) > 0) {
                return new Location(255.0, 0.0, 0.0);
            }
            if ((linkFlags & LinkFlag.FORCED.get()) > 0) {
                return new Location(255.0, 170.0, 255.0);
            }
            if ((linkFlags & LinkFlag.LADDER.get()) > 0) {
                return new Location(255.0, 0.0, 0.0);
            }
            if ((linkFlags & LinkFlag.PLAYERONLY.get()) > 0) {
                return new Location(255.0, 0.0, 0.0);
            }
            if ((linkFlags & LinkFlag.PROSCRIBED.get()) > 0) {
                return new Location(255.0, 0.0, 0.0);
            }
            if ((linkFlags & LinkFlag.SPECIAL.get()) > 0) {
                return new Location(255.0, 0.0, 255.0);
            }
            if ((linkFlags & LinkFlag.SWIM.get()) > 0) {
                return new Location(255.0, 0.0, 0.0);
            }
            LinkFlag.WALK.get();
            if ((linkFlags & LinkFlag.JUMP.get()) > 0) {
                return new Location(100.0, 255.0, 255.0);
            }
        }
        return new Location(255.0, 255.0, 100.0);
    }

    private String offMeshEdgeToDebugString(OffMeshEdge edge) {
        StringBuilder result = new StringBuilder("");
        Location l1 = edge.getFrom().getLocation();
        Location l2 = edge.getTo().getLocation();
        result.append(String.valueOf(l1.x) + "," + l1.y + "," + l1.z + ";" + l2.x + "," + l2.y + "," + l2.z);
        double[] vector = new double[]{l1.x - l2.x, l1.y - l2.y, l1.z - l2.z};
        double length = Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2]);
        vector[0] = vector[0] * (1.0 / length * 20.0);
        vector[1] = vector[1] * (1.0 / length * 20.0);
        vector[2] = vector[2] * (1.0 / length * 20.0);
        Point3D cross = new Point3D(l2.x + vector[0], l2.y + vector[1], l2.z + vector[2]);
        double[] vector2 = new double[]{vector[1] / 2.0, -vector[0] / 2.0};
        Point3D arrowPoint1 = new Point3D(cross.getX() + vector2[0], cross.getY() + vector2[1], cross.getZ());
        Point3D arrowPoint2 = new Point3D(cross.getX() - vector2[0], cross.getY() - vector2[1], cross.getZ());
        result.append(";");
        result.append(String.valueOf(arrowPoint1.getX()) + "," + arrowPoint1.getY() + "," + arrowPoint1.getZ() + ";" + l2.x + "," + l2.y + "," + l2.z);
        result.append(";");
        result.append(String.valueOf(arrowPoint2.getX()) + "," + arrowPoint2.getY() + "," + arrowPoint2.getZ() + ";" + l2.x + "," + l2.y + "," + l2.z);
        result.append(";");
        result.append(String.valueOf(arrowPoint1.getX()) + "," + arrowPoint1.getY() + "," + arrowPoint1.getZ() + ";" + arrowPoint2.getX() + "," + arrowPoint2.getY() + "," + arrowPoint2.getZ());
        return result.toString();
    }

    public String polygonToDebugString(NavMeshPolygon polygon) {
        StringBuilder result = new StringBuilder("");
        List<NavMeshEdge> edges = polygon.getEdges();
        for (NavMeshEdge e : edges) {
            Location s = e.getSource().getLocation();
            Location d = e.getDestination().getLocation();
            result.append(String.valueOf(s.x) + "," + s.y + "," + (s.z + 30.0) + ";" + d.x + "," + d.y + "," + (d.z + 30.0) + ";");
        }
        return result.toString();
    }
}

