/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.construction;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.NavMeshBoundaryInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.construction.IDeferredConstructor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshBoundary;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshEdge;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshVertex;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.OffMeshEdge;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.OffMeshPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class NodeConstructionCoordinator {
    protected ArrayList<IDeferredConstructor> deferredConstructors = Lists.newArrayList();
    protected HashMap<Integer, NavMeshPolygon> polygonIdToPolygonMap = Maps.newHashMap();
    protected HashMap<Integer, NavMeshVertex> vertexIdToVertexMap = Maps.newHashMap();
    protected HashMap<Integer, NavMeshEdge> polygonEdgeIdToEdgeMap = Maps.newHashMap();
    protected HashMap<NavMeshBoundaryInfo, NavMeshBoundary> boundaryInfoToBoundaryMap = Maps.newHashMap();
    protected HashMap<NavPoint, OffMeshPoint> offMeshNavPointToOffMeshPointMap = Maps.newHashMap();
    protected HashMap<NavPointNeighbourLink, OffMeshEdge> offMeshNavLinkToOffMeshEdgeMap = Maps.newHashMap();

    public void addDeferredConstructor(IDeferredConstructor deferredConstructor) {
        this.deferredConstructors.add(deferredConstructor);
    }

    public void runDeferredConstructors() {
        for (IDeferredConstructor deferredConstructor : this.deferredConstructors) {
            deferredConstructor.construct();
        }
        this.deferredConstructors.clear();
    }

    public NavMeshVertex getVertexById(int vertexId) {
        assert (this.vertexIdToVertexMap.containsKey(vertexId));
        return this.vertexIdToVertexMap.get(vertexId);
    }

    public NavMeshPolygon getPolygonById(int polygonId) {
        assert (this.polygonIdToPolygonMap.containsKey(polygonId));
        return this.polygonIdToPolygonMap.get(polygonId);
    }

    public NavMeshEdge getEdgeById(int edgeId) {
        assert (this.polygonEdgeIdToEdgeMap.containsKey(edgeId));
        return this.polygonEdgeIdToEdgeMap.get(edgeId);
    }

    public NavMeshBoundary getBoundaryByBoundaryInfo(NavMeshBoundaryInfo boundaryInfo) {
        assert (this.boundaryInfoToBoundaryMap.containsKey(boundaryInfo));
        return this.boundaryInfoToBoundaryMap.get(boundaryInfo);
    }

    public OffMeshPoint getOffMeshPointByNavPoint(NavPoint offMeshNavPoint) {
        assert (this.offMeshNavPointToOffMeshPointMap.containsKey(offMeshNavPoint));
        return this.offMeshNavPointToOffMeshPointMap.get(offMeshNavPoint);
    }

    public OffMeshEdge getOffMeshEdgeByNavLink(NavPointNeighbourLink link) {
        assert (this.offMeshNavLinkToOffMeshEdgeMap.containsKey((Object)link));
        return this.offMeshNavLinkToOffMeshEdgeMap.get((Object)link);
    }

    public void addVertex(NavMeshVertex vertex) {
        this.vertexIdToVertexMap.put(vertex.getId(), vertex);
    }

    public void addPolygon(NavMeshPolygon polygon) {
        this.polygonIdToPolygonMap.put(polygon.getId(), polygon);
    }

    public void addPolygonEdge(NavMeshEdge edge) {
        this.polygonEdgeIdToEdgeMap.put(edge.getId(), edge);
    }

    public void addBoundary(NavMeshBoundaryInfo boundaryInfo, NavMeshBoundary boundary) {
        this.boundaryInfoToBoundaryMap.put(boundaryInfo, boundary);
    }

    public void addOffMeshPoint(OffMeshPoint offMeshPoint) {
        this.offMeshNavPointToOffMeshPointMap.put(offMeshPoint.getNavPoint(), offMeshPoint);
    }

    public void addOffMeshEdge(NavPointNeighbourLink link, OffMeshEdge edge) {
        this.offMeshNavLinkToOffMeshEdgeMap.put(link, edge);
    }

    public HashSet<NavMeshPolygon> getPolygons() {
        return Sets.newHashSet(this.polygonIdToPolygonMap.values());
    }

    public HashSet<NavMeshVertex> getVertices() {
        return Sets.newHashSet(this.vertexIdToVertexMap.values());
    }

    public HashSet<OffMeshPoint> getOffMeshPoints() {
        return Sets.newHashSet(this.offMeshNavPointToOffMeshPointMap.values());
    }
}

