/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.construction;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.LineSegmentAnalysis;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.NavGraphAnalysis;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.NavMeshBoundaryInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.PolygonAnalysis;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.ReachabilityAnalysis;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.construction.NodeConstructionCoordinator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.bsp.XyProjectionPolygonPartitioningStrategy;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshBoundary;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshEdge;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshVertex;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.OffMeshEdge;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.OffMeshPoint;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.internal.NavMeshNavGraphGlue;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import math.bsp.BspTree;
import math.bsp.IBspStrategy;
import math.geom2d.line.StraightLine2D;

public class NavMeshConstruction {
    protected NavMeshNavGraphGlue navGraphGlue;
    protected HashSet<NavMeshPolygon> polygons;
    protected HashSet<NavMeshVertex> vertices;
    protected HashSet<OffMeshPoint> offMeshPoints;
    protected BspTree<ArrayList<NavMeshPolygon>, StraightLine2D> xyProjectionBsp;

    public NavMeshConstruction(final Map<UnrealId, NavPoint> navGraph, ReachabilityAnalysis reachabilityAnalysis, PolygonAnalysis polygonAnalysis, LineSegmentAnalysis lineSegmentAnalysis, NavGraphAnalysis navGraphAnalysis) {
        NodeConstructionCoordinator coordinator = new NodeConstructionCoordinator();
        this.navGraphGlue = new NavMeshNavGraphGlue(new Function<UnrealId, NavPoint>(){

            public NavPoint apply(UnrealId input) {
                return (NavPoint)navGraph.get(input);
            }
        });
        Iterator<Object> iterator = reachabilityAnalysis.reachablePolygons.iterator();
        while (iterator.hasNext()) {
            int reachablePolygonId = iterator.next();
            PolygonAnalysis.PolygonInfo paPolygonInfo = polygonAnalysis.polygonIdToInfoMap.get(reachablePolygonId);
            LineSegmentAnalysis.PolygonInfo lsaPolygonInfo = lineSegmentAnalysis.getPolygonInfo(reachablePolygonId);
            ArrayList edgeIds = Lists.newArrayList();
            int vertexIndex = 0;
            while (vertexIndex < paPolygonInfo.vertexIds.size()) {
                int edgeIndex = vertexIndex;
                NavMeshEdge edge = new NavMeshEdge(paPolygonInfo.edgeIds.get(edgeIndex), edgeIndex, reachablePolygonId, paPolygonInfo.vertexIds.get(vertexIndex), paPolygonInfo.vertexIds.get((vertexIndex + 1) % paPolygonInfo.vertexIds.size()), lsaPolygonInfo.edgeIndexToBoundaryInfoMap.get(edgeIndex), coordinator);
                coordinator.addPolygonEdge(edge);
                edgeIds.add(edge.getId());
                ++vertexIndex;
            }
            coordinator.addPolygon(new NavMeshPolygon(reachablePolygonId, paPolygonInfo.vertexIds, edgeIds, lsaPolygonInfo.edgeIndexToBoundaryInfoMap, lsaPolygonInfo.adjPolygonIdToBoundaryInfoMap, navGraphAnalysis.getOffMeshPointsByPolygonId(reachablePolygonId), coordinator));
        }
        for (Integer reachableVertexId : reachabilityAnalysis.reachableVertices) {
            PolygonAnalysis.VertexInfo paVertexInfo = polygonAnalysis.vertexIdToInfoMap.get(reachableVertexId);
            LineSegmentAnalysis.VertexInfo lsaVertexInfo = lineSegmentAnalysis.getVertexInfo(reachableVertexId);
            HashMap polygonIdToVertexIndexMap = Maps.newHashMap();
            for (Map.Entry<Integer, Integer> entry : paVertexInfo.containingPolygonIdToVertexIndexMap.entrySet()) {
                polygonIdToVertexIndexMap.put(entry.getKey(), entry.getValue());
            }
            coordinator.addVertex(new NavMeshVertex(reachableVertexId, paVertexInfo.location, polygonIdToVertexIndexMap, lsaVertexInfo.edgeIds, lsaVertexInfo.isOnWalkableAreaEdge, coordinator));
        }
        for (NavMeshBoundaryInfo boundaryInfo : reachabilityAnalysis.reachableBoundaries) {
            coordinator.addBoundary(boundaryInfo, new NavMeshBoundary(polygonAnalysis.polygonIdToInfoMap.get((Object)Integer.valueOf((int)boundaryInfo.polygonAId)).edgeIds.get(boundaryInfo.polygonAEdgeIndex), polygonAnalysis.polygonIdToInfoMap.get((Object)Integer.valueOf((int)boundaryInfo.polygonBId)).edgeIds.get(boundaryInfo.polygonBEdgeIndex), coordinator));
        }
        for (NavPoint offMeshNavPoint : reachabilityAnalysis.reachableOffMeshNavPoints) {
            NavGraphAnalysis.NavPointInfo navPointInfo = navGraphAnalysis.getNavPointInfo(offMeshNavPoint);
            coordinator.addOffMeshPoint(new OffMeshPoint(this.navGraphGlue, offMeshNavPoint, navPointInfo.polygonId, navPointInfo.outgoingOffMeshEdges, navPointInfo.incommingOffMeshEdges, coordinator));
        }
        for (NavPointNeighbourLink offMeshNavLink : reachabilityAnalysis.reachableOffMeshNavLinks) {
            coordinator.addOffMeshEdge(offMeshNavLink, new OffMeshEdge(offMeshNavLink, coordinator));
        }
        coordinator.runDeferredConstructors();
        this.polygons = coordinator.getPolygons();
        this.vertices = coordinator.getVertices();
        this.offMeshPoints = coordinator.getOffMeshPoints();
        XyProjectionPolygonPartitioningStrategy partitioningStrategy = new XyProjectionPolygonPartitioningStrategy();
        this.xyProjectionBsp = BspTree.make((IBspStrategy)partitioningStrategy, new ArrayList<NavMeshPolygon>(this.polygons));
        partitioningStrategy.clearCache();
    }

    public Set<NavMeshPolygon> getPolygons() {
        return Collections.unmodifiableSet(this.polygons);
    }

    public Set<NavMeshVertex> getVertices() {
        return Collections.unmodifiableSet(this.vertices);
    }

    public Set<OffMeshPoint> getOffMeshPoints() {
        return Collections.unmodifiableSet(this.offMeshPoints);
    }

    public BspTree<ArrayList<NavMeshPolygon>, StraightLine2D> getXyProjectionBsp() {
        return this.xyProjectionBsp;
    }

    public NavMeshNavGraphGlue getNavGraphGlue() {
        return this.navGraphGlue;
    }
}

