/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal;

import com.google.common.collect.Maps;
import com.google.inject.internal.Sets;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.LineSegmentAnalysis;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.NavGraphAnalysis;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.NavMeshBoundaryInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.PolygonAnalysis;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;

public class ReachabilityAnalysis {
    public HashSet<Integer> reachablePolygons = Sets.newHashSet();
    public HashSet<Integer> reachableVertices = Sets.newHashSet();
    public HashSet<NavMeshBoundaryInfo> reachableBoundaries = Sets.newHashSet();
    public HashSet<NavPoint> reachableOffMeshNavPoints = Sets.newHashSet();
    public HashSet<NavPointNeighbourLink> reachableOffMeshNavLinks = Sets.newHashSet();
    public HashMap<Integer, HashSet<Integer>> vertexIdToContainingPolygonsMap = Maps.newHashMap();

    public ReachabilityAnalysis(PolygonAnalysis polygonAnalysis, LineSegmentAnalysis lineSegmentAnalysis, NavGraphAnalysis navGraphAnalysis, Logger log) {
        if (navGraphAnalysis.navPointToInfoMap.values().isEmpty()) {
            log.warning("There are no navpoints present within the worldview, could not analyze reachability.");
            return;
        }
        this.reachableOffMeshNavPoints.addAll(navGraphAnalysis.offMeshNavPoints);
        this.reachableOffMeshNavLinks.addAll(navGraphAnalysis.offMeshNavLinks);
        for (NavGraphAnalysis.NavPointInfo navPointInfo : navGraphAnalysis.navPointToInfoMap.values()) {
            this.recursivelyMarkAsReachable(navPointInfo.polygonId, polygonAnalysis, lineSegmentAnalysis);
        }
        log.info("Reachability analysis: There are " + this.reachablePolygons.size() + " reachable polygons containing " + this.reachableVertices.size() + " vertices.");
        Iterator<Object> iterator = this.reachableVertices.iterator();
        while (iterator.hasNext()) {
            int reachableVertexId = (Integer)iterator.next();
            HashSet containingPolygonIds = Sets.newHashSet();
            containingPolygonIds.addAll(polygonAnalysis.vertexIdToInfoMap.get((Object)Integer.valueOf((int)reachableVertexId)).containingPolygonIdToVertexIndexMap.keySet());
            containingPolygonIds.retainAll(this.reachablePolygons);
            this.vertexIdToContainingPolygonsMap.put(reachableVertexId, containingPolygonIds);
        }
    }

    protected void recursivelyMarkAsReachable(Integer polygonId, PolygonAnalysis polygonAnalysis, LineSegmentAnalysis lineSegmentAnalysis) {
        if (polygonId == null || this.reachablePolygons.contains(polygonId)) {
            return;
        }
        this.reachablePolygons.add(polygonId);
        this.reachableVertices.addAll(polygonAnalysis.polygonIdToInfoMap.get((Object)polygonId).vertexIds);
        this.reachableBoundaries.addAll(lineSegmentAnalysis.polygonIdToInfoMap.get((Object)polygonId).edgeIndexToBoundaryInfoMap.values());
        for (int adjacentPolygonId : lineSegmentAnalysis.getPolygonInfo((int)polygonId.intValue()).adjPolygonIdToBoundaryInfoMap.keySet()) {
            this.recursivelyMarkAsReachable(adjacentPolygonId, polygonAnalysis, lineSegmentAnalysis);
        }
    }
}

