/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.bsp.XyProjectionTPolygonPartitioningStrategy;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.file.RawNavMeshFile;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.grounder.NavMeshDropGrounder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import math.bsp.BspTree;
import math.bsp.IBspStrategy;
import math.geom2d.line.StraightLine2D;
import math.geom3d.polygon.SimplePlanarPolygon3D;

public class PolygonAnalysis {
    public ArrayList<Integer> allVertexIds = Lists.newArrayList();
    public ArrayList<Integer> allPolygonIds = Lists.newArrayList();
    public BspTree<ArrayList<Integer>, StraightLine2D> xyProjectionBsp;
    public HashMap<Integer, PolygonInfo> polygonIdToInfoMap = Maps.newHashMap();
    public HashMap<Integer, VertexInfo> vertexIdToInfoMap = Maps.newHashMap();
    protected Function<Integer, SimplePlanarPolygon3D> polygonIdToShapeFunction = new Function<Integer, SimplePlanarPolygon3D>(){

        public SimplePlanarPolygon3D apply(Integer polygonId) {
            return PolygonAnalysis.this.polygonIdToInfoMap.get((Object)polygonId).shape;
        }
    };

    public PolygonAnalysis(RawNavMeshFile rawNavMesh) {
        PolygonInfo polygonInfo;
        int i = 0;
        while (i < rawNavMesh.vertices.size()) {
            this.allVertexIds.add(i);
            this.vertexIdToInfoMap.put(i, new VertexInfo(rawNavMesh.vertices.get(i)));
            ++i;
        }
        i = 0;
        while (i < rawNavMesh.polygons.size()) {
            this.allPolygonIds.add(i);
            ++i;
        }
        int nextEdgeId = 1;
        int polygonId = 0;
        while (polygonId < rawNavMesh.polygons.size()) {
            ArrayList<Integer> rawPolygon = rawNavMesh.polygons.get(polygonId);
            polygonInfo = new PolygonInfo();
            this.polygonIdToInfoMap.put(polygonId, polygonInfo);
            int vertexIndex = 0;
            while (vertexIndex < rawPolygon.size()) {
                int vertexId = rawPolygon.get(vertexIndex);
                VertexInfo vertexInfo = this.vertexIdToInfoMap.get(vertexId);
                assert (!vertexInfo.containingPolygonIdToVertexIndexMap.containsKey(polygonId));
                vertexInfo.containingPolygonIdToVertexIndexMap.put(polygonId, vertexIndex);
                polygonInfo.vertexIds.add(vertexId);
                polygonInfo.edgeIds.add(nextEdgeId++);
                ++vertexIndex;
            }
            ++polygonId;
        }
        for (Integer polygonId2 : this.allPolygonIds) {
            polygonInfo = this.polygonIdToInfoMap.get(polygonId2);
            ArrayList verticesAsPoint3D = Lists.newArrayList();
            for (Integer vertexId : polygonInfo.vertexIds) {
                verticesAsPoint3D.add(this.vertexIdToInfoMap.get((Object)vertexId).location.asPoint3D());
            }
            polygonInfo.shape = new SimplePlanarPolygon3D((Collection)verticesAsPoint3D);
        }
        XyProjectionTPolygonPartitioningStrategy<Integer> partitioningStrategy = new XyProjectionTPolygonPartitioningStrategy<Integer>(){

            @Override
            protected ArrayList<Location> getPolygonVerticesUncached(Integer polygonId) {
                ArrayList locations = Lists.newArrayList();
                for (Integer vertexId : PolygonAnalysis.this.polygonIdToInfoMap.get((Object)polygonId).vertexIds) {
                    locations.add(PolygonAnalysis.this.vertexIdToInfoMap.get((Object)vertexId).location);
                }
                return locations;
            }

            @Override
            protected double getSufficientEliminationFraction() {
                return 0.3;
            }
        };
        this.xyProjectionBsp = BspTree.make((IBspStrategy)partitioningStrategy, this.allPolygonIds);
        partitioningStrategy.clearCache();
    }

    public Integer getPolygonIdBelow(Location location) {
        return NavMeshDropGrounder.getPolygonBelow(location, this.xyProjectionBsp, this.polygonIdToShapeFunction);
    }

    public class PolygonInfo {
        public SimplePlanarPolygon3D shape = null;
        public ArrayList<Integer> vertexIds = Lists.newArrayList();
        public ArrayList<Integer> edgeIds = Lists.newArrayList();
    }

    public class VertexInfo {
        public HashMap<Integer, Integer> containingPolygonIdToVertexIndexMap = Maps.newHashMap();
        public Location location;

        public VertexInfo(Location location) {
            this.location = location;
        }
    }
}

