/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.AStar;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.PrecomputedPathFuture;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshConstants;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.grounder.INavMeshGrounder;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.INavMeshAtom;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshBoundary;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.OffMeshPoint;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.AStar.INavMeshAStarHeuristic;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.AStar.NavMeshAStarNode;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.polygonPathFunnel.PolygonPathSmoothingFunnelAlgorithm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import math.geom3d.line.LineSegment3D;

public class NavMeshAStarPathPlanner
implements IPathPlanner<ILocated> {
    protected INavMeshGrounder grounder;
    protected NavMesh navMesh;
    protected INavMeshAStarHeuristic heuristic;
    protected Logger log;

    public NavMeshAStarPathPlanner(INavMeshGrounder grounder, NavMesh navMesh, INavMeshAStarHeuristic heuristic, Logger log) {
        this.grounder = grounder;
        this.navMesh = navMesh;
        this.heuristic = heuristic;
        this.log = log;
    }

    public PrecomputedPathFuture<ILocated> computePath(ILocated from, ILocated to) {
        return new PrecomputedPathFuture((Object)from, (Object)to, this.getPath(from, to));
    }

    public double getDistance(ILocated from, ILocated to) {
        List path = this.computePath(from, to).get();
        if (path == null || path.size() == 0) {
            return Double.POSITIVE_INFINITY;
        }
        double result = 0.0;
        int i = 1;
        while (i < path.size()) {
            result += ((ILocated)path.get(i - 1)).getLocation().getDistance(((ILocated)path.get(i)).getLocation());
            ++i;
        }
        return result;
    }

    public List<INavMeshAtom> getAtomPath(ILocated from, ILocated to) {
        INavMeshAtom destinationAtom;
        INavMeshAtom startAtom = this.grounder.forceGround((ILocated)from.getLocation());
        if (startAtom.equals(destinationAtom = this.grounder.forceGround((ILocated)to.getLocation()))) {
            return Lists.newArrayList();
        }
        HashMap adjacentNodes = Maps.newHashMap();
        HashMap exploredNodes = Maps.newHashMap();
        adjacentNodes.put(startAtom, this.heuristic.extend(null, startAtom, destinationAtom));
        while (!adjacentNodes.containsKey(destinationAtom)) {
            if (adjacentNodes.isEmpty()) {
                return null;
            }
            NavMeshAStarNode cheapestAdjacentNode = null;
            for (NavMeshAStarNode adjacentNode : adjacentNodes.values()) {
                if (cheapestAdjacentNode != null && !(adjacentNode.getEstimatedTotalCost() < cheapestAdjacentNode.getEstimatedTotalCost())) continue;
                cheapestAdjacentNode = adjacentNode;
            }
            for (INavMeshAtom atom : cheapestAdjacentNode.getAtom().getNeighbors()) {
                if (exploredNodes.containsKey(atom)) continue;
                adjacentNodes.put(atom, this.heuristic.extend(cheapestAdjacentNode, atom, destinationAtom));
            }
            adjacentNodes.remove(cheapestAdjacentNode.getAtom());
            exploredNodes.put(cheapestAdjacentNode.getAtom(), cheapestAdjacentNode);
        }
        return this.backtrack((NavMeshAStarNode)adjacentNodes.get(destinationAtom));
    }

    public List<ILocated> getPath(ILocated from, ILocated to) {
        List<INavMeshAtom> polygonPath = this.getAtomPath(from, to);
        if (polygonPath == null) {
            return null;
        }
        return this.convertAtomPathToPointPath(from, to, polygonPath, BoundaryCrossingStrategy.SHORTEST);
    }

    protected List<INavMeshAtom> backtrack(NavMeshAStarNode destinationNode) {
        ArrayList<INavMeshAtom> path = new ArrayList<INavMeshAtom>();
        NavMeshAStarNode node = destinationNode;
        while (node != null) {
            path.add(node.getAtom());
            node = node.getPrevious();
        }
        Collections.reverse(path);
        return path;
    }

    protected List<ILocated> convertAtomPathToPointPath(ILocated from, ILocated to, List<INavMeshAtom> atomPath, BoundaryCrossingStrategy boundaryCrossingStrategy) {
        ArrayList<ILocated> path = new ArrayList<ILocated>();
        path.add(from);
        ArrayList polygonSubpath = Lists.newArrayList();
        for (INavMeshAtom atom : atomPath) {
            if (atom instanceof OffMeshPoint) {
                OffMeshPoint point = (OffMeshPoint)atom;
                if (polygonSubpath.size() > 0) {
                    ILocated leadIn = path.size() > 0 ? (ILocated)path.get(path.size() - 1) : from;
                    path.addAll(this.findCrossings(leadIn, polygonSubpath, point, boundaryCrossingStrategy));
                    polygonSubpath.clear();
                }
                path.add(point);
                continue;
            }
            assert (atom instanceof NavMeshPolygon);
            NavMeshPolygon polygon = (NavMeshPolygon)atom;
            if (path.isEmpty() && this.grounder.tryGround((ILocated)from.getLocation()) != polygon) {
                path.add((ILocated)polygon.getCenter());
            }
            polygonSubpath.add(polygon);
        }
        if (polygonSubpath.size() > 0) {
            path.addAll(this.findCrossings((ILocated)path.get(path.size() - 1), polygonSubpath, to, boundaryCrossingStrategy));
        }
        path.add(to);
        return path;
    }

    protected List<ILocated> findCrossings(ILocated leadIn, List<NavMeshPolygon> polygonPath, ILocated leadOut, BoundaryCrossingStrategy boundaryCrossingStrategy) {
        ArrayList boundaries = Lists.newArrayList();
        int i = 0;
        while (i < polygonPath.size() - 1) {
            NavMeshPolygon p1 = polygonPath.get(i);
            NavMeshPolygon p2 = polygonPath.get(i + 1);
            boundaries.add(p1.getAdjPolygonToBoundaryMap().get(p2));
            ++i;
        }
        switch (boundaryCrossingStrategy) {
            case CENTER: {
                return this.findCenterCrossings(leadIn, boundaries, leadOut);
            }
            case SHORTEST: {
                return PolygonPathSmoothingFunnelAlgorithm.findShortestPathCrossings(leadIn, boundaries, leadOut);
            }
        }
        throw new AssertionError((Object)"Unrecognized strategy");
    }

    protected List<ILocated> findCenterCrossings(ILocated leadIn, List<NavMeshBoundary> boundaries, ILocated leadOut) {
        ArrayList crossings = Lists.newArrayList();
        for (NavMeshBoundary boundary : boundaries) {
            LineSegment3D boundaryLs = new LineSegment3D(boundary.getSourceVertex().getLocation().asPoint3D(), boundary.getDestinationVertex().getLocation().asPoint3D());
            crossings.add(new Location(boundaryLs.getPoint(0.5)).addZ(NavMeshConstants.liftPolygonLocation));
        }
        return crossings;
    }

    static enum BoundaryCrossingStrategy {
        CENTER,
        SHORTEST;

    }
}

