/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node;

import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.NavMeshBoundaryInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.construction.IDeferredConstructor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.construction.NodeConstructionCoordinator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshBoundary;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshVertex;
import java.io.Serializable;
import java.util.List;
import math.geom2d.line.LineSegment2D;
import math.geom3d.line.LineSegment3D;

public class NavMeshEdge
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int id;
    protected int index;
    protected NavMeshPolygon polygon;
    protected NavMeshVertex source;
    protected NavMeshVertex destination;
    protected NavMeshBoundary boundary;

    public NavMeshEdge(int id, int index, final int polygonId, final int sourceVertexId, final int destinationVertexId, final NavMeshBoundaryInfo boundaryInfo, final NodeConstructionCoordinator coordinator) {
        this.id = id;
        this.index = index;
        coordinator.addDeferredConstructor(new IDeferredConstructor(){

            @Override
            public void construct() {
                NavMeshEdge.this.polygon = coordinator.getPolygonById(polygonId);
                NavMeshEdge.this.source = coordinator.getVertexById(sourceVertexId);
                NavMeshEdge.this.destination = coordinator.getVertexById(destinationVertexId);
                NavMeshEdge.this.boundary = boundaryInfo != null ? coordinator.getBoundaryByBoundaryInfo(boundaryInfo) : null;
            }
        });
    }

    public NavMeshPolygon getPolygon() {
        return this.polygon;
    }

    public NavMeshVertex getSource() {
        return this.source;
    }

    public NavMeshVertex getDestination() {
        return this.destination;
    }

    public int getIndex() {
        return this.index;
    }

    public NavMeshBoundary getBoundary() {
        return this.boundary;
    }

    public NavMeshEdge getAdjacentEdge() {
        if (this.boundary != null) {
            NavMeshEdge edgeA = this.boundary.getEdgeA();
            NavMeshEdge edgeB = this.boundary.getEdgeB();
            if (edgeA != this) {
                return edgeA;
            }
            return edgeB;
        }
        return null;
    }

    public NavMeshPolygon getAdjacentPolygon() {
        if (this.boundary != null) {
            return this.getAdjacentEdge().getPolygon();
        }
        return null;
    }

    public NavMeshEdge getNextEdge() {
        List<NavMeshEdge> edges = this.getPolygon().getEdges();
        return edges.get((this.index + 1) % edges.size());
    }

    public NavMeshEdge getPreviousEdge() {
        List<NavMeshEdge> edges = this.getPolygon().getEdges();
        return edges.get((this.index - 1 + edges.size()) % edges.size());
    }

    public LineSegment2D asLineSegment2DInXyProjection() {
        return new LineSegment2D(this.source.getLocation().getX(), this.source.getLocation().getY(), this.destination.getLocation().getX(), this.destination.getLocation().getY());
    }

    public LineSegment3D asLineSegment3D() {
        return new LineSegment3D(this.source.getLocation().asPoint3D(), this.destination.getLocation().asPoint3D());
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return "NME( " + this.id + ", " + this.source.toString() + ", " + this.destination.toString() + " )";
    }
}

